/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.router.impl;

import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterContactImpl;
import com.aelitis.azureus.core.dht.router.impl.DHTRouterImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTRouterNodeImpl {
    private DHTRouterImpl router;
    private int depth;
    private boolean contains_router_node_id;
    private List buckets;
    private List replacements;
    private DHTRouterNodeImpl left;
    private DHTRouterNodeImpl right;
    private long last_lookup_time;

    protected DHTRouterNodeImpl(DHTRouterImpl _router, int _depth, boolean _contains_router_node_id, List _buckets) {
        this.router = _router;
        this.depth = _depth;
        this.contains_router_node_id = _contains_router_node_id;
        this.buckets = _buckets;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected boolean containsRouterNodeID() {
        return this.contains_router_node_id;
    }

    protected DHTRouterNodeImpl getLeft() {
        return this.left;
    }

    protected DHTRouterNodeImpl getRight() {
        return this.right;
    }

    protected void split(DHTRouterNodeImpl new_left, DHTRouterNodeImpl new_right) {
        this.buckets = null;
        if (this.replacements != null) {
            Debug.out("DHTRouterNode: inconsistenct - splitting a node with replacements");
        }
        this.left = new_left;
        this.right = new_right;
    }

    protected List getBuckets() {
        return this.buckets;
    }

    protected List getReplacements() {
        return this.replacements;
    }

    protected void addNode(DHTRouterContactImpl node) {
        this.buckets.add(node);
        this.requestNodeAdd(node, false);
    }

    protected DHTRouterContact addReplacement(DHTRouterContactImpl replacement, int max_rep_per_node) {
        int i;
        if (max_rep_per_node == 0) {
            return null;
        }
        boolean try_ping = false;
        if (this.replacements == null) {
            try_ping = true;
            this.replacements = new ArrayList();
        } else if (this.replacements.size() == max_rep_per_node) {
            DHTRouterContactImpl r;
            if (replacement.hasBeenAlive()) {
                for (i = 0; i < this.replacements.size(); ++i) {
                    r = (DHTRouterContactImpl)this.replacements.get(i);
                    if (r.hasBeenAlive()) continue;
                    try_ping = true;
                    this.replacements.remove(i);
                    break;
                }
                if (this.replacements.size() == max_rep_per_node) {
                    this.replacements.remove(0);
                }
            } else {
                for (i = 0; i < this.replacements.size(); ++i) {
                    r = (DHTRouterContactImpl)this.replacements.get(i);
                    if (r.hasBeenAlive()) continue;
                    this.replacements.remove(i);
                    break;
                }
            }
        } else {
            try_ping = true;
        }
        if (this.replacements.size() == max_rep_per_node) {
            return null;
        }
        this.replacements.add(replacement);
        if (try_ping) {
            for (i = 0; i < this.buckets.size(); ++i) {
                DHTRouterContactImpl c = (DHTRouterContactImpl)this.buckets.get(i);
                if (this.router.isID(c.getID()) || c.getPingOutstanding()) continue;
                c.setPingOutstanding(true);
                this.router.requestPing(c);
                break;
            }
        }
        return replacement;
    }

    protected DHTRouterContactImpl updateExistingNode(byte[] node_id, DHTRouterContactAttachment attachment, boolean known_to_be_alive) {
        DHTRouterContactImpl contact;
        int k;
        for (k = 0; k < this.buckets.size(); ++k) {
            int old_id;
            int new_id;
            contact = (DHTRouterContactImpl)this.buckets.get(k);
            if (!Arrays.equals(node_id, contact.getID())) continue;
            if (known_to_be_alive) {
                this.alive(contact);
            }
            if ((new_id = attachment.getInstanceID()) != 0 && (old_id = contact.getAttachment().getInstanceID()) != new_id) {
                DHTLog.log("Instance ID changed for " + DHTLog.getString(contact.getID()) + ": old = " + old_id + ", new = " + new_id);
                contact.setAttachment(attachment);
                this.requestNodeAdd(contact, old_id != 0);
            }
            return contact;
        }
        if (this.replacements != null) {
            for (k = 0; k < this.replacements.size(); ++k) {
                contact = (DHTRouterContactImpl)this.replacements.get(k);
                if (!Arrays.equals(node_id, contact.getID())) continue;
                if (known_to_be_alive) {
                    this.alive(contact);
                }
                return contact;
            }
        }
        return null;
    }

    protected void alive(DHTRouterContactImpl contact) {
        contact.setPingOutstanding(false);
        if (this.buckets.remove(contact)) {
            contact.setAlive();
            this.buckets.add(contact);
        } else if (this.replacements.remove(contact)) {
            long last_time = contact.getFirstFailOrLastAliveTime();
            contact.setAlive();
            if (contact.getLastAliveTime() - last_time > 30000L) {
                for (int i = 0; i < this.buckets.size(); ++i) {
                    DHTRouterContactImpl c = (DHTRouterContactImpl)this.buckets.get(i);
                    if (this.router.isID(c.getID()) || c.getPingOutstanding()) continue;
                    c.setPingOutstanding(true);
                    this.router.requestPing(c);
                    break;
                }
            }
            this.replacements.add(contact);
        }
    }

    protected void dead(DHTRouterContactImpl contact, boolean force) {
        contact.setPingOutstanding(false);
        if (contact.setFailed() || force) {
            if (this.buckets.remove(contact)) {
                if (this.replacements != null && this.replacements.size() > 0) {
                    boolean replaced = false;
                    for (int i = this.replacements.size() - 1; i >= 0; --i) {
                        DHTRouterContactImpl rep = (DHTRouterContactImpl)this.replacements.get(i);
                        if (!rep.hasBeenAlive()) continue;
                        DHTLog.log(DHTLog.getString(contact.getID()) + ": using live replacement " + DHTLog.getString(rep.getID()));
                        this.replacements.remove(rep);
                        this.buckets.add(rep);
                        replaced = true;
                        this.requestNodeAdd(rep, false);
                        break;
                    }
                    if (!replaced) {
                        DHTRouterContactImpl rep = (DHTRouterContactImpl)this.replacements.remove(this.replacements.size() - 1);
                        DHTLog.log(DHTLog.getString(contact.getID()) + ": using unknown replacement " + DHTLog.getString(rep.getID()));
                        this.buckets.add(rep);
                        this.requestNodeAdd(rep, false);
                    }
                }
            } else {
                this.replacements.remove(contact);
            }
        }
    }

    protected void requestNodeAdd(DHTRouterContactImpl contact, boolean definite_change) {
        long now = SystemTime.getCurrentTime();
        if (now - contact.getLastAddedTime() > 10000L) {
            contact.setLastAddedTime(now);
            this.router.requestNodeAdd(contact);
        } else if (definite_change) {
            this.router.log("requestNodeAdd for " + contact.getString() + " denied as too soon after previous ");
        }
    }

    protected long getTimeSinceLastLookup() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_lookup_time) {
            return Long.MAX_VALUE;
        }
        return now - this.last_lookup_time;
    }

    protected void setLastLookupTime() {
        this.last_lookup_time = SystemTime.getCurrentTime();
    }

    public void print(String indent, String prefix) {
        if (this.left == null) {
            this.router.log(indent + prefix + ": buckets = " + this.buckets.size() + this.contactsToString(this.buckets) + ", replacements = " + (this.replacements == null ? "null" : this.replacements.size() + this.contactsToString(this.replacements)) + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : "") + " tsll=" + this.getTimeSinceLastLookup());
        } else {
            this.router.log(indent + prefix + ":" + (this.contains_router_node_id ? " *" : " ") + (this == this.router.getSmallestSubtree() ? "SST" : ""));
            this.left.print(indent + "  ", prefix + "1");
            this.right.print(indent + "  ", prefix + "0");
        }
    }

    protected String contactsToString(List contacts) {
        String res = "{";
        for (int i = 0; i < contacts.size(); ++i) {
            res = res + (i == 0 ? "" : ", ") + ((DHTRouterContactImpl)contacts.get(i)).getString();
        }
        return res + "}";
    }
}

