/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTFactory;
import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.nat.impl.DHTNATPuncherImpl;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.loopback.DHTTransportLoopbackImpl;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.plugins.dht.impl.DHTPluginStorageManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class Test {
    static boolean AELITIS_TEST = false;
    static InetSocketAddress AELITIS_ADDRESS = new InetSocketAddress("213.186.46.164", 6881);
    static int DEFAULT_NETWORK = 1;
    int num_dhts = 3;
    int num_stores = 2;
    static int MAX_VALUES;
    boolean udp_protocol = true;
    int udp_timeout = 1000;
    static int K;
    static int B;
    static int ID_BYTES;
    int fail_percentage = 0;
    static Properties dht_props;
    static byte[] th_key;
    static Map check;
    static DHTLogger logger;
    Map port_map = new HashMap();

    public static DHTLogger getLogger() {
        return logger;
    }

    public static void main(String[] args) {
        new Test();
    }

    protected Test() {
        try {
            int i;
            DHT[] dhts = new DHT[this.num_dhts * 2 + 30];
            DHTTransport[] transports = new DHTTransport[this.num_dhts * 2 + 30];
            for (i = 0; i < this.num_dhts; ++i) {
                this.createDHT(dhts, transports, DEFAULT_NETWORK, i);
            }
            for (i = 0; i < this.num_dhts - 1; ++i) {
                if (AELITIS_TEST) {
                    ((DHTTransportUDP)transports[i]).importContact(AELITIS_ADDRESS, (byte)13);
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream daos = new DataOutputStream(baos);
                    transports[i].getLocalContact().exportContact(daos);
                    daos.close();
                    transports[i + 1].importContact(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
                }
                dhts[i].integrate(true);
                if (i <= 0 || i % 10 != 0) continue;
                System.out.println("Integrated " + i + " DHTs");
            }
            if (AELITIS_TEST) {
                ((DHTTransportUDP)transports[this.num_dhts - 1]).importContact(AELITIS_ADDRESS, (byte)13);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream daos = new DataOutputStream(baos);
                transports[0].getLocalContact().exportContact(daos);
                daos.close();
                transports[this.num_dhts - 1].importContact(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
            }
            dhts[this.num_dhts - 1].integrate(true);
            DHTTransportLoopbackImpl.setFailPercentage(this.fail_percentage);
            HashMap<String, DHT> store_index = new HashMap<String, DHT>();
            for (int i2 = 0; i2 < this.num_stores; ++i2) {
                int dht_index = (int)(Math.random() * (double)this.num_dhts);
                DHT dht = dhts[dht_index];
                dht.put(("" + i2).getBytes(), "", new byte[4], (byte)0, new DHTOperationAdapter());
                store_index.put("" + i2, dht);
                if (i2 == 0 || i2 % 100 != 0) continue;
                System.out.println("Stored " + i2 + " values");
            }
            Timer timer = new Timer("");
            timer.addPeriodicEvent(10000L, new TimerEventPerformer(){

                public void perform(TimerEvent event) {
                    if (!Test.this.udp_protocol) {
                        DHTTransportStats stats = DHTTransportLoopbackImpl.getOverallStats();
                        System.out.println("Overall stats: " + stats.getString());
                    }
                }
            });
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("> ");
                try {
                    String str = reader.readLine().trim();
                    if (str == null) break;
                    int pos = str.indexOf(32);
                    if (pos == -1 || pos == 0) {
                        Test.usage();
                        continue;
                    }
                    int dht_index = (int)(Math.random() * (double)this.num_dhts);
                    DHT dht = dhts[dht_index];
                    String lhs = str.substring(0, pos);
                    String rhs = str.substring(pos + 1);
                    DHTTransportStats stats_before = null;
                    char command = lhs.toLowerCase().charAt(0);
                    if (command == 'p') {
                        pos = rhs.indexOf(61);
                        if (pos == -1) {
                            Test.usage();
                        } else {
                            System.out.println("Using dht " + dht_index);
                            stats_before = dht.getTransport().getStats().snapshot();
                            String key = rhs.substring(0, pos);
                            String val = rhs.substring(pos + 1);
                            dht.put(key.getBytes(), "", val.getBytes(), (byte)(Math.random() * 255.0), new DHTOperationAdapter());
                        }
                    } else if (command == 'x') {
                        dht = (DHT)store_index.get(rhs);
                        if (dht == null) {
                            System.out.println("DHT not found");
                        } else {
                            stats_before = dht.getTransport().getStats().snapshot();
                            byte[] res = dht.remove(rhs.getBytes(), "", new DHTOperationAdapter());
                            if (res != null) {
                                store_index.remove(rhs);
                            }
                            System.out.println("-> " + (res == null ? "null" : new String(res)));
                        }
                    } else if (command == 'e') {
                        dht = (DHT)store_index.get(rhs);
                        if (dht == null) {
                            System.out.println("DHT not found");
                        } else {
                            DataOutputStream daos = new DataOutputStream(new FileOutputStream("C:\\temp\\dht.state"));
                            dht.exportState(daos, 0);
                            daos.close();
                        }
                    } else if (command == 'g') {
                        System.out.println("Using dht " + dht_index);
                        stats_before = dht.getTransport().getStats().snapshot();
                        dht.get(rhs.getBytes(), "", (byte)0, 32, 0L, false, new DHTOperationAdapter(){

                            public void read(DHTTransportContact contact, DHTTransportValue value) {
                                System.out.println("-> " + new String(value.getValue()));
                            }

                            public void complete(boolean timeout) {
                                System.out.println("-> complete");
                            }
                        });
                    } else if (command == 'd') {
                        System.out.println("Using dht " + dht_index);
                        stats_before = dht.getTransport().getStats().snapshot();
                        byte[] res = dht.remove(rhs.getBytes(), "", new DHTOperationAdapter());
                        System.out.println("-> " + (res == null ? "null" : new String(res)));
                    } else if (command == 'z') {
                        System.out.println("Using dht " + dht_index);
                        stats_before = dht.getTransport().getStats().snapshot();
                        dht.get(rhs.getBytes(), "", (byte)0, 10, 0L, false, new DHTOperationListener(){

                            public void searching(DHTTransportContact contact, int level, int active_searches) {
                            }

                            public void found(DHTTransportContact contact) {
                            }

                            public void read(DHTTransportContact contact, DHTTransportValue value) {
                                System.out.println("-> " + value.getString());
                                new AEThread(this, "blah", contact){
                                    private final /* synthetic */ DHTTransportContact val$contact;
                                    private final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$contact = val$contact;
                                        super(x0);
                                    }

                                    public void runSupport() {
                                        DHTTransportFullStats stats = this.val$contact.getStats();
                                        System.out.println("    stats = " + stats.getString());
                                    }
                                }.start();
                            }

                            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
                            }

                            public void complete(boolean timeout) {
                                System.out.println("complete");
                            }
                        });
                    } else if (command == 'v') {
                        try {
                            int index = Integer.parseInt(rhs);
                            dht = dhts[index];
                            stats_before = dht.getTransport().getStats().snapshot();
                            dht.print();
                            List l = dht.getControl().getContacts();
                            for (int i3 = 0; i3 < l.size(); ++i3) {
                                DHTControlContact c = (DHTControlContact)l.get(i3);
                                System.out.println("  contact:" + c.getRouterContact().getString() + "/" + c.getTransportContact().getString());
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    } else if (command == 't') {
                        try {
                            int index = Integer.parseInt(rhs);
                            dht = dhts[index];
                            stats_before = dht.getTransport().getStats().snapshot();
                            ((DHTTransportUDPImpl)transports[index]).testInstanceIDChange();
                            dht.integrate(true);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    } else if (command == 's') {
                        try {
                            int index = Integer.parseInt(rhs);
                            dht = dhts[index];
                            stats_before = dht.getTransport().getStats().snapshot();
                            ((DHTTransportUDPImpl)transports[index]).testTransportIDChange();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    } else if (command == 'a') {
                        int net = DEFAULT_NETWORK;
                        try {
                            net = Integer.parseInt(rhs);
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        this.createDHT(dhts, transports, net, this.num_dhts++);
                        dht = dhts[this.num_dhts - 1];
                        stats_before = transports[this.num_dhts - 1].getStats().snapshot();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        DataOutputStream daos = new DataOutputStream(baos);
                        ArrayList<DHTTransport> ok_t = new ArrayList<DHTTransport>();
                        for (int i4 = 0; i4 < this.num_dhts - 1; ++i4) {
                            DHTTransport t = transports[i4];
                            if (t.getNetwork() != net) continue;
                            ok_t.add(t);
                        }
                        if (ok_t.size() > 0) {
                            DHTTransport r_t = (DHTTransport)ok_t.get((int)(Math.random() * (double)(ok_t.size() - 1)));
                            r_t.getLocalContact().exportContact(daos);
                            daos.close();
                            transports[this.num_dhts - 1].importContact(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
                        } else {
                            System.out.println("No comaptible networks found");
                        }
                        dht.integrate(true);
                        dht.print();
                    } else if (command == 'r') {
                        System.out.println("read - dht0 -> dht1");
                        byte[] res = dhts[0].getTransport().readTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long size) {
                                System.out.println("   read size: " + size);
                            }

                            public void reportActivity(String str) {
                                System.out.println("   read act: " + str);
                            }

                            public void reportCompleteness(int percent) {
                                System.out.println("   read %: " + percent);
                            }
                        }, dhts[1].getTransport().getLocalContact(), th_key, new byte[]{1, 2, 3, 4}, 30000L);
                        System.out.println("res = " + res);
                    } else if (command == 'w') {
                        System.out.println("write - dht0 -> dht1");
                        dhts[0].getTransport().writeTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long size) {
                                System.out.println("   write size: " + size);
                            }

                            public void reportActivity(String str) {
                                System.out.println("   write act: " + str);
                            }

                            public void reportCompleteness(int percent) {
                                System.out.println("   write %: " + percent);
                            }
                        }, dhts[1].getTransport().getLocalContact(), th_key, new byte[]{1, 2, 3, 4}, new byte[1000], 60000L);
                    } else if (command == 'c') {
                        System.out.println("call - dht0 <-> dht1");
                        byte[] res = dhts[0].getTransport().writeReadTransfer(new DHTTransportProgressListener(){

                            public void reportSize(long size) {
                                System.out.println("   readWrite size: " + size);
                            }

                            public void reportActivity(String str) {
                                System.out.println("   readWrite act: " + str);
                            }

                            public void reportCompleteness(int percent) {
                                System.out.println("   readWrite %: " + percent);
                            }
                        }, dhts[1].getTransport().getLocalContact(), th_key, new byte[1000], 60000L);
                        System.out.println("    reply: len = " + res.length);
                    } else if (command == 'b') {
                        if (rhs.equals("1")) {
                            System.out.println("rendezvous bind: dht2 -> rdv dht1");
                            DHTNATPuncherImpl puncher = (DHTNATPuncherImpl)dhts[2].getNATPuncher();
                            puncher.setRendezvous(dhts[2].getTransport().getLocalContact(), dhts[1].getTransport().getLocalContact());
                        } else if (rhs.equals("2")) {
                            System.out.println("rendezvous punch: dht0 -> rdv dht2");
                            DHTNATPuncherImpl puncher = (DHTNATPuncherImpl)dhts[0].getNATPuncher();
                            puncher.punch(dhts[2].getTransport().getLocalContact());
                        }
                    } else {
                        Test.usage();
                    }
                    if (stats_before == null) continue;
                    DHTTransportStats stats_after = dht.getTransport().getStats().snapshot();
                    System.out.println("before:" + stats_before.getString());
                    System.out.println("after:" + stats_after.getString());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void createDHT(DHT[] dhts, DHTTransport[] transports, int network, int i) throws DHTTransportException {
        DHT dht;
        DHTTransport transport;
        if (this.udp_protocol) {
            Integer next_port = (Integer)this.port_map.get(new Integer(network));
            next_port = next_port == null ? new Integer(0) : new Integer(next_port + 1);
            this.port_map.put(new Integer(network), next_port);
            byte protocol = network == 0 ? (byte)13 : 13;
            transport = DHTTransportFactory.createUDP(protocol, network, null, null, 6890 + next_port, 5, 3, this.udp_timeout, 50, 25, false, false, logger);
        } else {
            transport = DHTTransportFactory.createLoopback(ID_BYTES);
        }
        transport.registerTransferHandler(th_key, new DHTTransportTransferHandler(){

            public byte[] handleRead(DHTTransportContact originator, byte[] key) {
                byte[] data = new byte[1000];
                System.out.println("handle read -> length = " + data.length);
                return data;
            }

            public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
                byte[] reply = null;
                if (value.length == 1000) {
                    reply = new byte[4];
                }
                System.out.println("handle write -> length = " + value.length + ", reply = " + reply);
                return reply;
            }
        });
        DHTPluginStorageManager storage_adapter = new DHTPluginStorageManager(logger, new File("C:\\temp\\dht\\" + i));
        dhts[i] = dht = DHTFactory.create(transport, dht_props, storage_adapter, logger);
        transports[i] = transport;
    }

    public DHTStorageKey keyCreated(HashWrapper key, boolean local) {
        System.out.println("key created");
        return new DHTStorageKey(){

            public byte getDiversificationType() {
                return 1;
            }
        };
    }

    public void keyDeleted(DHTStorageKey key) {
        System.out.println("key deleted");
    }

    public void keyRead(DHTStorageKey adapter_key, DHTTransportContact contact) {
        System.out.println("value read");
    }

    public void valueAdded(DHTStorageKey key, DHTTransportValue value) {
        System.out.println("value added");
    }

    public void valueUpdated(DHTStorageKey key, DHTTransportValue old_value, DHTTransportValue new_value) {
        System.out.println("value updated");
    }

    public void valueDeleted(DHTStorageKey key, DHTTransportValue value) {
        System.out.println("value deleted");
    }

    public byte[][] getExistingDiversification(byte[] key, boolean put_operation) {
        System.out.println("getExistingDiversification: put = " + put_operation);
        return new byte[][]{key};
    }

    public byte[][] createNewDiversification(byte[] key, boolean put_operation, int diversification_type) {
        System.out.println("createNewDiversification: put = " + put_operation + ", type = " + diversification_type);
        return new byte[0][];
    }

    protected static void usage() {
        System.out.println("syntax: [p g] <key>[=<value>]");
    }

    static {
        DHTTransportUDPImpl.TEST_EXTERNAL_IP = true;
        MAX_VALUES = 10000;
        K = 20;
        B = 5;
        ID_BYTES = 20;
        dht_props = new Properties();
        dht_props.put("EntriesPerNode", new Integer(K));
        dht_props.put("NodeSplitFactor", new Integer(B));
        dht_props.put("CacheRepublishInterval", new Integer(30000));
        dht_props.put("OriginalRepublishInterval", new Integer(60000));
        th_key = new byte[]{1, 1, 1, 1};
        check = new HashMap();
        final LoggerChannel c_logger = AzureusCoreFactory.create().getPluginManager().getDefaultPluginInterface().getLogger().getNullChannel("test");
        c_logger.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String content) {
                System.out.println(content);
            }

            public void messageLogged(String str, Throwable error) {
                System.out.println(str);
                error.printStackTrace();
            }
        });
        logger = new DHTLogger(){

            public void log(String str) {
                c_logger.log(str);
            }

            public void log(Throwable e) {
                c_logger.log(e);
            }

            public void log(int log_type, String str) {
                if (this.isEnabled(log_type)) {
                    c_logger.log(str);
                }
            }

            public boolean isEnabled(int log_type) {
                return true;
            }

            public PluginInterface getPluginInterface() {
                return c_logger.getLogger().getPluginInterface();
            }
        };
    }
}

