/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.welcome;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class WelcomeWindow {
    public static final int WELCOME_VERSION = 2500;
    public static final String WELCOME_VERSION_STRING = Constants.AZUREUS_VERSION;
    private static final String lineSeparator = System.getProperty("line.separator");
    Display display;
    Shell shell = ShellFactory.createShell(2160);
    Color black;
    Color white;
    Color light;
    Color grey;
    Color green;
    Color blue;
    Color fg;
    Color bg;

    public WelcomeWindow() {
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.shell.setText(MessageText.getString("window.welcome.title", new String[]{WELCOME_VERSION_STRING}));
        this.display = this.shell.getDisplay();
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        StyledText helpPanel = new StyledText((Composite)this.shell, 2560);
        GridData data = new GridData(1808);
        helpPanel.setLayoutData((Object)data);
        helpPanel.setEditable(false);
        try {
            String helpText = "";
            String helpFile = MessageText.getString("window.welcome.file");
            InputStream stream = this.getClass().getResourceAsStream("/org/gudy/azureus2/internat/whatsnew/" + helpFile);
            if (stream == null) {
                System.err.println("Welcome Window: Error loading resource: /org/gudy/azureus2/internat/whatsnew/" + helpFile);
            } else {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(stream));
                helpPanel.setRedraw(false);
                helpPanel.setWordWrap(true);
                this.black = new Color((Device)this.display, 0, 0, 0);
                this.white = new Color((Device)this.display, 255, 255, 255);
                this.light = new Color((Device)this.display, 200, 200, 200);
                this.grey = new Color((Device)this.display, 50, 50, 50);
                this.green = new Color((Device)this.display, 30, 80, 30);
                this.blue = new Color((Device)this.display, 20, 20, 80);
                helpPanel.setForeground(this.grey);
                while ((line = in.readLine()) != null) {
                    String text;
                    int styleChar;
                    boolean setStyle = false;
                    this.fg = this.grey;
                    this.bg = this.white;
                    int style = 0;
                    if (line.length() < 2) {
                        styleChar = 32;
                        text = " " + lineSeparator;
                    } else {
                        styleChar = line.charAt(0);
                        text = line.substring(1) + lineSeparator;
                    }
                    switch (styleChar) {
                        case 42: {
                            text = "  * " + text;
                            this.fg = this.green;
                            setStyle = true;
                            break;
                        }
                        case 43: {
                            text = "     " + text;
                            this.fg = this.black;
                            this.bg = this.light;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 33: {
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 64: {
                            this.fg = this.blue;
                            setStyle = true;
                            break;
                        }
                        case 36: {
                            this.bg = this.blue;
                            this.fg = this.white;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 32: {
                            text = "  " + text;
                        }
                    }
                    helpPanel.append(text);
                    if (!setStyle) continue;
                    int lineCount = helpPanel.getLineCount() - 1;
                    int charCount = helpPanel.getCharCount();
                    int lineOfs = helpPanel.getOffsetAtLine(lineCount - 1);
                    int lineLen = charCount - lineOfs;
                    helpPanel.setStyleRange(new StyleRange(lineOfs, lineLen, this.fg, this.bg, style));
                    helpPanel.setLineBackground(lineCount - 1, 1, this.bg);
                }
            }
            helpPanel.setRedraw(true);
        }
        catch (Exception e) {
            System.out.println("Unable to load help contents because:" + e);
        }
        Button bClose = new Button((Composite)this.shell, 8);
        bClose.setText(MessageText.getString("Button.close"));
        data = new GridData();
        data.widthHint = 70;
        data.horizontalAlignment = 131072;
        bClose.setLayoutData((Object)data);
        Listener closeListener = new Listener(){

            public void handleEvent(Event event2) {
                WelcomeWindow.this.close();
            }
        };
        bClose.addListener(13, closeListener);
        this.shell.addListener(21, closeListener);
        this.shell.setDefaultButton(bClose);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    WelcomeWindow.this.close();
                }
            }
        });
        this.shell.setSize(500, 400);
        Utils.centreWindow(this.shell);
        this.shell.layout();
        this.shell.open();
    }

    private void close() {
        if (this.black != null && !this.black.isDisposed()) {
            this.black.dispose();
        }
        if (this.white != null && !this.white.isDisposed()) {
            this.white.dispose();
        }
        if (this.light != null && !this.light.isDisposed()) {
            this.light.dispose();
        }
        if (this.grey != null && !this.grey.isDisposed()) {
            this.grey.dispose();
        }
        if (this.green != null && !this.green.isDisposed()) {
            this.green.dispose();
        }
        if (this.blue != null && !this.blue.isDisposed()) {
            this.blue.dispose();
        }
        this.shell.dispose();
    }
}

