/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerFactory;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerFactoryImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerBTAnnouncerImpl
extends TRTrackerAnnouncerImpl {
    private static final int OVERRIDE_PERIOD = 10000;
    protected static Timer tracker_timer = new Timer("Tracker Timer", 32);
    public static String UDP_REALM = "UDP Tracker";
    private static AEMonitor class_mon;
    private static Map tracker_report_map;
    private TOTorrent torrent;
    private TimerEvent current_timer_event;
    private TimerEventPerformer timer_event_action;
    protected int tracker_state = 1;
    private String tracker_status_str = "";
    private TRTrackerAnnouncerResponse last_response = null;
    private long last_update_time_secs;
    private long current_time_to_wait_secs;
    private boolean manual_control;
    private long min_interval = 0L;
    private int failure_added_time = 0;
    private long failure_time_last_updated = 0L;
    private boolean stopped;
    private boolean stopped_for_queue;
    private boolean completed;
    private boolean complete_reported = false;
    private boolean update_in_progress = false;
    private long rd_last_override = 0L;
    private int rd_override_percentage = 100;
    private long min_interval_override = 0L;
    private List trackerUrlLists;
    private URL lastUsedUrl;
    private HashWrapper torrent_hash;
    private String last_tracker_message;
    private String info_hash = "info_hash=";
    private byte[] tracker_peer_id;
    private String tracker_peer_id_str = "&peer_id=";
    private byte[] data_peer_id;
    private String key_id = "";
    private static final int key_id_length = 8;
    private int key_udp;
    private String tracker_id = "";
    private String ip_override;
    private String[] peer_networks;
    private TRTrackerAnnouncerDataProvider announce_data_provider;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerBTAnnouncer");
    protected boolean destroyed;
    static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static String createKeyID() {
        String key_id = "";
        for (int i = 0; i < 8; ++i) {
            int pos = (int)(Math.random() * (double)chars.length());
            key_id = key_id + chars.charAt(pos);
        }
        return key_id;
    }

    public TRTrackerBTAnnouncerImpl(TOTorrent _torrent, String[] _peer_networks, boolean _manual) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.peer_networks = _peer_networks;
        this.manual_control = _manual;
        this.constructTrackerUrlLists(true);
        try {
            this.tracker_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, true);
            this.data_peer_id = COConfigurationManager.getBooleanParameter("Tracker Separate Peer IDs", false) ? ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false) : this.tracker_peer_id;
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
        this.key_id = TRTrackerBTAnnouncerImpl.createKeyID();
        this.key_udp = (int)(Math.random() * 4.294967295E9);
        try {
            this.torrent_hash = _torrent.getHashWrapper();
            this.info_hash = this.info_hash + URLEncoder.encode(new String(this.torrent_hash.getBytes(), "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
            this.tracker_peer_id_str = this.tracker_peer_id_str + URLEncoder.encode(new String(this.tracker_peer_id, "ISO-8859-1"), "ISO-8859-1").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "URL encode fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        catch (TOTorrentException e) {
            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Torrent hash retrieval fails", (Throwable)e));
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: URL encode fails");
        }
        this.timer_event_action = new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void perform(TimerEvent this_event) {
                if (TRTrackerBTAnnouncerImpl.access$000(TRTrackerBTAnnouncerImpl.this)) {
                    TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    return;
                }
                secs_to_wait = TRTrackerBTAnnouncerImpl.this.getErrorRetryInterval();
                try {
                    secs_to_wait = TRTrackerBTAnnouncerImpl.this.requestUpdateSupport();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$100(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (unadjusted) will be in " + secs_to_wait + "s"));
                    }
                    var5_3 = null;
                }
                catch (Throwable var4_9) {
                    var5_4 = null;
                    TRTrackerBTAnnouncerImpl.access$202(TRTrackerBTAnnouncerImpl.this, secs_to_wait);
                    if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                        block17: {
                            block18: {
                                block19: {
                                    try {
                                        TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                                        if (this_event.isCancelled()) break block17;
                                        secs_to_wait = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$100(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (adjusted) will be in " + secs_to_wait + "s"));
                                        }
                                        target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                                        if (TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this) == null || TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).isCancelled()) break block18;
                                        if (TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this) == this_event || TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).getWhen() >= target_time) break block19;
                                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                                        return;
                                    }
lbl29:
                                    // 2 sources

                                    catch (Throwable var8_8) {
                                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                                        throw var8_8;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [3 : 275->312)] { 
lbl34:
                                // 1 sources

                                TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).cancel();
                            }
                            if (!TRTrackerBTAnnouncerImpl.this.destroyed) {
                                TRTrackerBTAnnouncerImpl.access$302(TRTrackerBTAnnouncerImpl.this, TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(target_time, this));
                            }
                        }
                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                    }
                    throw var4_9;
                }
                TRTrackerBTAnnouncerImpl.access$202(TRTrackerBTAnnouncerImpl.this, secs_to_wait);
                if (TRTrackerBTAnnouncerImpl.this.tracker_state != 4) {
                    try {
                        TRTrackerBTAnnouncerImpl.this.this_mon.enter();
                        if (this_event.isCancelled()) {
                        }
                        secs_to_wait = TRTrackerBTAnnouncerImpl.this.getAdjustedSecsToWait();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(TRTrackerBTAnnouncerImpl.access$100(TRTrackerBTAnnouncerImpl.this), TRTrackerAnnouncerImpl.LOGID, "Next tracker announce (adjusted) will be in " + secs_to_wait + "s"));
                        }
                        target_time = SystemTime.getCurrentTime() + secs_to_wait * 1000L;
                        if (TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this) != null && !TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).isCancelled()) {
                            if (TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this) != this_event && TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).getWhen() < target_time) {
                                return;
                            }
                            TRTrackerBTAnnouncerImpl.access$300(TRTrackerBTAnnouncerImpl.this).cancel();
                        }
                        if (TRTrackerBTAnnouncerImpl.this.destroyed) ** GOTO lbl66
                        TRTrackerBTAnnouncerImpl.access$302(TRTrackerBTAnnouncerImpl.this, TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(target_time, this));
                    }
                    finally {
                        TRTrackerBTAnnouncerImpl.this.this_mon.exit();
                    }
                }
            }
        };
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer Created using url : " + this.trackerURLListToString()));
        }
    }

    protected long getAdjustedSecsToWait() {
        long secs_to_wait = this.current_time_to_wait_secs;
        if (this.last_response != null && this.last_response.getStatus() != 2) {
            if (this.last_response.getStatus() == 1) {
                if (this.failure_added_time < 900) {
                    this.failure_added_time = 900;
                }
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker reported error, adjusting to error retry interval"));
                }
            } else {
                secs_to_wait = this.getErrorRetryInterval();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: tracker seems to be offline, adjusting to error retry interval"));
                }
            }
        } else {
            if (this.rd_override_percentage == 0) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = 0"));
                }
                return 60L;
            }
            if (this.rd_override_percentage != 100) {
                secs_to_wait = secs_to_wait * (long)this.rd_override_percentage / 100L;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: override, perc = " + this.rd_override_percentage));
                }
            }
            if (secs_to_wait < 60L) {
                secs_to_wait = 60L;
            }
            if (this.min_interval != 0L && secs_to_wait < this.min_interval) {
                float percentage = (float)this.min_interval / (float)this.current_time_to_wait_secs;
                int added_secs = (int)((float)(this.min_interval - secs_to_wait) * percentage);
                secs_to_wait += (long)added_secs;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "MIN INTERVAL CALC: min_interval=" + this.min_interval + ", interval=" + this.current_time_to_wait_secs + ", orig=" + this.current_time_to_wait_secs + ", new=" + secs_to_wait + ", added=" + added_secs + ", perc=" + percentage));
                }
            }
        }
        return secs_to_wait;
    }

    public int getStatus() {
        return this.tracker_state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRefreshDelayOverrides(int percentage) {
        boolean override_allowed;
        if (percentage > 100) {
            percentage = 100;
        } else if (percentage < 0) {
            percentage = 0;
        }
        long now = SystemTime.getCurrentTime();
        boolean bl = override_allowed = this.rd_last_override > 0L && now - this.rd_last_override > 10000L;
        if (now < this.rd_last_override) {
            override_allowed = true;
        }
        if (override_allowed && this.rd_override_percentage != percentage) {
            try {
                this.this_mon.enter();
                this.rd_last_override = now;
                this.rd_override_percentage = percentage;
                if (this.current_timer_event != null && !this.current_timer_event.isCancelled()) {
                    long start = this.current_timer_event.getCreatedTime();
                    long expiry = this.current_timer_event.getWhen();
                    long secs_to_wait = this.getAdjustedSecsToWait();
                    long target_time = start + secs_to_wait * 1000L;
                    if (target_time != expiry) {
                        this.current_timer_event.cancel();
                        if (!this.destroyed) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "Changed next tracker announce to " + secs_to_wait + "s via " + Debug.getStackTrace(true, false, 0, 3)));
                            }
                            this.current_timer_event = tracker_timer.addEvent(start, target_time, this.timer_event_action);
                        }
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeUntilNextUpdate() {
        try {
            int rem;
            this.this_mon.enter();
            if (this.current_timer_event == null) {
                int n = this.getErrorRetryInterval();
                return n;
            }
            int n = rem = (int)((this.current_timer_event.getWhen() - SystemTime.getCurrentTime()) / 1000L);
            return n;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getLastUpdateTime() {
        return (int)this.last_update_time_secs;
    }

    public void update(boolean force) {
        long effective_min;
        long now = SystemTime.getCurrentTime() / 1000L;
        if (now < this.last_update_time_secs) {
            force = true;
        }
        long l = effective_min = this.min_interval_override > 0L ? this.min_interval_override : 60L;
        if (this.manual_control || force || now - this.last_update_time_secs >= effective_min) {
            this.requestUpdate();
        }
    }

    public void complete(boolean already_reported) {
        this.complete_reported = this.complete_reported || already_reported;
        this.completed = true;
        this.requestUpdate();
    }

    public void stop(boolean for_queue) {
        this.stopped = true;
        this.stopped_for_queue = for_queue;
        this.requestUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestUpdate() {
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null) {
                this.current_timer_event.cancel();
            }
            this.rd_last_override = SystemTime.getCurrentTime();
            if (!this.destroyed) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Forcing tracker announce now via " + Debug.getStackTrace(true, false, 0, 3)));
                }
                this.current_timer_event = tracker_timer.addEvent(SystemTime.getCurrentTime(), this.timer_event_action);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long requestUpdateSupport() {
        boolean clear_progress = true;
        try {
            try {
                this.this_mon.enter();
                if (this.update_in_progress || this.announce_data_provider == null) {
                    clear_progress = false;
                    long l = this.getErrorRetryInterval();
                    return l;
                }
                this.update_in_progress = true;
            }
            finally {
                this.this_mon.exit();
            }
            this.last_update_time_secs = SystemTime.getCurrentTime() / 1000L;
            this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
            TRTrackerAnnouncerResponse response = null;
            if (this.stopped) {
                if (this.tracker_state == 1) {
                    this.tracker_state = 4;
                } else if (this.tracker_state != 4) {
                    response = this.stopSupport();
                    this.tracker_state = response.getStatus() == 2 ? 4 : 4;
                }
            } else if (this.tracker_state == 1) {
                response = this.startSupport();
                if (response.getStatus() == 2) {
                    this.tracker_state = 2;
                }
            } else if (this.completed) {
                if (!this.complete_reported) {
                    response = this.completeSupport();
                    if (response.getStatus() != 0) {
                        this.complete_reported = true;
                        this.tracker_state = 3;
                    }
                } else {
                    this.tracker_state = 3;
                    response = this.updateSupport();
                }
            } else {
                response = this.updateSupport();
            }
            if (response != null) {
                int rs = response.getStatus();
                if (rs == 0) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.offline");
                } else if (rs == 1) {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.error");
                    this.tracker_state = 1;
                } else {
                    this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
                }
                String reason = response.getAdditionalInfo();
                if (reason != null) {
                    this.tracker_status_str = this.tracker_status_str + " (" + reason + ")";
                }
                this.last_response = response;
                this.listeners.dispatch(1, response);
                long l = response.getTimeToWait();
                return l;
            }
            this.tracker_status_str = "";
            long l = this.getErrorRetryInterval();
            return l;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            long l = this.getErrorRetryInterval();
            return l;
        }
        finally {
            try {
                this.this_mon.enter();
                if (clear_progress) {
                    this.update_in_progress = false;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected TRTrackerAnnouncerResponse startSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a start Request"));
        }
        return this.update("started");
    }

    protected TRTrackerAnnouncerResponse completeSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a completed Request"));
        }
        return this.update("completed");
    }

    protected TRTrackerAnnouncerResponse stopSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending a stopped Request"));
        }
        return this.update("stopped");
    }

    protected TRTrackerAnnouncerResponse updateSupport() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is sending an update Request"));
        }
        return this.update("");
    }

    private TRTrackerAnnouncerResponse update(String evt) {
        TRTrackerAnnouncerResponseImpl resp = this.update2(evt);
        TRTrackerAnnouncerResponsePeer[] peers = resp.getPeers();
        if (peers != null) {
            ArrayList<TRTrackerAnnouncerResponsePeer> p = new ArrayList<TRTrackerAnnouncerResponsePeer>();
            for (int i = 0; i < peers.length; ++i) {
                TRTrackerAnnouncerResponsePeer peer = peers[i];
                if (this.peer_networks == null) {
                    p.add(peer);
                    continue;
                }
                String peer_address = peer.getAddress();
                String peer_network = AENetworkClassifier.categoriseAddress(peer_address);
                boolean added = false;
                for (int j = 0; j < this.peer_networks.length; ++j) {
                    if (this.peer_networks[j] != peer_network) continue;
                    p.add(peer);
                    added = true;
                    break;
                }
                if (added || !Logger.isEnabled()) continue;
                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Tracker Announcer dropped peer '" + peer_address + "' as incompatible " + "with network selection"));
            }
            peers = new TRTrackerAnnouncerResponsePeer[p.size()];
            p.toArray(peers);
            resp.setPeers(peers);
        }
        return resp;
    }

    private TRTrackerAnnouncerResponseImpl update2(String evt) {
        int num_want;
        TRTrackerAnnouncerResponsePeer[] cached_peers;
        TRTrackerAnnouncerResponseImpl last_failure_resp = null;
        block5: for (int i = 0; i < this.trackerUrlLists.size(); ++i) {
            List urls = (List)this.trackerUrlLists.get(i);
            for (int j = 0; j < urls.size(); ++j) {
                URL original_url;
                this.lastUsedUrl = original_url = (URL)urls.get(j);
                URL request_url = null;
                try {
                    request_url = this.constructUrl(evt, original_url);
                    URL[] tracker_url = new URL[]{original_url};
                    byte[] result_bytes = this.updateOld(tracker_url, request_url);
                    this.lastUsedUrl = tracker_url[0];
                    TRTrackerAnnouncerResponseImpl resp = this.decodeTrackerResponse(this.lastUsedUrl, result_bytes);
                    if (resp.getStatus() == 2) {
                        try {
                            if (!original_url.toString().equals(this.lastUsedUrl.toString())) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(this.torrent, LOGID, "announce url permanently redirected: old = " + original_url + ", new = " + this.lastUsedUrl));
                                }
                                TorrentUtils.replaceAnnounceURL(this.torrent, original_url, this.lastUsedUrl);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        urls.remove(j);
                        urls.add(0, this.lastUsedUrl);
                        this.trackerUrlLists.remove(i);
                        this.trackerUrlLists.add(0, urls);
                        this.informURLChange(this.lastUsedUrl, false);
                        return resp;
                    }
                    last_failure_resp = resp;
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                    last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "malformed URL '" + (request_url == null ? "<null>" : request_url.toString()) + "'");
                }
                catch (Exception e) {
                    last_failure_resp = new TRTrackerAnnouncerResponseImpl(original_url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), e.getMessage() == null ? e.toString() : e.getMessage());
                }
                if (this.destroyed) break block5;
            }
        }
        if (last_failure_resp == null) {
            last_failure_resp = new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Reason Unknown");
        }
        if ((cached_peers = this.getPeersFromCache(num_want = this.calculateNumWant() * 4)).length > 0) {
            last_failure_resp.setPeers(cached_peers);
        }
        return last_failure_resp;
    }

    private byte[] updateOld(URL[] tracker_url, URL reqUrl) throws Exception {
        TorrentUtils.setTLSTorrentHash(this.torrent_hash);
        for (int i = 0; i < 2; ++i) {
            String failure_reason = null;
            try {
                String protocol = reqUrl.getProtocol();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer is Requesting: " + reqUrl));
                }
                ByteArrayOutputStream message = new ByteArrayOutputStream();
                failure_reason = protocol.equalsIgnoreCase("udp") ? this.announceUDP(reqUrl, message) : this.announceHTTP(tracker_url, reqUrl, message);
                if (message.size() > 0) {
                    return message.toByteArray();
                }
                if (failure_reason == null) {
                    failure_reason = "No data received from tracker";
                }
            }
            catch (SSLException e) {
                if (i == 0) {
                    if (SESecurityManager.installServerCertificates(reqUrl) != null) continue;
                    failure_reason = this.exceptionToString(e);
                } else {
                    failure_reason = this.exceptionToString(e);
                }
            }
            catch (Exception e) {
                failure_reason = this.exceptionToString(e);
            }
            if (failure_reason.indexOf("401") != -1) {
                failure_reason = "Tracker authentication failed";
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Exception while processing the Tracker Request : " + failure_reason));
            }
            throw new Exception(failure_reason);
        }
        throw new Exception("Internal Error: should never get here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String announceHTTP(URL[] tracker_url, URL reqUrl, ByteArrayOutputStream message) throws IOException {
        HttpURLConnection con;
        TRTrackerUtils.checkForBlacklistedURLs(reqUrl);
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        reqUrl = AddressUtils.adjustURL(reqUrl);
        String failure_reason = null;
        Properties http_properties = new Properties();
        http_properties.put("URL", reqUrl);
        try {
            ClientIDManagerImpl.getSingleton().generateHTTPProperties(http_properties);
        }
        catch (ClientIDException e) {
            throw new IOException(e.getMessage());
        }
        reqUrl = (URL)http_properties.get("URL");
        if (reqUrl.getProtocol().equalsIgnoreCase("https")) {
            HttpsURLConnection ssl_con = (HttpsURLConnection)reqUrl.openConnection();
            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String host, SSLSession session) {
                    return true;
                }
            });
            con = ssl_con;
        } else {
            con = (HttpURLConnection)reqUrl.openConnection();
        }
        String user_agent = (String)http_properties.get("User-Agent");
        if (user_agent != null) {
            con.setRequestProperty("User-Agent", user_agent);
        }
        con.setRequestProperty("Connection", "close");
        con.addRequestProperty("Accept-Encoding", "gzip");
        try {
            con.connect();
            InputStream is = null;
            try {
                String encoding;
                boolean gzip;
                String marker;
                int pos;
                is = con.getInputStream();
                String resulting_url_str = con.getURL().toString();
                if (!reqUrl.toString().equals(resulting_url_str) && (pos = resulting_url_str.indexOf(marker = "permredirect=1")) != -1) {
                    --pos;
                    try {
                        URL redirect_url;
                        tracker_url[0] = redirect_url = new URL(resulting_url_str.substring(0, pos));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                boolean bl = gzip = (encoding = con.getHeaderField("content-encoding")) != null && encoding.equalsIgnoreCase("gzip");
                if (gzip) {
                    is = new GZIPInputStream(is);
                }
                int content_length = -1;
                byte[] data = new byte[1024];
                int num_read = 0;
                while (content_length <= 0 || num_read < content_length) {
                    try {
                        int len = is.read(data);
                        if (len > 0) {
                            message.write(data, 0, len);
                            if ((num_read += len) <= 131072) continue;
                            message.reset();
                            throw new Exception("Tracker response invalid (too large)");
                        }
                        if (len != 0) break;
                        Thread.sleep(20L);
                    }
                    catch (Exception e) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, "Exception while Requesting Tracker", (Throwable)e));
                            Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Message Received was : " + message));
                        }
                        failure_reason = this.exceptionToString(e);
                        break;
                    }
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Tracker Announcer [" + this.lastUsedUrl + "] has received : " + message));
                }
            }
            catch (Exception e) {
                failure_reason = this.exceptionToString(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                    is = null;
                }
            }
        }
        finally {
            con.disconnect();
        }
        return failure_reason;
    }

    protected String announceUDP(URL reqUrl, ByteArrayOutputStream message) throws IOException {
        reqUrl = TRTrackerUtils.adjustURLForHosting(reqUrl);
        String failure_reason = null;
        PasswordAuthentication auth = null;
        try {
            if (reqUrl.getQuery().toLowerCase().indexOf("auth") != -1) {
                auth = SESecurityManager.getPasswordAuthentication(UDP_REALM, reqUrl);
            }
            PRUDPPacketHandler handler = PRUDPPacketHandlerFactory.getHandler(UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber());
            InetSocketAddress destination = new InetSocketAddress(reqUrl.getHost(), reqUrl.getPort() == -1 ? 80 : reqUrl.getPort());
            for (int retry_loop = 0; retry_loop < 1; ++retry_loop) {
                try {
                    PRUDPPacketRequestConnect connect_request = new PRUDPPacketRequestConnect();
                    PRUDPPacket reply = handler.sendAndReceive(auth, connect_request, destination);
                    if (reply.getAction() == 0) {
                        int ip;
                        String ip_str;
                        int event2;
                        String event_str;
                        int p_pos;
                        String url_str;
                        PRUDPPacketRequest request2;
                        PRUDPPacketRequest announce_request;
                        PRUDPPacketReplyConnect connect_reply = (PRUDPPacketReplyConnect)reply;
                        long my_connection = connect_reply.getConnectionId();
                        if (PRUDPPacketTracker.VERSION == 1) {
                            request2 = announce_request = new PRUDPPacketRequestAnnounce(my_connection);
                            url_str = reqUrl.toString();
                            p_pos = url_str.indexOf("?");
                            url_str = url_str.substring(p_pos + 1);
                            event_str = this.getURLParam(url_str, "event");
                            event2 = 0;
                            if (event_str != null) {
                                if (event_str.equals("started")) {
                                    event2 = 2;
                                } else if (event_str.equals("stopped")) {
                                    event2 = 3;
                                } else if (event_str.equals("completed")) {
                                    event2 = 1;
                                }
                            }
                            ip_str = this.getURLParam(url_str, "ip");
                            ip = 0;
                            if (ip_str != null) {
                                ip = PRHelpers.addressToInt(ip_str);
                            }
                            ((PRUDPPacketRequestAnnounce)announce_request).setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event2, ip, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                        } else {
                            request2 = announce_request = new PRUDPPacketRequestAnnounce2(my_connection);
                            url_str = reqUrl.toString();
                            p_pos = url_str.indexOf("?");
                            url_str = url_str.substring(p_pos + 1);
                            event_str = this.getURLParam(url_str, "event");
                            event2 = 0;
                            if (event_str != null) {
                                if (event_str.equals("started")) {
                                    event2 = 2;
                                } else if (event_str.equals("stopped")) {
                                    event2 = 3;
                                } else if (event_str.equals("completed")) {
                                    event2 = 1;
                                }
                            }
                            ip_str = this.getURLParam(url_str, "ip");
                            ip = 0;
                            if (ip_str != null) {
                                ip = PRHelpers.addressToInt(ip_str);
                            }
                            ((PRUDPPacketRequestAnnounce2)announce_request).setDetails(this.torrent_hash.getBytes(), this.tracker_peer_id, this.getLongURLParam(url_str, "downloaded"), event2, ip, this.key_udp, (int)this.getLongURLParam(url_str, "numwant"), this.getLongURLParam(url_str, "left"), (short)this.getLongURLParam(url_str, "port"), this.getLongURLParam(url_str, "uploaded"));
                        }
                        reply = handler.sendAndReceive(auth, request2, destination);
                        if (reply.getAction() == 1) {
                            short[] ports;
                            HashMap<String, Serializable> map;
                            PRUDPPacketReply announce_reply;
                            if (auth != null) {
                                SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, true);
                            }
                            if (PRUDPPacketTracker.VERSION == 1) {
                                announce_reply = (PRUDPPacketReplyAnnounce)reply;
                                map = new HashMap<String, Serializable>();
                                map.put("interval", new Long(((PRUDPPacketReplyAnnounce)announce_reply).getInterval()));
                                int[] addresses = ((PRUDPPacketReplyAnnounce)announce_reply).getAddresses();
                                ports = ((PRUDPPacketReplyAnnounce)announce_reply).getPorts();
                                ArrayList peers = new ArrayList();
                                map.put("peers", peers);
                                for (int i = 0; i < addresses.length; ++i) {
                                    HashMap<String, Object> peer = new HashMap<String, Object>();
                                    peers.add(peer);
                                    peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                    peer.put("port", new Long(ports[i]));
                                }
                                byte[] data = BEncoder.encode(map);
                                message.write(data);
                                return null;
                            }
                            announce_reply = (PRUDPPacketReplyAnnounce2)reply;
                            map = new HashMap();
                            map.put("interval", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getInterval()));
                            int[] addresses = ((PRUDPPacketReplyAnnounce2)announce_reply).getAddresses();
                            ports = ((PRUDPPacketReplyAnnounce2)announce_reply).getPorts();
                            map.put("complete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getSeeders()));
                            map.put("incomplete", new Long(((PRUDPPacketReplyAnnounce2)announce_reply).getLeechers()));
                            ArrayList peers = new ArrayList();
                            map.put("peers", peers);
                            for (int i = 0; i < addresses.length; ++i) {
                                HashMap<String, Object> peer = new HashMap<String, Object>();
                                peers.add(peer);
                                peer.put("ip", PRHelpers.intToAddress(addresses[i]).getBytes());
                                peer.put("port", new Long(ports[i]));
                            }
                            byte[] data = BEncoder.encode(map);
                            message.write(data);
                            return null;
                        }
                        failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                        continue;
                    }
                    failure_reason = ((PRUDPPacketReplyError)reply).getMessage();
                    continue;
                }
                catch (PRUDPPacketHandlerException e) {
                    if (e.getMessage() != null && e.getMessage().indexOf("timed out") != -1) continue;
                    throw e;
                }
            }
        }
        catch (Throwable e) {
            failure_reason = this.exceptionToString(e);
        }
        if (auth != null) {
            SESecurityManager.setPasswordAuthenticationOutcome(UDP_REALM, reqUrl, false);
        }
        return failure_reason;
    }

    protected long getLongURLParam(String url, String param) {
        String val = this.getURLParam(url, param);
        if (val == null) {
            return 0L;
        }
        return Long.parseLong(val);
    }

    protected String getURLParam(String url, String param) {
        int p1 = url.indexOf(param + "=");
        if (p1 == -1) {
            return null;
        }
        int p2 = url.indexOf("&", p1);
        if (p2 == -1) {
            return url.substring(p1 + param.length() + 1);
        }
        return url.substring(p1 + param.length() + 1, p2);
    }

    protected String exceptionToString(Throwable e) {
        String str;
        String class_name = e.getClass().getName();
        int pos = class_name.lastIndexOf(46);
        if (pos != -1) {
            class_name = class_name.substring(pos + 1);
        }
        if ((str = class_name + ":" + e.getMessage()).indexOf("timed out") != -1) {
            str = "timeout";
        }
        return str;
    }

    public URL constructUrl(String evt, URL _url) throws Exception {
        String ext;
        String url = _url.toString();
        StringBuffer request2 = new StringBuffer(url);
        if (url.indexOf(63) != -1) {
            request2.append('&');
        } else {
            request2.append('?');
        }
        request2.append(this.info_hash);
        request2.append(this.tracker_peer_id_str);
        String port_details = TRTrackerUtils.getPortsForURL();
        request2.append(port_details);
        request2.append("&uploaded=").append(this.announce_data_provider.getTotalSent());
        request2.append("&downloaded=").append(this.announce_data_provider.getTotalReceived());
        request2.append("&left=").append(this.announce_data_provider.getRemaining());
        if (this.tracker_id.length() > 0) {
            request2.append("&trackerid=").append(this.tracker_id);
        }
        if (evt.length() != 0) {
            request2.append("&event=").append(evt);
        }
        if (evt.equals("stopped")) {
            request2.append("&numwant=0");
            if (this.stopped_for_queue) {
                request2.append("&azq=1");
            }
        } else {
            int numwant = this.calculateNumWant();
            request2.append("&numwant=").append(numwant);
        }
        request2.append("&no_peer_id=1");
        request2.append("&compact=1");
        String explicit_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        String ip = null;
        String tracker_network = AENetworkClassifier.categoriseAddress(_url.getHost());
        boolean network_ok = false;
        boolean normal_network_ok = false;
        if (this.peer_networks == null) {
            network_ok = true;
            normal_network_ok = true;
        } else {
            for (int i = 0; i < this.peer_networks.length; ++i) {
                if (this.peer_networks[i] == "Public") {
                    normal_network_ok = true;
                }
                if (this.peer_networks[i] != tracker_network) continue;
                network_ok = true;
            }
        }
        if (!network_ok) {
            throw new Exception("Network not enabled for url '" + _url + "'");
        }
        String normal_explicit = null;
        if (explicit_ips.length() > 0) {
            StringTokenizer tok = new StringTokenizer(explicit_ips, ";");
            while (tok.hasMoreTokens()) {
                String this_address = tok.nextToken().trim();
                if (this_address.length() <= 0) continue;
                String cat = AENetworkClassifier.categoriseAddress(this_address);
                if (cat == "Public") {
                    normal_explicit = this_address;
                }
                if (tracker_network != cat) continue;
                ip = this_address;
                break;
            }
        }
        if (ip == null) {
            if (normal_network_ok && normal_explicit != null) {
                ip = normal_explicit;
            } else if (this.ip_override != null) {
                ip = this.ip_override;
            }
        }
        if (ip != null) {
            block25: {
                if (tracker_network == "Public") {
                    try {
                        ip = PRHelpers.DNSToIPAddress(ip);
                    }
                    catch (UnknownHostException e) {
                        if (!Logger.isEnabled()) break block25;
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "IP Override host resolution of '" + ip + "' fails, using unresolved address"));
                    }
                }
            }
            request2.append("&ip=").append(ip);
        }
        if (COConfigurationManager.getBooleanParameter("Tracker Key Enable Client", true)) {
            request2.append("&key=").append(this.key_id);
        }
        if ((ext = this.announce_data_provider.getExtensions()) != null) {
            request2.append(ext);
        }
        return new URL(request2.toString());
    }

    protected int calculateNumWant() {
        int MAX_PEERS = 500;
        int maxAllowed = this.announce_data_provider.getMaxNewConnectionsAllowed();
        if (maxAllowed < 0 || maxAllowed > MAX_PEERS) {
            maxAllowed = MAX_PEERS;
        }
        return maxAllowed;
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider _provider) {
        try {
            this.this_mon.enter();
            this.announce_data_provider = _provider;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerUrl() {
        return this.lastUsedUrl;
    }

    public void setTrackerUrl(URL new_url) {
        try {
            new_url = new URL(new_url.toString().replaceAll(" ", ""));
            ArrayList<URL> list = new ArrayList<URL>(1);
            list.add(new_url);
            this.trackerUrlLists.clear();
            this.trackerUrlLists.add(list);
            this.informURLChange(new_url, true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void resetTrackerUrl(boolean shuffle) {
        String old_list = this.trackerURLListToString();
        this.constructTrackerUrlLists(shuffle);
        if (this.trackerUrlLists.size() == 0) {
            return;
        }
        if (!old_list.equals(this.trackerURLListToString())) {
            URL first_url = (URL)((List)this.trackerUrlLists.get(0)).get(0);
            this.informURLChange(first_url, true);
        }
    }

    public void refreshListeners() {
        this.informURLRefresh();
    }

    public void setIPOverride(String override) {
        this.ip_override = override;
    }

    public void clearIPOverride() {
        this.ip_override = null;
    }

    private void constructTrackerUrlLists(boolean shuffle) {
        try {
            this.trackerUrlLists = new ArrayList();
            TOTorrentAnnounceURLSet[] announce_sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (announce_sets.length == 0) {
                URL url = this.torrent.getAnnounceURL();
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(url);
                this.trackerUrlLists.add(list);
            } else {
                for (int i = 0; i < announce_sets.length; ++i) {
                    URL[] urls = announce_sets[i].getAnnounceURLs();
                    ArrayList<URL> random_urls = new ArrayList<URL>();
                    for (int j = 0; j < urls.length; ++j) {
                        URL url = urls[j];
                        int pos = shuffle ? (int)(Math.random() * (double)(random_urls.size() + 1)) : j;
                        random_urls.add(pos, url);
                    }
                    this.trackerUrlLists.add(random_urls);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected String trackerURLListToString() {
        String trackerUrlListString = "[";
        for (int i = 0; i < this.trackerUrlLists.size(); ++i) {
            List group = (List)this.trackerUrlLists.get(i);
            trackerUrlListString = trackerUrlListString + (i == 0 ? "" : ",") + "[";
            for (int j = 0; j < group.size(); ++j) {
                URL u = (URL)group.get(j);
                trackerUrlListString = trackerUrlListString + (j == 0 ? "" : ",") + u.toString();
            }
            trackerUrlListString = trackerUrlListString + "]";
        }
        trackerUrlListString = trackerUrlListString + "]";
        return trackerUrlListString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponseImpl decodeTrackerResponse(URL url, byte[] data) {
        String failure_reason;
        if (data == null) {
            failure_reason = "no response";
        } else {
            try {
                try {
                    Object meta_peers;
                    byte[] trackerid;
                    long time_to_wait;
                    Map metaData;
                    block53: {
                        metaData = BDecoder.decode(data);
                        try {
                            String warning_message;
                            byte[] b_warning_message = (byte[])metaData.get("warning message");
                            if (b_warning_message == null || !COConfigurationManager.getBooleanParameter("Tracker Client Show Warnings") || (warning_message = new String(b_warning_message)).equals(this.last_tracker_message)) break block53;
                            this.last_tracker_message = warning_message;
                            boolean log_it = false;
                            try {
                                class_mon.enter();
                                String last_warning_message = (String)tracker_report_map.get(url.getHost());
                                if (last_warning_message == null || !warning_message.equals(last_warning_message)) {
                                    log_it = true;
                                    tracker_report_map.put(url.getHost(), warning_message);
                                }
                            }
                            finally {
                                class_mon.exit();
                            }
                            if (log_it) {
                                Logger.logTextResource(new LogAlert(false, 1, "TrackerClient.announce.warningmessage"), new String[]{this.announce_data_provider.getName(), warning_message});
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        Long raw_min_interval;
                        time_to_wait = (Long)metaData.get("interval");
                        if (time_to_wait < 0L || time_to_wait > 0xFFFFFFFFL) {
                            time_to_wait = 0xFFFFFFFFL;
                        }
                        if ((raw_min_interval = (Long)metaData.get("min interval")) != null) {
                            this.min_interval = raw_min_interval;
                            if (this.min_interval < 1L || this.min_interval > time_to_wait) {
                                this.min_interval = 0L;
                            }
                        }
                        if (time_to_wait > 30L) {
                            time_to_wait -= 10L;
                        }
                    }
                    catch (Exception e) {
                        byte[] failure_reason_bytes = (byte[])metaData.get("failure reason");
                        if (failure_reason_bytes == null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 1, "Problems with Tracker, will retry in " + this.getErrorRetryInterval() + "ms"));
                            }
                            return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), "Unknown cause");
                        }
                        String failure_reason2 = new String(failure_reason_bytes, "UTF8");
                        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 1, (long)this.getErrorRetryInterval(), failure_reason2);
                    }
                    Long incomplete_l = (Long)metaData.get("incomplete");
                    Long complete_l = (Long)metaData.get("complete");
                    if ((incomplete_l != null || complete_l != null) && Logger.isEnabled()) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE1: seeds=" + complete_l + " peers=" + incomplete_l));
                    }
                    if ((trackerid = (byte[])metaData.get("tracker id")) != null) {
                        this.tracker_id = new String(trackerid);
                    }
                    byte[] crypto_flags = (byte[])metaData.get("crypto_flags");
                    ArrayList<TRTrackerAnnouncerResponsePeerImpl> valid_meta_peers = new ArrayList<TRTrackerAnnouncerResponsePeerImpl>();
                    Object meta_peers_peek = metaData.get("peers");
                    if (meta_peers_peek instanceof List) {
                        meta_peers = (List)meta_peers_peek;
                        int peers_length = meta_peers.size();
                        if (crypto_flags != null && peers_length != crypto_flags.length) {
                            crypto_flags = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        for (int i = 0; i < peers_length; ++i) {
                            Map peer = (Map)meta_peers.get(i);
                            Object s_peerid = peer.get("peer id");
                            Object s_ip = peer.get("ip");
                            Object s_port = peer.get("port");
                            if (s_ip == null || s_port == null) continue;
                            String ip = new String((byte[])s_ip, "UTF8");
                            int peer_port = ((Long)s_port).intValue();
                            if (peer_port > 65535) {
                                peer_port -= 65536;
                            }
                            if (peer_port < 0) {
                                peer_port += 65536;
                            }
                            if (peer_port < 0 || peer_port > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid peer port given: " + ip + ": " + peer_port));
                                continue;
                            }
                            byte[] peer_peer_id = s_peerid == null ? this.getAnonymousPeerId(ip, peer_port) : (byte[])s_peerid;
                            short protocol = crypto_flags == null ? (short)1 : (crypto_flags[i] == 0 ? (short)1 : 2);
                            int udp_port = 0;
                            TRTrackerAnnouncerResponsePeerImpl new_peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, peer_port, udp_port, protocol);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "NON-COMPACT PEER: " + new_peer.getString()));
                            }
                            valid_meta_peers.add(new_peer);
                        }
                    } else if (meta_peers_peek instanceof byte[]) {
                        int entry_size;
                        meta_peers = (byte[])meta_peers_peek;
                        boolean az_compact = metaData.get("azcompact") != null;
                        int n = entry_size = az_compact ? 9 : 6;
                        if (crypto_flags != null && ((Object)meta_peers).length / entry_size != crypto_flags.length) {
                            crypto_flags = null;
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid crypto_flags returned: length mismatch"));
                            }
                        }
                        int peer_number = 0;
                        for (int i = 0; i < ((Object)meta_peers).length; i += entry_size) {
                            int protocol;
                            int udp_port;
                            ++peer_number;
                            int ip1 = 0xFF & meta_peers[i];
                            int ip2 = 0xFF & meta_peers[i + 1];
                            int ip3 = 0xFF & meta_peers[i + 2];
                            int ip4 = 0xFF & meta_peers[i + 3];
                            int po1 = 0xFF & meta_peers[i + 4];
                            int po2 = 0xFF & meta_peers[i + 5];
                            String ip = "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
                            int tcp_port = po1 * 256 + po2;
                            if (tcp_port < 0 || tcp_port > 65535) {
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "Invalid compact peer port given: " + ip + ": " + tcp_port));
                                continue;
                            }
                            byte[] peer_peer_id = this.getAnonymousPeerId(ip, tcp_port);
                            if (az_compact) {
                                int upo1 = 0xFF & meta_peers[i + 6];
                                int upo2 = 0xFF & meta_peers[i + 7];
                                udp_port = upo1 * 256 + upo2;
                                Object flags = meta_peers[i + 8];
                                protocol = (flags & 1) == 0 ? 1 : 2;
                            } else {
                                protocol = crypto_flags == null ? 1 : (crypto_flags[peer_number - 1] == 0 ? 1 : 2);
                                udp_port = 0;
                            }
                            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("Tracker", peer_peer_id, ip, tcp_port, udp_port, (short)protocol);
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "COMPACT PEER: " + peer.getString()));
                            }
                            valid_meta_peers.add(peer);
                        }
                    } else {
                        throw new IOException("peers missing from response");
                    }
                    TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[valid_meta_peers.size()];
                    valid_meta_peers.toArray(peers);
                    this.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
                    TRTrackerAnnouncerResponseImpl resp = new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 2, time_to_wait, peers);
                    this.failure_added_time = 0;
                    Map extensions = (Map)metaData.get("extensions");
                    resp.setExtensions(extensions);
                    if (extensions != null) {
                        Object override;
                        if (complete_l == null) {
                            complete_l = (Long)extensions.get("complete");
                        }
                        if (incomplete_l == null) {
                            incomplete_l = (Long)extensions.get("incomplete");
                        }
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "ANNOUNCE SCRAPE2: seeds=" + complete_l + " peers=" + incomplete_l));
                        }
                        if ((override = extensions.get("min interval override")) != null && override instanceof Long) {
                            this.min_interval_override = (Long)override;
                        }
                    }
                    if (complete_l != null || incomplete_l != null) {
                        int incomplete;
                        int complete = complete_l == null ? 0 : complete_l.intValue();
                        int n = incomplete = incomplete_l == null ? 0 : incomplete_l.intValue();
                        if (complete < 0 || incomplete < 0) {
                            resp.setFailurReason(MessageText.getString("Tracker.announce.ignorePeerSeed", new String[]{(complete < 0 ? MessageText.getString("MyTorrentsView.seeds") + " == " + complete + ". " : "") + (incomplete < 0 ? MessageText.getString("MyTorrentsView.peers") + " == " + incomplete + ". " : "")}));
                        } else {
                            TRTrackerScraperResponse scrapeResponse;
                            TRTrackerScraper scraper = TRTrackerScraperFactory.getSingleton();
                            if (scraper != null && (scrapeResponse = scraper.scrape(this)) != null) {
                                long lNextScrapeTime = scrapeResponse.getNextScrapeStartTime();
                                long lNewNextScrapeTime = TRTrackerScraperResponseImpl.calcScrapeIntervalSecs(0, complete) * 1000;
                                scrapeResponse.setScrapeStartTime(SystemTime.getCurrentTime());
                                if (lNextScrapeTime < lNewNextScrapeTime) {
                                    scrapeResponse.setNextScrapeStartTime(lNewNextScrapeTime);
                                }
                                scrapeResponse.setSeedsPeers(complete, incomplete);
                            }
                        }
                    }
                    return resp;
                }
                catch (IOException e) {
                    String trace_data = new String(data);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this.torrent, LOGID, 3, "TRTrackerAnnouncer::invalid reply: " + trace_data));
                    }
                    if (trace_data.length() > 150) {
                        trace_data = trace_data.substring(0, 150) + "...";
                    }
                    failure_reason = "invalid reply: " + trace_data;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                failure_reason = "error: " + e.getMessage();
            }
        }
        return new TRTrackerAnnouncerResponseImpl(url, this.torrent_hash, 0, (long)this.getErrorRetryInterval(), failure_reason);
    }

    protected void informURLChange(URL url, boolean explicit) {
        this.listeners.dispatch(2, new Object[]{url.toString(), new Boolean(explicit)});
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        if (this.last_response == null) {
            return new TRTrackerAnnouncerResponseImpl(null, this.torrent_hash, 0, 60L, "Initialising");
        }
        return this.last_response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        TRTrackerAnnouncerFactoryImpl.destroy(this);
        try {
            this.this_mon.enter();
            if (this.current_timer_event != null && this.current_timer_event.getWhen() - SystemTime.getCurrentTime() > 10000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "Canceling announce trigger"));
                }
                this.current_timer_event.cancel();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getErrorRetryInterval() {
        boolean is_seed;
        long currentTime = SystemTime.getCurrentTime() / 1000L;
        long diff = currentTime - this.failure_time_last_updated;
        if (diff < (long)this.failure_added_time && diff >= 0L) {
            return this.failure_added_time;
        }
        this.failure_time_last_updated = currentTime;
        this.failure_added_time = this.failure_added_time == 0 ? 10 : (this.failure_added_time < 30 ? (this.failure_added_time += 10) : (this.failure_added_time < 60 ? (this.failure_added_time += 15) : (this.failure_added_time < 120 ? (this.failure_added_time += 30) : (this.failure_added_time < 600 ? (this.failure_added_time += 60) : (this.failure_added_time += 120 + new Random().nextInt(60))))));
        boolean bl = this.announce_data_provider == null ? false : (is_seed = this.announce_data_provider.getRemaining() == 0L);
        if (is_seed) {
            this.failure_added_time *= 2;
        }
        if (!is_seed && this.failure_added_time > 1800) {
            this.failure_added_time = 1800;
        } else if (is_seed && this.failure_added_time > 3600) {
            this.failure_added_time = 3600;
        }
        return this.failure_added_time;
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncerResponseImpl response;
        String status;
        if (result.getResponseType() == 2) {
            status = MessageText.getString("PeerManager.status.error");
            String reason = result.getError();
            if (reason != null) {
                status = status + " (" + reason + ")";
            }
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 0, result.getTimeToWait(), reason);
        } else {
            DownloadAnnounceResultPeer[] ext_peers = result.getPeers();
            TRTrackerAnnouncerResponsePeer[] peers = new TRTrackerAnnouncerResponsePeerImpl[ext_peers.length];
            for (int i = 0; i < ext_peers.length; ++i) {
                DownloadAnnounceResultPeer ext_peer = ext_peers[i];
                peers[i] = new TRTrackerAnnouncerResponsePeerImpl(ext_peer.getSource(), ext_peer.getPeerID(), ext_peer.getAddress(), ext_peer.getPort(), ext_peer.getUDPPort(), ext_peer.getProtocol());
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)peers[i]).getString()));
            }
            this.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])peers);
            status = MessageText.getString("PeerManager.status.ok");
            response = new TRTrackerAnnouncerResponseImpl(result.getURL(), this.torrent_hash, 2, result.getTimeToWait(), peers);
        }
        if (this.last_response == null || this.last_response.getStatus() != 2) {
            this.tracker_status_str = status + " (" + result.getURL() + ")";
        }
        this.listeners.dispatch(1, response);
    }

    static /* synthetic */ boolean access$000(TRTrackerBTAnnouncerImpl x0) {
        return x0.manual_control;
    }

    static /* synthetic */ TOTorrent access$100(TRTrackerBTAnnouncerImpl x0) {
        return x0.torrent;
    }

    static /* synthetic */ long access$202(TRTrackerBTAnnouncerImpl x0, long x1) {
        x0.current_time_to_wait_secs = x1;
        return x0.current_time_to_wait_secs;
    }

    static /* synthetic */ TimerEvent access$300(TRTrackerBTAnnouncerImpl x0) {
        return x0.current_timer_event;
    }

    static /* synthetic */ TimerEvent access$302(TRTrackerBTAnnouncerImpl x0, TimerEvent x1) {
        x0.current_timer_event = x1;
        return x0.current_timer_event;
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
        class_mon = new AEMonitor("TRTrackerBTAnnouncer:class");
        tracker_report_map = new HashMap();
    }
}

