/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.X509CRLObject;

public class X509V2CRLGenerator {
    private SimpleDateFormat dateF = new SimpleDateFormat("yyMMddHHmmss");
    private SimpleTimeZone tz = new SimpleTimeZone(0, "Z");
    private V2TBSCertListGenerator tbsGen;
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private Hashtable extensions = null;
    private Vector extOrdering = null;
    private static Hashtable algorithms = new Hashtable();

    public X509V2CRLGenerator() {
        this.dateF.setTimeZone(this.tz);
        this.tbsGen = new V2TBSCertListGenerator();
    }

    public void reset() {
        this.tbsGen = new V2TBSCertListGenerator();
    }

    public void setIssuerDN(X509Name issuer) {
        this.tbsGen.setIssuer(issuer);
    }

    public void setThisUpdate(Date date) {
        this.tbsGen.setThisUpdate(new DERUTCTime(this.dateF.format(date) + "Z"));
    }

    public void setNextUpdate(Date date) {
        this.tbsGen.setNextUpdate(new DERUTCTime(this.dateF.format(date) + "Z"));
    }

    public void addCRLEntry(BigInteger userCertificate, Date revocationDate, int reason) {
        this.tbsGen.addCRLEntry(new DERInteger(userCertificate), new DERUTCTime(this.dateF.format(revocationDate) + "Z"), reason);
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sigOID = (DERObjectIdentifier)algorithms.get(signatureAlgorithm.toUpperCase());
        if (this.sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = new AlgorithmIdentifier(this.sigOID, null);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void addExtension(String OID, boolean critical, DEREncodable value) {
        this.addExtension(new DERObjectIdentifier(OID), critical, value);
    }

    public void addExtension(DERObjectIdentifier OID, boolean critical, DEREncodable value) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("error encoding value: " + e);
        }
        this.addExtension(OID, critical, bOut.toByteArray());
    }

    public void addExtension(String OID, boolean critical, byte[] value) {
        this.addExtension(new DERObjectIdentifier(OID), critical, value);
    }

    public void addExtension(DERObjectIdentifier OID, boolean critical, byte[] value) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        this.extensions.put(OID, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
        this.extOrdering.addElement(OID);
    }

    public X509CRL generateX509CRL(PrivateKey key) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(key, "BC", null);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey key, SecureRandom random) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(key, "BC", random);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509CRL(key, provider, null);
    }

    public X509CRL generateX509CRL(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        Signature sig = null;
        try {
            sig = Signature.getInstance(this.sigOID.getId(), provider);
        }
        catch (NoSuchAlgorithmException ex) {
            try {
                sig = Signature.getInstance(this.signatureAlgorithm, provider);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("exception creating signature: " + e.toString());
            }
        }
        if (random != null) {
            sig.initSign(key, random);
        } else {
            sig.initSign(key);
        }
        if (this.extensions != null) {
            this.tbsGen.setExtensions(new X509Extensions(this.extOrdering, this.extensions));
        }
        TBSCertList tbsCrl = this.tbsGen.generateTBSCertList();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(tbsCrl);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert - " + e);
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(tbsCrl);
        v.add(this.sigAlgId);
        v.add(new DERBitString(sig.sign()));
        return new X509CRLObject(new CertificateList(new DERSequence(v)));
    }

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
    }
}

