/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

public class X509NameTokenizer {
    private String oid;
    private int index;
    private StringBuffer buf = new StringBuffer();

    public X509NameTokenizer(String oid) {
        this.oid = oid;
        this.index = -1;
    }

    public boolean hasMoreTokens() {
        return this.index != this.oid.length();
    }

    public String nextToken() {
        int end;
        if (this.index == this.oid.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        for (end = this.index + 1; end != this.oid.length(); ++end) {
            char c = this.oid.charAt(end);
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    this.buf.append(c);
                }
                escaped = false;
                continue;
            }
            if (escaped || quoted) {
                this.buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',') break;
            this.buf.append(c);
        }
        this.index = end;
        return this.buf.toString().trim();
    }
}

