/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.MikesUnchoker;
import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

public abstract class GlobalTorrentAwareDownloadingUnchoker
implements Unchoker {
    private static Map<PEPeerTransport, Long> globalPeers = Collections.synchronizedMap(new HashMap());
    protected double market_rate = 7.0;
    public static final double UPLOAD_RATE_INCREMENT = 0.2;
    private ArrayList chokes = new ArrayList();
    private ArrayList unchokes = new ArrayList();

    public GlobalTorrentAwareDownloadingUnchoker() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, "using global torrent unchoker"));
        }
        System.out.println("construcuted gtadu");
    }

    protected int getUploadCap() {
        int upload_cap = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
        if (upload_cap == 0) {
            upload_cap = 40;
        }
        return upload_cap;
    }

    private int getUploadCapForTheNextTenSecondsInBytes() {
        return this.getUploadCap() * 10 * 1024;
    }

    public void calculateUnchokes(int max_to_unchoke, ArrayList all_peers, boolean force_refresh) {
        this.updateGlobalMap(all_peers);
        int bandwidthToAllocate = this.getUploadCapForTheNextTenSecondsInBytes();
        if (this instanceof MikesUnchoker) {
            for (PEPeerTransport p : all_peers) {
                if (p.isChokingMe()) {
                    p.getTyrantStats().updateLastChokedTime();
                }
                if (!p.isChokingMe() && p.isInteresting()) {
                    p.getTyrantStats().updateDownloadRate();
                }
                if (!p.isChokedByMe() && p.isChokingMe() && p.isInteresting()) {
                    p.getTyrantStats().updateOfferedRate(p.getTyrantStats().getUploadCost() * 1.2);
                }
                if (p.isChokingMe() || p.isChokedByMe() || p.getTyrantStats().lastChoked() + 30000L >= System.currentTimeMillis()) continue;
                p.getTyrantStats().updateOfferedRate(p.getTyrantStats().getUploadCost() * 0.9);
            }
        }
        ChokesAndUnchokes global = this.calculateChokesAndUnchokes(new ArrayList<PEPeerTransport>(globalPeers.keySet()), bandwidthToAllocate);
        for (PEPeerTransportProtocol p : global.unchokes) {
            if (!all_peers.contains(p)) continue;
            this.unchokes.add(p);
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, global.unchokes.size() + " peers were unchoked globally, " + this.unchokes.size() + " peers unchoked in this torrent"));
        }
        for (PEPeerTransportProtocol p : global.chokes) {
            if (!all_peers.contains(p)) continue;
            this.chokes.add(p);
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, global.chokes.size() + " peers were choked globally, " + this.chokes.size() + " peers choked in this torrent"));
        }
        if (this instanceof MikesUnchoker) {
            for (PEPeerTransportProtocol p : this.unchokes) {
                double rate = p.getTyrantStats().getUploadCost() == 0.0 ? this.market_rate : p.getTyrantStats().getUploadCost();
                rate *= 10240.0;
                rate = Math.max(1.0, rate);
                p.getNetworkConnection().setBandwidth((int)rate);
                if (p.isSeed()) {
                    p.getNetworkConnection().setBandwidth(Integer.MAX_VALUE);
                }
                System.out.println("unchoked peer " + p + " got " + (int)rate + " bytes for the next 10 sec");
            }
        } else {
            for (PEPeerTransportProtocol p : this.unchokes) {
                if (p.getNetworkConnection() == null) continue;
                p.getNetworkConnection().setBandwidth((int)p.getTyrantStats().getLastUploadAllocation());
            }
        }
        for (PEPeerTransportProtocol p : this.chokes) {
            if (p.getNetworkConnection() == null) continue;
            p.getNetworkConnection().setBandwidth(5000);
        }
    }

    public abstract ChokesAndUnchokes calculateChokesAndUnchokes(ArrayList var1, long var2);

    public ArrayList getImmediateUnchokes(int max_to_unchoke, ArrayList all_peers) {
        this.updateGlobalMap(all_peers);
        return new ArrayList();
    }

    private void updateGlobalMap(ArrayList all_peers) {
        for (int i = 0; i < all_peers.size(); ++i) {
            PEPeerTransport peer = (PEPeerTransport)all_peers.get(i);
            globalPeers.put(peer, System.currentTimeMillis());
        }
    }

    public ArrayList getChokes() {
        ArrayList toReturn = this.chokes;
        this.chokes = new ArrayList();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, "global torrent unchoker chokes: " + toReturn));
        }
        return toReturn;
    }

    public ArrayList getUnchokes() {
        ArrayList toReturn = this.unchokes;
        this.unchokes = new ArrayList();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, logging, "global torrent unchoker unchokes: " + toReturn));
        }
        return toReturn;
    }

    static {
        Thread remover = new Thread(){
            long maxInactivityBeforeRemoval = 30000L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    if (globalPeers.size() > 0) {
                        Set k = globalPeers.keySet();
                        Map map = globalPeers;
                        synchronized (map) {
                            long now = System.currentTimeMillis();
                            Iterator pit = k.iterator();
                            while (pit.hasNext()) {
                                PEPeerTransport current = (PEPeerTransport)pit.next();
                                if (now - (Long)globalPeers.get(current) <= this.maxInactivityBeforeRemoval) continue;
                                pit.remove();
                                if (!Logger.isEnabled()) continue;
                                Logger.log(new LogEvent(this, Unchoker.logging, "gpr: removed inactive peer: " + current));
                            }
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        remover.setDaemon(true);
        remover.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ChokesAndUnchokes {
        public ArrayList<PEPeerTransportProtocol> chokes;
        public ArrayList<PEPeerTransportProtocol> unchokes;

        public ChokesAndUnchokes(ArrayList<PEPeerTransportProtocol> chokes, ArrayList<PEPeerTransportProtocol> unchokes) {
            this.chokes = chokes;
            this.unchokes = unchokes;
        }
    }
}

