/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.download.session;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.peermanager.connection.AZPeerConnection;
import com.aelitis.azureus.core.peermanager.connection.PeerConnectionFactory;
import com.aelitis.azureus.core.peermanager.download.TorrentDownload;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionEnd;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionSyn;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TorrentSessionManager {
    private static final TorrentSessionManager instance = new TorrentSessionManager();
    private final HashMap hashes = new HashMap();
    private final AEMonitor hashes_mon = new AEMonitor("TorrentSessionManager");

    public static TorrentSessionManager getSingleton() {
        return instance;
    }

    private TorrentSessionManager() {
    }

    public void init() {
        PeerConnectionFactory.getSingleton().registerCreationListener(new PeerConnectionFactory.CreationListener(){

            public void connectionCreated(final AZPeerConnection connection) {
                connection.getNetworkConnection().getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean messageReceived(Message message) {
                        if (message.getID().equals("AZ_SESSION_SYN")) {
                            AZSessionSyn syn = (AZSessionSyn)message;
                            byte[] hash = syn.getInfoHash();
                            TorrentDownload download = null;
                            try {
                                TorrentSessionManager.this.hashes_mon.enter();
                                download = (TorrentDownload)TorrentSessionManager.this.hashes.get(new HashWrapper(hash));
                            }
                            finally {
                                TorrentSessionManager.this.hashes_mon.exit();
                            }
                            if (download == null) {
                                System.out.println("unknown session infohash " + ByteFormatter.nicePrint(hash, true));
                                AZSessionEnd end = new AZSessionEnd(hash, "unknown session infohash");
                                connection.getNetworkConnection().getOutgoingMessageQueue().addMessage(end, false);
                            }
                            syn.destroy();
                            return true;
                        }
                        return false;
                    }

                    public void protocolBytesReceived(int byte_count) {
                    }

                    public void dataBytesReceived(int byte_count) {
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForSessionManagement(TorrentDownload download) {
        try {
            this.hashes_mon.enter();
            this.hashes.put(new HashWrapper(download.getInfoHash()), download);
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterForSessionManagement(TorrentDownload download) {
        try {
            this.hashes_mon.enter();
            this.hashes.remove(new HashWrapper(download.getInfoHash()));
        }
        finally {
            this.hashes_mon.exit();
        }
    }

    public void requestTorrentSession(TorrentDownload download, AZPeerConnection connection) {
    }
}

