/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.tests;

import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.Coordinates;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.VivaldiPositionImpl;

public class VivaldiTest {
    private static final int MAX_HEIGHT = 50;
    private static final int ELEMENTS_X = 20;
    private static final int ELEMENTS_Y = 20;
    private static final int DISTANCE = 10;
    private static final int MAX_ITERATIONS = 1000;
    private static final int NB_CONTACTS = 7;

    public VivaldiTest() {
        VivaldiPosition[][] positions = new VivaldiPosition[20][20];
        Coordinates[][] realCoordinates = new Coordinates[20][20];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 20; ++j) {
                realCoordinates[i][j] = new HeightCoordinatesImpl(i * 10, j * 10, 50.0f);
                positions[i][j] = new VivaldiPositionImpl(new HeightCoordinatesImpl(0.0f, 0.0f, 0.0f));
            }
        }
        for (int iter = 0; iter < 1000; ++iter) {
            for (int i = 0; i < 20; ++i) {
                for (int j = 0; j < 20; ++j) {
                    VivaldiPosition position = positions[i][j];
                    for (int k = 0; k < 7; ++k) {
                        int i1 = (int)(Math.random() * 20.0);
                        int j1 = (int)(Math.random() * 20.0);
                        if (i1 == i && j1 == j) continue;
                        VivaldiPosition position1 = positions[i1][j1];
                        float rtt = realCoordinates[i1][j1].distance(realCoordinates[i][j]);
                        position.update(rtt, position1.getCoordinates(), position1.getErrorEstimate());
                    }
                    if (iter != 999) continue;
                    System.out.println(iter + " (" + i + "," + j + ") : " + realCoordinates[i][j] + " , " + position);
                }
            }
        }
    }

    public static void main(String[] args) {
        new VivaldiTest();
    }
}

