/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.applet.Applet;
import java.io.File;
import java.util.HashMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterface
implements UISWTConfigSection {
    Label passwordMatch;
    private ParameterListener decisions_parameter_listener;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "style";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        if (this.decisions_parameter_listener != null) {
            COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        }
    }

    public Composite configSectionCreate(final Composite parent) {
        Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cDisplay.setLayout((Layout)layout);
        new BooleanParameter(cDisplay, "Open Details", "ConfigView.label.opendetails");
        new BooleanParameter(cDisplay, "Open Bar", false, "ConfigView.label.openbar");
        if (!Constants.isOSX) {
            BooleanParameter est = new BooleanParameter(cDisplay, "Enable System Tray", true, "ConfigView.section.interface.enabletray");
            BooleanParameter ctt = new BooleanParameter(cDisplay, "Close To Tray", true, "ConfigView.label.closetotray");
            BooleanParameter mtt = new BooleanParameter(cDisplay, "Minimize To Tray", false, "ConfigView.label.minimizetotray");
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(ctt.getControls()));
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(mtt.getControls()));
        }
        new BooleanParameter(cDisplay, "Send Version Info", true, "ConfigView.label.allowSendVersion");
        Composite cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        BooleanParameter d_play_sound = new BooleanParameter(cArea, "Play Download Finished", false, "ConfigView.label.playdownloadfinished");
        if (Constants.isOSX) {
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            Composite d_filler = new Composite(cArea, 0);
            d_filler.setSize(0, 0);
            d_filler.setLayoutData((Object)gridData);
            BooleanParameter d_speechEnabledParameter = new BooleanParameter(cArea, "Play Download Finished Announcement", "ConfigView.label.playdownloadspeech");
            StringParameter d_speechParameter = new StringParameter(cArea, "Play Download Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            d_speechParameter.setLayoutData(gridData);
            ((Text)d_speechParameter.getControl()).setTextLimit(40);
            d_speechEnabledParameter.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(d_speechParameter.getControls()));
            Label d_speechInfo = new Label(cArea, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalIndent = 24;
            d_speechInfo.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)d_speechInfo, "ConfigView.label.playdownloadspeech.info");
        }
        if (!Constants.isOSX) {
            Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
            gridData = new GridData();
            gridData.widthHint = 150;
            final StringParameter d_pathParameter = new StringParameter(cArea, "Play Download Finished File", "");
            if (d_pathParameter.getValue().length() == 0) {
                d_pathParameter.setValue("<default>");
            }
            d_pathParameter.setLayoutData(gridData);
            Button d_browse = new Button(cArea, 8);
            d_browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(d_browse.getBackground());
            d_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            d_browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                    dialog.setFilterExtensions(new String[]{"*.wav"});
                    dialog.setFilterNames(new String[]{"*.wav"});
                    dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                    String path = dialog.open();
                    if (path != null) {
                        d_pathParameter.setValue(path);
                        new AEThread(this, "SoundTest", path){
                            private final /* synthetic */ String val$path;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$path = val$path;
                                super(x0);
                            }

                            public void runSupport() {
                                try {
                                    Applet.newAudioClip(new File(this.val$path).toURL()).play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
            });
            Label d_sound_info = new Label(cArea, 64);
            Messages.setLanguageText((Widget)d_sound_info, "ConfigView.section.interface.wavlocation.info");
            gridData = new GridData(768);
            gridData.widthHint = 100;
            d_sound_info.setLayoutData((Object)gridData);
            d_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(d_pathParameter.getControls()));
            d_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{d_browse, d_sound_info}));
        }
        BooleanParameter f_play_sound = new BooleanParameter(cArea, "Play File Finished", false, "ConfigView.label.playfilefinished");
        if (Constants.isOSX) {
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            Composite f_filler = new Composite(cArea, 0);
            f_filler.setSize(0, 0);
            f_filler.setLayoutData((Object)gridData);
            BooleanParameter f_speechEnabledParameter = new BooleanParameter(cArea, "Play File Finished Announcement", "ConfigView.label.playfilespeech");
            StringParameter f_speechParameter = new StringParameter(cArea, "Play File Finished Announcement Text");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            gridData.widthHint = 150;
            f_speechParameter.setLayoutData(gridData);
            ((Text)f_speechParameter.getControl()).setTextLimit(40);
            f_speechEnabledParameter.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(f_speechParameter.getControls()));
            Label speechInfo = new Label(cArea, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalIndent = 24;
            speechInfo.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)speechInfo, "ConfigView.label.playfilespeech.info");
        }
        if (!Constants.isOSX) {
            Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
            gridData = new GridData();
            gridData.widthHint = 150;
            final StringParameter f_pathParameter = new StringParameter(cArea, "Play File Finished File", "");
            if (f_pathParameter.getValue().length() == 0) {
                f_pathParameter.setValue("<default>");
            }
            f_pathParameter.setLayoutData(gridData);
            Button f_browse = new Button(cArea, 8);
            f_browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(f_browse.getBackground());
            f_browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            f_browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                    dialog.setFilterExtensions(new String[]{"*.wav"});
                    dialog.setFilterNames(new String[]{"*.wav"});
                    dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                    String path = dialog.open();
                    if (path != null) {
                        f_pathParameter.setValue(path);
                        new AEThread(this, "SoundTest", path){
                            private final /* synthetic */ String val$path;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$path = val$path;
                                super(x0);
                            }

                            public void runSupport() {
                                try {
                                    Applet.newAudioClip(new File(this.val$path).toURL()).play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
            });
            Label f_sound_info = new Label(cArea, 64);
            Messages.setLanguageText((Widget)f_sound_info, "ConfigView.section.interface.wavlocation.info");
            gridData = new GridData(768);
            gridData.widthHint = 100;
            f_sound_info.setLayoutData((Object)gridData);
            f_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(f_pathParameter.getControls()));
            f_play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{f_browse, f_sound_info}));
        }
        if (!Constants.isOSX) {
            BooleanParameter confirm = new BooleanParameter(cArea, "confirmationOnExit", false, "ConfigView.section.style.confirmationOnExit");
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            confirm.setLayoutData(gridData);
        }
        BooleanParameter confirm_removal = new BooleanParameter(cArea, "confirm_torrent_removal", "ConfigView.section.interface.confirm_torrent_removal");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        confirm_removal.setLayoutData(gridData);
        final Label clear_label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)clear_label, "ConfigView.section.interface.cleardecisions");
        final Button clear_decisions = new Button(cArea, 8);
        Messages.setLanguageText((Widget)clear_decisions, "ConfigView.section.interface.cleardecisionsbutton");
        clear_decisions.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                COConfigurationManager.setParameter("MessageBoxWindow.decisions", new HashMap());
            }
        });
        this.decisions_parameter_listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                if (clear_decisions.isDisposed()) {
                    COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this);
                } else {
                    boolean enabled = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap()).size() > 0;
                    clear_label.setEnabled(enabled);
                    clear_decisions.setEnabled(enabled);
                }
            }
        };
        this.decisions_parameter_listener.parameterChanged(null);
        COConfigurationManager.addParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        Label label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.password");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw1 = new PasswordParameter(cArea, "Password");
        pw1.setLayoutData(gridData);
        Text t1 = (Text)pw1.getControl();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordconfirm");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw2 = new PasswordParameter(cArea, "Password Confirm");
        pw2.setLayoutData(gridData);
        Text t2 = (Text)pw2.getControl();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cArea, 0);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.passwordMatch.setLayoutData((Object)gridData);
        this.refreshPWLabel();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        t1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.dropdiraction");
        String[] drop_options = new String[]{"ConfigView.section.style.dropdiraction.opentorrents", "ConfigView.section.style.dropdiraction.sharefolder", "ConfigView.section.style.dropdiraction.sharefoldercontents", "ConfigView.section.style.dropdiraction.sharefoldercontentsrecursive"};
        String[] dropLabels = new String[drop_options.length];
        String[] dropValues = new String[drop_options.length];
        for (int i = 0; i < drop_options.length; ++i) {
            dropLabels[i] = MessageText.getString(drop_options[i]);
            dropValues[i] = "" + i;
        }
        new StringListParameter(cArea, "config.style.dropdiraction", "", dropLabels, dropValues);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations)) {
            Composite cResetAssoc = new Composite(cArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            cResetAssoc.setLayout((Layout)layout);
            cResetAssoc.setLayoutData((Object)new GridData());
            label = new Label(cResetAssoc, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.interface.resetassoc");
            Button reset = new Button(cResetAssoc, 8);
            Messages.setLanguageText((Widget)reset, "ConfigView.section.interface.resetassocbutton");
            reset.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        platform.registerApplication();
                    }
                    catch (PlatformManagerException e) {
                        Logger.log(new LogAlert(false, "Failed to register application", e));
                    }
                }
            });
            new BooleanParameter(cArea, "config.interface.checkassoc", true, "ConfigView.section.interface.checkassoc");
            label = new Label(cArea, 0);
            label = new Label(cArea, 0);
        }
        return cDisplay;
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == confirm[i]) continue;
                    same = false;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

