/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import java.awt.Frame;
import java.awt.Panel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class UISWTViewImpl
extends AbstractIView
implements UISWTView {
    public static final String CFG_PREFIX = "Views.plugins.";
    private Object dataSource = null;
    private final UISWTViewEventListener eventListener;
    private Composite composite;
    private final String sViewID;
    private int iControlType = 0;
    private boolean bFirstGetCompositeCall = true;
    private final String sParentID;
    private String sTitle = null;

    public UISWTViewImpl(String sParentID, String sViewID, UISWTViewEventListener eventListener) throws Exception {
        this.sParentID = sParentID;
        this.sViewID = sViewID;
        this.eventListener = eventListener;
        if (!eventListener.eventOccurred(new UISWTViewEventImpl(this, 0, this))) {
            throw new Exception();
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public String getViewID() {
        return this.sViewID;
    }

    public void closeView() {
        try {
            Display display = MainWindow.getWindow().getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                MainWindow.getWindow().closePluginView(this);
            } else {
                display.syncExec(new Runnable(){

                    public void run() {
                        MainWindow.getWindow().closePluginView(UISWTViewImpl.this);
                    }
                });
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0) {
            this.iControlType = iControlType;
        }
    }

    public void triggerEvent(int eventType, Object data) {
        this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
    }

    public void setTitle(String title) {
        this.sTitle = title;
    }

    public void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 1, newDataSource));
    }

    public void delete() {
        this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 7, null));
        super.delete();
    }

    public Composite getComposite() {
        if (this.bFirstGetCompositeCall) {
            this.bFirstGetCompositeCall = false;
        }
        return this.composite;
    }

    public String getData() {
        String key = CFG_PREFIX + this.sViewID + ".title";
        if (MessageText.keyExists(key)) {
            return key;
        }
        return this.sViewID;
    }

    public String getFullTitle() {
        if (this.sTitle != null) {
            return this.sTitle;
        }
        return super.getFullTitle();
    }

    public void initialize(Composite parent) {
        if (this.iControlType == 0) {
            this.composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 2, this.composite));
        } else {
            this.composite = new Composite(parent, 0x1000000);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            Frame f = SWT_AWT.new_Frame((Composite)this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 2, pan));
        }
        if (this.composite != null) {
            this.composite.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    UISWTViewImpl.this.eventListener.eventOccurred(new UISWTViewEventImpl(UISWTViewImpl.this, 3, null));
                }
            });
            this.composite.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    UISWTViewImpl.this.eventListener.eventOccurred(new UISWTViewEventImpl(UISWTViewImpl.this, 4, null));
                }
            });
        }
    }

    public void refresh() {
        this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 5, null));
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.eventListener.eventOccurred(new UISWTViewEventImpl(this, 6, null));
    }

    public String getParentID() {
        return this.sParentID;
    }
}

