/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class TextViewerWindow {
    public TextViewerWindow(String sTitleID, String sMessageID, String sText) {
        Display display = SWTThread.getInstance().getDisplay();
        final Shell shell = ShellFactory.createShell(display, 67680);
        if (sTitleID != null) {
            shell.setText(MessageText.keyExists(sTitleID) ? MessageText.getString(sTitleID) : sTitleID);
        }
        if (!Constants.isOSX) {
            shell.setImage(ImageRepository.getImage("azureus"));
        }
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Label label = new Label((Composite)shell, 0);
        if (sMessageID != null) {
            label.setText(MessageText.keyExists(sMessageID) ? MessageText.getString(sMessageID) : sMessageID);
        }
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        label.setLayoutData((Object)gridData);
        Text txtInfo = new Text((Composite)shell, 2818);
        gridData = new GridData();
        gridData.widthHint = 300;
        txtInfo.setLayoutData((Object)gridData);
        txtInfo.setText(sText);
        Button ok = new Button((Composite)shell, 8);
        ok.setText(MessageText.getString("Button.ok"));
        gridData = new GridData();
        gridData.widthHint = 70;
        ok.setLayoutData((Object)gridData);
        shell.setDefaultButton(ok);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    shell.dispose();
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

