/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

public class MethodSignature {
    public String method_name;
    public String[] arg_classes;

    public static MethodSignature parse(String meth_sig) {
        int method_arg_start = meth_sig.indexOf("[");
        if (method_arg_start == -1) {
            return new MethodSignature(meth_sig, new String[0]);
        }
        String method_name = meth_sig.substring(0, method_arg_start);
        if (meth_sig.charAt(meth_sig.length() - 1) != ']') {
            return new MethodSignature(meth_sig, new String[0]);
        }
        String meth_sig_args = meth_sig.substring(method_arg_start + 1, meth_sig.length() - 1);
        String[] class_types = meth_sig_args.split(",");
        return new MethodSignature(method_name, class_types);
    }

    public MethodSignature(String method_name, String[] arg_classes) {
        this.method_name = method_name;
        this.arg_classes = arg_classes;
    }

    public String toString() {
        return MethodSignature.asString(null, this.method_name, this.arg_classes);
    }

    public static String asString(String return_type, String method_name, String[] arg_types) {
        String result = return_type == null ? "" : return_type + " ";
        result = result + method_name + "(";
        for (int i = 0; i < arg_types.length; ++i) {
            if (i != 0) {
                result = result + ", ";
            }
            result = result + arg_types[i];
        }
        result = result + ")";
        return result;
    }
}

