/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentFile;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAnnounceURLListImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentFileImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class TorrentImpl
extends LogRelation
implements Torrent {
    private static MagnetPlugin magnet_plugin;
    private PluginInterface pi;
    private TOTorrent torrent;
    private LocaleUtilDecoder decoder;

    public TorrentImpl(TOTorrent _torrent) {
        this(null, _torrent);
    }

    public TorrentImpl(PluginInterface _pi, TOTorrent _torrent) {
        this.pi = _pi;
        this.torrent = _torrent;
        try {
            this.decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getName() {
        String name = this.decode(this.torrent.getName());
        name = FileUtil.convertOSSpecificChars(name);
        return name;
    }

    public URL getAnnounceURL() {
        return this.torrent.getAnnounceURL();
    }

    public void setAnnounceURL(URL url) {
        this.torrent.setAnnounceURL(url);
        this.updated();
    }

    public TorrentAnnounceURLList getAnnounceURLList() {
        return new TorrentAnnounceURLListImpl(this);
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public boolean isDecentralised() {
        return TorrentUtils.isDecentralised(this.torrent);
    }

    public boolean isDecentralisedBackupEnabled() {
        return TorrentUtils.getDHTBackupEnabled(this.torrent);
    }

    public void setDecentralisedBackupRequested(boolean requested) {
        TorrentUtils.setDHTBackupRequested(this.torrent, requested);
    }

    public boolean isDecentralisedBackupRequested() {
        return TorrentUtils.isDHTBackupRequested(this.torrent);
    }

    public boolean isPrivate() {
        return TorrentUtils.getPrivate(this.torrent);
    }

    public void setPrivate(boolean priv) {
        TorrentUtils.setPrivate(this.torrent, priv);
    }

    public URL getMagnetURI() throws TorrentException {
        PluginInterface magnet_pi;
        if (magnet_plugin == null && (magnet_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class)) != null) {
            magnet_plugin = (MagnetPlugin)magnet_pi.getPlugin();
        }
        if (magnet_plugin == null) {
            throw new TorrentException("MegnetPlugin unavailable");
        }
        try {
            URL res = magnet_plugin.getMagnetURL(this.torrent.getHash());
            return res;
        }
        catch (TOTorrentException e) {
            throw new TorrentException(e);
        }
    }

    public byte[] getHash() {
        try {
            return this.torrent.getHash();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public long getSize() {
        return this.torrent.getSize();
    }

    public String getComment() {
        return this.decode(this.torrent.getComment());
    }

    public void setComment(String comment) {
        this.torrent.setComment(comment);
    }

    public long getCreationDate() {
        return this.torrent.getCreationDate();
    }

    public String getCreatedBy() {
        return this.decode(this.torrent.getCreatedBy());
    }

    public long getPieceSize() {
        return this.torrent.getPieceLength();
    }

    public long getPieceCount() {
        return this.torrent.getNumberOfPieces();
    }

    public byte[][] getPieces() {
        try {
            return this.torrent.getPieces();
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return new byte[0][0];
        }
    }

    public TorrentFile[] getFiles() {
        TOTorrentFile[] files = this.torrent.getFiles();
        TorrentFile[] res = new TorrentFile[files.length];
        for (int i = 0; i < res.length; ++i) {
            TOTorrentFile tf = files[i];
            byte[][] comps = tf.getPathComponents();
            String name = "";
            for (int j = 0; j < comps.length; ++j) {
                String comp = this.decode(comps[j]);
                comp = FileUtil.convertOSSpecificChars(comp);
                name = name + (j == 0 ? "" : File.separator) + comp;
            }
            res[i] = new TorrentFileImpl(name, tf.getLength());
        }
        return res;
    }

    public String getEncoding() {
        if (this.decoder != null) {
            return this.decoder.getName();
        }
        return "UTF8";
    }

    protected String decode(byte[] data) {
        if (data != null) {
            if (this.decoder != null) {
                try {
                    return this.decoder.decodeString(data);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new String(data);
        }
        return "";
    }

    public Object getAdditionalProperty(String name) {
        return this.torrent.getAdditionalProperty(name);
    }

    public Torrent removeAdditionalProperties() {
        try {
            TOTorrent t = TOTorrentFactory.deserialiseFromMap(this.torrent.serialiseToMap());
            t.removeAdditionalProperties();
            return new TorrentImpl(t);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            return this;
        }
    }

    public void setPluginStringProperty(String name, String value) {
        PluginInterface p = this.pi;
        if (p == null) {
            p = UtilitiesImpl.getPluginThreadContext();
        }
        name = p == null ? "<internal>." + name : p.getPluginID() + "." + name;
        TorrentUtils.setPluginStringProperty(this.torrent, name, value);
    }

    public String getPluginStringProperty(String name) {
        PluginInterface p = this.pi;
        if (p == null) {
            p = UtilitiesImpl.getPluginThreadContext();
        }
        name = p == null ? "<internal>." + name : p.getPluginID() + "." + name;
        return TorrentUtils.getPluginStringProperty(this.torrent, name);
    }

    public void setMapProperty(String name, Map value) {
        TorrentUtils.setPluginMapProperty(this.torrent, name, value);
    }

    public Map getMapProperty(String name) {
        return TorrentUtils.getPluginMapProperty(this.torrent, name);
    }

    public Map writeToMap() throws TorrentException {
        try {
            return this.torrent.serialiseToMap();
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToMap: fails", e);
        }
    }

    public byte[] writeToBEncodedData() throws TorrentException {
        try {
            Map map = this.torrent.serialiseToMap();
            return BEncoder.encode(map);
        }
        catch (Throwable e) {
            throw new TorrentException("Torrent::writeToBEncodedData: fails", e);
        }
    }

    public void writeToFile(File file) throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent, file);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::writeToFile: fails", e);
        }
    }

    protected void updated() {
        try {
            DownloadImpl dm = (DownloadImpl)DownloadManagerImpl.getDownloadStatic(this.torrent);
            if (dm != null) {
                dm.torrentChanged();
            }
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
    }

    public void save() throws TorrentException {
        try {
            TorrentUtils.writeToFile(this.torrent);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Torrent::save Fails", e);
        }
    }

    public void setComplete(File data_dir) throws TorrentException {
        try {
            LocaleUtil.getSingleton().setDefaultTorrentEncoding(this.torrent);
            DownloadManagerState download_manager_state = DownloadManagerStateFactory.getDownloadState(this.torrent);
            TorrentUtils.setResumeDataCompletelyValid(download_manager_state);
            download_manager_state.save();
        }
        catch (Throwable e) {
            throw new TorrentException("encoding selection fails", e);
        }
    }

    public String getRelationText() {
        return this.propogatedRelationText(this.torrent);
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.torrent};
    }
}

