/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

public class TimeFormatter {
    static final String[] TIME_SUFFIXES = new String[]{"s", "m", "h", "d"};

    public static String format(long time) {
        int end;
        if (time >= 31536000L) {
            return "\u221e";
        }
        if (time < 0L) {
            return "";
        }
        int[] vals = new int[]{(int)time % 60, (int)(time / 60L) % 60, (int)(time / 3600L) % 24, (int)(time / 86400L)};
        for (end = vals.length - 1; vals[end] == 0 && end > 0; --end) {
        }
        String result = vals[end] + TIME_SUFFIXES[end];
        while (--end >= 0 && vals[end] == 0) {
        }
        if (end >= 0) {
            result = result + " " + TimeFormatter.twoDigits(vals[end]) + TIME_SUFFIXES[end];
        }
        return result;
    }

    public static String formatColon(long time) {
        if (time >= 31536000L) {
            return "\u221e";
        }
        if (time < 0L) {
            return "";
        }
        int secs = (int)time % 60;
        int mins = (int)(time / 60L) % 60;
        int hours = (int)(time / 3600L) % 24;
        int days = (int)(time / 86400L);
        String result = "";
        if (days > 0) {
            result = days + "d ";
        }
        result = result + TimeFormatter.twoDigits(hours) + ":" + TimeFormatter.twoDigits(mins) + ":" + TimeFormatter.twoDigits(secs);
        return result;
    }

    private static String twoDigits(int i) {
        return i < 10 ? "0" + i : String.valueOf(i);
    }
}

