/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.Debug;

public class BEncoder {
    public static byte[] encode(Map object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new BEncoder().encode(baos, object);
        return baos.toByteArray();
    }

    private void encode(ByteArrayOutputStream baos, Object object) throws IOException {
        if (object instanceof String || object instanceof Float) {
            String tempString = object instanceof String ? (String)object : String.valueOf((Float)object);
            ByteBuffer bb = BDecoder.DEFAULT_CHARSET.encode(tempString);
            this.write(baos, BDecoder.DEFAULT_CHARSET.encode(String.valueOf(bb.limit())));
            baos.write(58);
            this.write(baos, bb);
        } else if (object instanceof Map) {
            Map tempMap = (Map)object;
            TreeMap tempTree = null;
            boolean byte_keys = object instanceof ByteEncodedKeyHashMap;
            baos.write(100);
            tempTree = tempMap instanceof TreeMap ? (TreeMap)tempMap : new TreeMap(tempMap);
            Iterator it = tempTree.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry2 = it.next();
                Object o_key = entry2.getKey();
                Object value = entry2.getValue();
                if (value == null) continue;
                if (o_key instanceof byte[]) {
                    this.encode(baos, (byte[])o_key);
                    this.encode(baos, value);
                    continue;
                }
                String key = (String)o_key;
                if (byte_keys) {
                    try {
                        this.encode(baos, BDecoder.BYTE_CHARSET.encode(key));
                        this.encode(baos, tempMap.get(key));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException("BEncoder: unsupport encoding: " + e.getMessage());
                    }
                }
                this.encode(baos, key);
                this.encode(baos, value);
            }
            baos.write(101);
        } else if (object instanceof List) {
            List tempList = (List)object;
            baos.write(108);
            for (int i = 0; i < tempList.size(); ++i) {
                this.encode(baos, tempList.get(i));
            }
            baos.write(101);
        } else if (object instanceof Long) {
            Long tempLong = (Long)object;
            baos.write(105);
            this.write(baos, BDecoder.DEFAULT_CHARSET.encode(tempLong.toString()));
            baos.write(101);
        } else if (object instanceof Integer) {
            Integer tempInteger = (Integer)object;
            baos.write(105);
            this.write(baos, BDecoder.DEFAULT_CHARSET.encode(tempInteger.toString()));
            baos.write(101);
        } else if (object instanceof byte[]) {
            byte[] tempByteArray = (byte[])object;
            this.write(baos, BDecoder.DEFAULT_CHARSET.encode(String.valueOf(tempByteArray.length)));
            baos.write(58);
            baos.write(tempByteArray);
        } else if (object instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)object;
            this.write(baos, BDecoder.DEFAULT_CHARSET.encode(String.valueOf(bb.limit())));
            baos.write(58);
            this.write(baos, bb);
        }
    }

    protected void write(OutputStream os, ByteBuffer bb) throws IOException {
        os.write(bb.array(), 0, bb.limit());
    }

    public static boolean listsAreIdentical(List l1, List l2) {
        HashMap<String, List> m1 = new HashMap<String, List>();
        if (l1 != null) {
            m1.put("map", l1);
        }
        HashMap<String, List> m2 = new HashMap<String, List>();
        if (l2 != null) {
            m2.put("map", l2);
        }
        return BEncoder.mapsAreIdentical(m1, m2);
    }

    public static boolean mapsAreIdentical(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        try {
            return Arrays.equals(BEncoder.encode(map1), BEncoder.encode(map2));
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
            return false;
        }
    }
}

