/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.util.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.Debug;

public class TRTrackerUtilsImpl {
    private static String[] BLACKLISTED_HOSTS = new String[]{"krypt.dyndns.org"};
    private static int[] BLACKLISTED_PORTS = new int[]{81};
    private static String tracker_ip;
    private static Map override_map;
    private static String bind_ip;

    static void readConfig() {
        tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        String override_ips = COConfigurationManager.getStringParameter("Override Ip", "");
        StringTokenizer tok = new StringTokenizer(override_ips, ";");
        HashMap<String, String> new_override_map = new HashMap<String, String>();
        while (tok.hasMoreTokens()) {
            String ip = tok.nextToken().trim();
            if (ip.length() <= 0) continue;
            new_override_map.put(AENetworkClassifier.categoriseAddress(ip), ip);
        }
        override_map = new_override_map;
        bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
    }

    public static boolean isHosting(URL url_in) {
        return tracker_ip.length() > 0 && url_in.getHost().equalsIgnoreCase(tracker_ip);
    }

    public static String getTrackerIP() {
        return tracker_ip;
    }

    public static URL[][] getAnnounceURLs() {
        ArrayList<URL> l;
        String tracker_host = COConfigurationManager.getStringParameter("Tracker IP", "");
        ArrayList urls = new ArrayList();
        if (tracker_host.length() > 0) {
            int i;
            List ports;
            ArrayList<URL> l2;
            int port;
            if (COConfigurationManager.getBooleanParameter("Tracker Port Enable", false)) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                try {
                    l2 = new ArrayList<URL>();
                    l2.add(new URL("http://" + tracker_host + ":" + port + "/announce"));
                    ports = TRTrackerUtilsImpl.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port Backups"));
                    for (i = 0; i < ports.size(); ++i) {
                        l2.add(new URL("http://" + tracker_host + ":" + (Integer)ports.get(i) + "/announce"));
                    }
                    urls.add(l2);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable", false)) {
                port = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
                try {
                    l2 = new ArrayList();
                    l2.add(new URL("https://" + tracker_host + ":" + port + "/announce"));
                    ports = TRTrackerUtilsImpl.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port SSL Backups"));
                    for (i = 0; i < ports.size(); ++i) {
                        l2.add(new URL("https://" + tracker_host + ":" + (Integer)ports.get(i) + "/announce"));
                    }
                    urls.add(l2);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port UDP Enable")) {
                port = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                boolean auth = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
                try {
                    l = new ArrayList<URL>();
                    l.add(new URL("udp://" + tracker_host + ":" + port + "/announce" + (auth ? "?auth" : "")));
                    urls.add(l);
                }
                catch (MalformedURLException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        URL[][] res = new URL[urls.size()][];
        for (int i = 0; i < urls.size(); ++i) {
            l = (ArrayList<URL>)urls.get(i);
            URL[] u = new URL[l.size()];
            l.toArray(u);
            res[i] = u;
        }
        return res;
    }

    protected static List stringToPorts(String str) {
        str = str.replace(',', ';');
        StringTokenizer tok = new StringTokenizer(str, ";");
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (tok.hasMoreTokens()) {
            try {
                res.add(new Integer(tok.nextToken().trim()));
            }
            catch (Throwable e) {
                Debug.out("Invalid port entry in '" + str + "'", e);
            }
        }
        return res;
    }

    public static URL adjustURLForHosting(URL url_in) {
        if (TRTrackerUtilsImpl.isHosting(url_in)) {
            String url = url_in.getProtocol() + "://";
            url = bind_ip.length() < 7 ? url + "127.0.0.1" : url + bind_ip;
            int port = url_in.getPort();
            if (port != -1) {
                url = url + ":" + url_in.getPort();
            }
            url = url + url_in.getPath();
            String query = url_in.getQuery();
            if (query != null) {
                url = url + "?" + query;
            }
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                Debug.printStackTrace(e);
            }
        }
        return url_in;
    }

    public static String adjustHostFromHosting(String host_in) {
        if (tracker_ip.length() > 0) {
            String address_type = AENetworkClassifier.categoriseAddress(host_in);
            String target_ip = (String)override_map.get(address_type);
            if (target_ip == null) {
                target_ip = tracker_ip;
            }
            if (host_in.equals("127.0.0.1")) {
                return target_ip;
            }
            if (host_in.equals(bind_ip)) {
                return target_ip;
            }
        }
        return host_in;
    }

    public static void checkForBlacklistedURLs(URL url) throws IOException {
        for (int i = 0; i < BLACKLISTED_HOSTS.length; ++i) {
            if (!url.getHost().equalsIgnoreCase(BLACKLISTED_HOSTS[i]) || url.getPort() != BLACKLISTED_PORTS[i]) continue;
            throw new IOException("http://" + BLACKLISTED_HOSTS[i] + ":" + BLACKLISTED_PORTS[i] + "/ is not a tracker");
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        return TRTrackerBTAnnouncerImpl.mergeResponseCache(map1, map2);
    }

    static {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerUtilsImpl.readConfig();
            }
        });
        TRTrackerUtilsImpl.readConfig();
    }
}

