/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRNonBlockingServer
extends TRTrackerServerTCP
implements VirtualServerChannelSelector.SelectListener {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int TIMEOUT_CHECK_INTERVAL = 10000;
    private static final int CLOSE_DELAY = 10000;
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector(1, false);
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector(4, true);
    private List connections_to_close = new ArrayList();
    private List processors = new ArrayList();
    private long last_stats_time;
    private long last_timeouts;
    private long last_connections;
    private long total_timeouts;
    private long total_connections;
    public static final int MAX_CONCURRENT_CONNECTIONS = COConfigurationManager.getIntParameter("Tracker TCP NonBlocking Conc Max");
    private final AEMonitor this_mon = new AEMonitor("TRNonBlockingServer");

    public TRNonBlockingServer(String _name, int _port, boolean _apply_ip_filter) throws TRTrackerServerException {
        super(_name, _port, false, _apply_ip_filter);
        boolean ok = false;
        try {
            String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
            InetSocketAddress address = bind_ip.length() < 7 ? new InetSocketAddress(_port) : new InetSocketAddress(InetAddress.getByName(bind_ip), _port);
            VirtualServerChannelSelector accept_server = new VirtualServerChannelSelector(address, 0, this);
            accept_server.start();
            AEThread read_thread = new AEThread("TRTrackerServer:readSelector"){

                public void runSupport() {
                    TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.read_selector);
                }
            };
            read_thread.setDaemon(true);
            read_thread.start();
            AEThread write_thread = new AEThread("TRTrackerServer:writeSelector"){

                public void runSupport() {
                    TRNonBlockingServer.this.selectLoop(TRNonBlockingServer.this.write_selector);
                }
            };
            write_thread.setDaemon(true);
            write_thread.start();
            AEThread close_thread = new AEThread("TRTrackerServer:closeScheduler"){

                public void runSupport() {
                    TRNonBlockingServer.this.closeLoop();
                }
            };
            close_thread.setDaemon(true);
            close_thread.start();
            Logger.log(new LogEvent(LOGID, "TRTrackerServer: Non-blocking listener established on port " + this.getPort()));
            ok = true;
        }
        catch (Throwable e) {
            Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
            Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener failed on port " + this.getPort(), e));
            throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
        }
        finally {
            if (!ok) {
                this.destroy();
            }
        }
    }

    protected void selectLoop(VirtualChannelSelector selector) {
        long last_time = 0L;
        while (true) {
            try {
                while (true) {
                    selector.select(100L);
                    if (selector != this.read_selector) continue;
                    long now = SystemTime.getCurrentTime();
                    if (now < last_time) {
                        last_time = now;
                        continue;
                    }
                    if (now - last_time < 10000L) continue;
                    last_time = now;
                    this.checkTimeouts(now);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnectionAccepted(SocketChannel channel) {
        int num_processors;
        final TRNonBlockingServerProcessor processor = new TRNonBlockingServerProcessor(this, channel);
        try {
            this.this_mon.enter();
            ++this.total_connections;
            this.processors.add(processor);
            num_processors = this.processors.size();
        }
        finally {
            this.this_mon.exit();
        }
        if (MAX_CONCURRENT_CONNECTIONS != 0 && num_processors > MAX_CONCURRENT_CONNECTIONS) {
            this.removeAndCloseConnection(processor);
        } else if (this.isIPFilterEnabled() && this.ip_filter.isInRange(channel.socket().getInetAddress().getHostAddress(), "Tracker")) {
            this.removeAndCloseConnection(processor);
        } else {
            VirtualChannelSelector.VirtualSelectorListener read_listener = new VirtualChannelSelector.VirtualSelectorListener(){

                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    try {
                        int read_result = processor.processRead();
                        if (read_result == 0) {
                            TRNonBlockingServer.this.read_selector.pauseSelects(sc);
                        } else if (read_result < 0) {
                            TRNonBlockingServer.this.removeAndCloseConnection(processor);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        TRNonBlockingServer.this.removeAndCloseConnection(processor);
                    }
                    return true;
                }

                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    TRNonBlockingServer.this.removeAndCloseConnection(processor);
                }
            };
            this.read_selector.register(channel, read_listener, null);
        }
    }

    protected void readyToWrite(final TRNonBlockingServerProcessor processor) {
        VirtualChannelSelector.VirtualSelectorListener write_listener = new VirtualChannelSelector.VirtualSelectorListener(){

            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                try {
                    int write_result = processor.processWrite();
                    if (write_result > 0) {
                        TRNonBlockingServer.this.write_selector.resumeSelects(sc);
                    } else if (write_result == 0) {
                        TRNonBlockingServer.this.removeAndCloseConnection(processor);
                    } else if (write_result < 0) {
                        TRNonBlockingServer.this.removeAndCloseConnection(processor);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    TRNonBlockingServer.this.removeAndCloseConnection(processor);
                }
                return true;
            }

            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                TRNonBlockingServer.this.removeAndCloseConnection(processor);
            }
        };
        this.write_selector.register(processor.getSocketChannel(), write_listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAndCloseConnection(TRNonBlockingServerProcessor processor) {
        try {
            this.this_mon.enter();
            if (this.processors.remove(processor)) {
                this.read_selector.cancel(processor.getSocketChannel());
                this.write_selector.cancel(processor.getSocketChannel());
                this.connections_to_close.add(processor);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeouts(long now) {
        String con_rate = "";
        String tim_rate = "";
        if (this.last_stats_time > 0L) {
            long time_diff = (now - this.last_stats_time) / 1000L;
            long conn_diff = this.total_connections - this.last_connections;
            long tim_diff = this.total_timeouts - this.last_timeouts;
            con_rate = "" + conn_diff / time_diff;
            tim_rate = "" + tim_diff / time_diff;
        }
        this.last_stats_time = now;
        this.last_connections = this.total_connections;
        this.last_timeouts = this.total_timeouts;
        try {
            this.this_mon.enter();
            ArrayList<TRNonBlockingServerProcessor> new_processors = new ArrayList<TRNonBlockingServerProcessor>(this.processors.size());
            for (int i = 0; i < this.processors.size(); ++i) {
                TRNonBlockingServerProcessor processor = (TRNonBlockingServerProcessor)this.processors.get(i);
                if (now - processor.getStartTime() > PROCESSING_GET_LIMIT) {
                    this.read_selector.cancel(processor.getSocketChannel());
                    this.write_selector.cancel(processor.getSocketChannel());
                    this.connections_to_close.add(processor);
                    ++this.total_timeouts;
                    continue;
                }
                new_processors.add(processor);
            }
            this.processors = new_processors;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLoop() {
        long default_delay;
        List pending_list = new ArrayList();
        long delay = default_delay = 6666L;
        while (true) {
            if (delay > 0L) {
                try {
                    Thread.sleep(delay);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            long start = SystemTime.getCurrentTime();
            for (int i = 0; i < pending_list.size(); ++i) {
                try {
                    ((TRNonBlockingServerProcessor)pending_list.get(i)).getSocketChannel().close();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                this.this_mon.enter();
                pending_list = this.connections_to_close;
                this.connections_to_close = new ArrayList();
            }
            finally {
                this.this_mon.exit();
            }
            long duration = SystemTime.getCurrentTime() - start;
            if (duration < 0L) {
                duration = 0L;
            }
            delay = default_delay - duration;
        }
    }
}

