/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServerProcessor;
import org.gudy.azureus2.core3.util.AEThread;

public class TRBlockingServer
extends TRTrackerServerTCP {
    private static final LogIDs LOGID = LogIDs.TRACKER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRBlockingServer(String _name, int _port, boolean _ssl, boolean _apply_ip_filter) throws TRTrackerServerException {
        block11: {
            super(_name, _port, _ssl, _apply_ip_filter);
            boolean ok = false;
            try {
                String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "");
                if (_ssl) {
                    try {
                        SSLServerSocketFactory factory = SESecurityManager.getSSLServerSocketFactory();
                        if (factory == null) {
                            throw new TRTrackerServerException("TRTrackerServer: failed to get SSL factory");
                        }
                        SSLServerSocket ssl_server_socket = bind_ip.length() < 7 ? (SSLServerSocket)factory.createServerSocket(this.getPort(), 128) : (SSLServerSocket)factory.createServerSocket(this.getPort(), 128, InetAddress.getByName(bind_ip));
                        String[] cipherSuites = ssl_server_socket.getSupportedCipherSuites();
                        ssl_server_socket.setEnabledCipherSuites(cipherSuites);
                        ssl_server_socket.setNeedClientAuth(false);
                        ssl_server_socket.setReuseAddress(true);
                        final SSLServerSocket f_ss = ssl_server_socket;
                        AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop(ssl)"){

                            public void runSupport() {
                                TRBlockingServer.this.acceptLoop(f_ss);
                            }
                        };
                        accept_thread.setDaemon(true);
                        accept_thread.start();
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener established on port " + this.getPort()));
                        ok = true;
                        break block11;
                    }
                    catch (Throwable e) {
                        Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                        Logger.log(new LogEvent(LOGID, "TRTrackerServer: SSL listener failed on port " + this.getPort(), e));
                        if (e instanceof TRTrackerServerException) {
                            throw (TRTrackerServerException)e;
                        }
                        throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
                    }
                }
                try {
                    ServerSocket ss = bind_ip.length() < 7 ? new ServerSocket(this.getPort(), 1024) : new ServerSocket(this.getPort(), 1024, InetAddress.getByName(bind_ip));
                    ss.setReuseAddress(true);
                    final ServerSocket f_ss = ss;
                    AEThread accept_thread = new AEThread("TRTrackerServer:accept.loop"){

                        public void runSupport() {
                            TRBlockingServer.this.acceptLoop(f_ss);
                        }
                    };
                    accept_thread.setDaemon(true);
                    accept_thread.start();
                    Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener established on port " + this.getPort()));
                    ok = true;
                }
                catch (Throwable e) {
                    Logger.logTextResource(new LogAlert(false, 3, "Tracker.alert.listenfail"), new String[]{"" + this.getPort()});
                    Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener failed on port " + this.getPort(), e));
                    throw new TRTrackerServerException("TRTrackerServer: accept fails: " + e.toString());
                }
            }
            finally {
                if (!ok) {
                    this.destroy();
                }
            }
        }
    }

    protected void acceptLoop(ServerSocket ss) {
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (true) {
            try {
                while (true) {
                    Socket socket = ss.accept();
                    ++successfull_accepts;
                    String ip = socket.getInetAddress().getHostAddress();
                    if (!this.isIPFilterEnabled() || !this.ip_filter.isInRange(ip, "Tracker")) {
                        this.runProcessor(new TRBlockingServerProcessor(this, socket));
                        continue;
                    }
                    socket.close();
                }
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: listener failed on port " + this.getPort(), e));
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.getPort(), "TCP"});
                return;
            }
            break;
        }
    }
}

