/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class StatsWriterImpl
extends XUXmlWriter {
    protected GlobalManager global;

    protected StatsWriterImpl(GlobalManager _global) {
        this.global = _global;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String file_name) throws IOException {
        try {
            this.setOutputStream(new FileOutputStream(file_name));
            this.writeSupport();
        }
        finally {
            this.closeOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream os) throws IOException {
        try {
            this.setOutputStream(os);
            this.writeSupport();
        }
        finally {
            this.flushOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSupport() {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        boolean export_peer_stats = COConfigurationManager.getBooleanParameter("Stats Export Peer Details");
        String xsl = COConfigurationManager.getStringParameter("Stats XSL File");
        if (xsl.length() > 0) {
            this.writeLineRaw("<?xml-stylesheet type=\"text/xsl\" href=\"" + xsl + "\"?>");
        }
        this.writeLineRaw("<STATS>");
        try {
            this.indent();
            this.writeTag("AZUREUS_VERSION", "2.3.0.7_B51");
            this.writeLineRaw("<GLOBAL>");
            try {
                this.indent();
                GlobalManagerStats gm_stats = this.global.getStats();
                this.writeRawCookedAverageTag("DOWNLOAD_SPEED", gm_stats.getDataReceiveRate() + gm_stats.getProtocolReceiveRate());
                this.writeRawCookedAverageTag("UPLOAD_SPEED", gm_stats.getDataSendRate() + gm_stats.getProtocolSendRate());
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</GLOBAL>");
            this.writeLineRaw("<DOWNLOADS>");
            try {
                this.indent();
                List _dms = this.global.getDownloadManagers();
                DownloadManager[] dms = new DownloadManager[_dms.size()];
                _dms.toArray(dms);
                Arrays.sort(dms, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        DownloadManager d1 = (DownloadManager)o1;
                        DownloadManager d2 = (DownloadManager)o2;
                        int d1_index = d1.getPosition();
                        int d2_index = d2.getPosition();
                        if (d1.getStats().getDownloadCompleted(false) == 1000) {
                            d1_index += 1000000;
                        }
                        if (d2.getStats().getDownloadCompleted(false) == 1000) {
                            d2_index += 1000000;
                        }
                        return d1_index - d2_index;
                    }
                });
                for (int i = 0; i < dms.length; ++i) {
                    block33: {
                        DownloadManager dm = dms[i];
                        DownloadManagerStats dm_stats = dm.getStats();
                        this.writeLineRaw("<DOWNLOAD>");
                        try {
                            this.indent();
                            this.writeLineRaw("<TORRENT>");
                            TOTorrent torrent = dm.getTorrent();
                            try {
                                this.indent();
                                this.writeTag("NAME", dm.getDisplayName());
                                this.writeTag("TORRENT_FILE", dm.getTorrentFileName());
                                if (torrent != null) {
                                    this.writeTag("HASH", ByteFormatter.nicePrintTorrentHash(torrent, true));
                                    this.writeRawCookedTag("SIZE", torrent.getSize());
                                    this.writeTag("PIECE_LENGTH", torrent.getPieceLength());
                                    this.writeTag("PIECE_COUNT", torrent.getNumberOfPieces());
                                    this.writeTag("FILE_COUNT", torrent.getFiles().length);
                                    this.writeTag("COMMENT", dm.getTorrentComment());
                                    this.writeTag("CREATED_BY", dm.getTorrentCreatedBy());
                                    this.writeTag("CREATION_DATE", torrent.getCreationDate());
                                }
                            }
                            finally {
                                this.exdent();
                            }
                            this.writeLineRaw("</TORRENT>");
                            this.writeTag("DOWNLOAD_STATUS", DisplayFormatters.formatDownloadStatusDefaultLocale(dm));
                            this.writeTag("DOWNLOAD_DIR", dm.getSaveLocation().toString());
                            if (torrent != null) {
                                if (torrent.isSimpleTorrent()) {
                                    this.writeTag("TARGET_FILE", dm.getSaveLocation().toString());
                                } else {
                                    this.writeTag("TARGET_DIR", dm.getSaveLocation().toString());
                                }
                            }
                            this.writeTag("TRACKER_STATUS", dm.getTrackerStatus());
                            this.writeTag("COMPLETED", dm_stats.getCompleted());
                            this.writeRawCookedTag("DOWNLOADED", dm_stats.getTotalDataBytesReceived());
                            this.writeRawCookedTag("UPLOADED", dm_stats.getTotalDataBytesSent());
                            this.writeRawCookedTag("DISCARDED", dm_stats.getDiscarded());
                            this.writeRawCookedAverageTag("DOWNLOAD_SPEED", dm_stats.getDataReceiveRate());
                            this.writeRawCookedAverageTag("UPLOAD_SPEED", dm_stats.getDataSendRate());
                            this.writeRawCookedAverageTag("TOTAL_SPEED", dm_stats.getTotalAverage());
                            this.writeTag("ELAPSED", dm_stats.getElapsedTime());
                            this.writeTag("ETA", DisplayFormatters.formatETA(dm_stats.getETA()));
                            this.writeTag("HASH_FAILS", dm_stats.getHashFailCount());
                            this.writeTag("SHARE_RATIO", dm_stats.getShareRatio());
                            this.writeTag("TOTAL_SEEDS", dm.getNbSeeds());
                            this.writeTag("TOTAL_LEECHERS", dm.getNbPeers());
                            if (!export_peer_stats) break block33;
                            try {
                                this.writeLineRaw("<PEERS>");
                                this.indent();
                                PEPeerManager pm = dm.getPeerManager();
                                if (pm != null) {
                                    List peers = pm.getPeers();
                                    for (int j = 0; j < peers.size(); ++j) {
                                        PEPeer peer = (PEPeer)peers.get(j);
                                        PEPeerStats peer_stats = peer.getStats();
                                        byte[] id = peer.getId();
                                        if (id == null) continue;
                                        try {
                                            String peer_id = PeerClassifier.getPrintablePeerID(id);
                                            peer_id = this.escapeXML(peer_id);
                                            String type = this.escapeXML(peer.getClient());
                                            this.writeLineRaw("<PEER hex_id=\"" + ByteFormatter.encodeString(id) + "\" printable_id=\"" + peer_id + "\" type=\"" + type + "\">");
                                            this.indent();
                                            this.writeTag("IP", peer.getIp());
                                            this.writeTag("IS_SEED", peer.isSeed());
                                            this.writeRawCookedTag("DOWNLOADED", peer_stats.getTotalDataBytesReceived());
                                            this.writeRawCookedTag("UPLOADED", peer_stats.getTotalDataBytesSent());
                                            this.writeRawCookedAverageTag("DOWNLOAD_SPEED", peer_stats.getDataReceiveRate());
                                            this.writeRawCookedAverageTag("UPLOAD_SPEED", peer_stats.getDataSendRate());
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                            continue;
                                        }
                                        finally {
                                            this.exdent();
                                            this.writeLineRaw("</PEER>");
                                        }
                                    }
                                }
                            }
                            finally {
                                this.exdent();
                                this.writeLineRaw("</PEERS>");
                            }
                        }
                        finally {
                            this.exdent();
                        }
                    }
                    this.writeLineRaw("</DOWNLOAD>");
                }
            }
            finally {
                this.exdent();
            }
            this.writeLineRaw("</DOWNLOADS>");
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</STATS>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtc(raw));
            this.writeTag("RAW", raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRawCookedAverageTag(String tag, long raw) {
        this.writeLineRaw("<" + tag + ">");
        try {
            this.indent();
            this.writeTag("TEXT", DisplayFormatters.formatByteCountToKiBEtcPerSec(raw));
            this.writeTag("RAW", raw);
        }
        finally {
            this.exdent();
        }
        this.writeLineRaw("</" + tag + ">");
    }
}

