/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerController;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStateImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerSource;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class DownloadManagerImpl
extends LogRelation
implements DownloadManager {
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_DOWNLOADCOMPLETE = 2;
    private static final int LDT_COMPLETIONCHANGED = 3;
    private static final int LDT_POSITIONCHANGED = 4;
    private AEMonitor listeners_mon = new AEMonitor("DM:DownloadManager:L");
    private static ListenerManager listeners_aggregator = ListenerManager.createAsyncManager("DM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object _value) {
            DownloadManagerListener listener = (DownloadManagerListener)_listener;
            Object[] value = (Object[])_value;
            DownloadManagerImpl dm = (DownloadManagerImpl)value[0];
            if (type == 1) {
                listener.stateChanged(dm, (Integer)value[1]);
            } else if (type == 2) {
                listener.downloadComplete(dm);
            } else if (type == 3) {
                listener.completionChanged(dm, (Boolean)value[1]);
            } else if (type == 4) {
                listener.positionChanged(dm, (Integer)value[1], (Integer)value[2]);
            }
        }
    });
    private ListenerManager listeners = ListenerManager.createManager("DM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private static final int LDT_TL_ANNOUNCERESULT = 1;
    private static final int LDT_TL_SCRAPERESULT = 2;
    private ListenerManager tracker_listeners = ListenerManager.createManager("DM:TrackerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerTrackerListener listener = (DownloadManagerTrackerListener)_listener;
            if (type == 1) {
                listener.announceResult((TRTrackerAnnouncerResponse)value);
            } else if (type == 2) {
                listener.scrapeResult((TRTrackerScraperResponse)value);
            }
        }
    });
    private static final int LDT_PE_PEER_ADDED = 1;
    private static final int LDT_PE_PEER_REMOVED = 2;
    private static final int LDT_PE_PIECE_ADDED = 3;
    private static final int LDT_PE_PIECE_REMOVED = 4;
    private static final int LDT_PE_PM_ADDED = 5;
    private static final int LDT_PE_PM_REMOVED = 6;
    private static ListenerManager peer_listeners_aggregator = ListenerManager.createAsyncManager("DM:PeerListenAggregatorDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DownloadManagerPeerListener listener = (DownloadManagerPeerListener)_listener;
            if (type == 1) {
                listener.peerAdded((PEPeer)value);
            } else if (type == 2) {
                listener.peerRemoved((PEPeer)value);
            } else if (type == 3) {
                listener.pieceAdded((PEPiece)value);
            } else if (type == 4) {
                listener.pieceRemoved((PEPiece)value);
            } else if (type == 5) {
                listener.peerManagerAdded((PEPeerManager)value);
            } else if (type == 6) {
                listener.peerManagerRemoved((PEPeerManager)value);
            }
        }
    });
    private ListenerManager peer_listeners = ListenerManager.createManager("DM:PeerListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            peer_listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor peer_listeners_mon = new AEMonitor("DM:DownloadManager:PL");
    private List current_peers = new ArrayList();
    private List current_pieces = new ArrayList();
    private DownloadManagerController controller;
    private DownloadManagerStatsImpl stats;
    protected AEMonitor this_mon = new AEMonitor("DM:DownloadManager");
    private boolean persistent;
    private boolean onlySeeding;
    private int last_informed_state = -1;
    private boolean latest_informed_force_start;
    private GlobalManager globalManager;
    private String torrentFileName;
    private String display_name = "";
    private String internal_name = "";
    private File torrent_save_location;
    private int position = -1;
    private Object[] read_torrent_state;
    private DownloadManagerState download_manager_state;
    private TOTorrent torrent;
    private String torrent_comment;
    private String torrent_created_by;
    private TRTrackerAnnouncer tracker_client;
    private TRTrackerAnnouncerListener tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
            PEPeerManager pm = DownloadManagerImpl.this.controller.getPeerManager();
            if (pm != null) {
                pm.processTrackerResponse(response);
            }
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
        }

        public void urlChanged(String url, boolean explicit) {
            if (explicit) {
                DownloadManagerImpl.this.checkTracker(true);
            }
        }

        public void urlRefresh() {
            DownloadManagerImpl.this.checkTracker(true);
        }
    };
    private TRTrackerAnnouncerListener stopping_tracker_client_listener = new TRTrackerAnnouncerListener(){

        public void receivedTrackerResponse(TRTrackerAnnouncerResponse response) {
            DownloadManagerImpl.this.tracker_listeners.dispatch(1, response);
        }

        public void urlChanged(String url, boolean explicit) {
        }

        public void urlRefresh() {
        }
    };
    private long scrape_random_seed = SystemTime.getCurrentTime();
    private HashMap data;
    private boolean data_already_allocated = false;
    private long creation_time = SystemTime.getCurrentTime();
    private int iSeedingRank;
    private boolean az_messaging_enabled = true;
    private boolean dl_identity_obtained;
    private byte[] dl_identity;
    private int dl_identity_hashcode;
    private int max_connections;
    private int max_uploads_when_seeding;
    private boolean max_uploads_when_seeding_enabled;
    private File cached_save_location;
    private File cached_save_location_result;

    public DownloadManagerImpl(GlobalManager _gm, byte[] _torrent_hash, String _torrentFileName, String _torrent_save_dir, String _torrent_save_file, int _initialState, boolean _persistent, boolean _recovered, boolean _open_for_seeding, boolean _has_ever_been_started) {
        if (_initialState != 0 && _initialState != 70 && _initialState != 75) {
            Debug.out("DownloadManagerImpl: Illegal start state, " + _initialState);
        }
        this.persistent = _persistent;
        this.globalManager = _gm;
        this.stats = new DownloadManagerStatsImpl(this);
        this.controller = new DownloadManagerController(this);
        this.stats.setMaxUploads(COConfigurationManager.getIntParameter("Max Uploads"));
        this.torrentFileName = _torrentFileName;
        while (_torrent_save_dir.endsWith(File.separator)) {
            _torrent_save_dir = _torrent_save_dir.substring(0, _torrent_save_dir.length() - 1);
        }
        this.readTorrent(_torrent_save_dir, _torrent_save_file, _torrent_hash, this.persistent && !_recovered, _open_for_seeding, _has_ever_been_started, _initialState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTorrent(String torrent_save_dir, String torrent_save_file, byte[] torrent_hash, boolean new_torrent, boolean open_for_seeding, boolean has_ever_been_started, int initial_state) {
        block44: {
            try {
                this.display_name = this.torrentFileName;
                this.internal_name = "";
                this.torrent_comment = "";
                this.torrent_created_by = "";
                try {
                    this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this, this.torrentFileName, torrent_hash);
                    this.readParameters();
                    this.download_manager_state.addListener(new DownloadManagerStateListener(){

                        public void stateChanged(DownloadManagerState state, DownloadManagerStateEvent event) {
                            if (event.getType() == 1) {
                                String attribute_name = (String)event.getData();
                                if (attribute_name.equals("filelinks")) {
                                    DownloadManagerImpl.this.setFileLinks();
                                } else if (attribute_name.equals("parameters")) {
                                    DownloadManagerImpl.this.readParameters();
                                }
                            }
                        }
                    });
                    this.torrent = this.download_manager_state.getTorrent();
                    this.setFileLinks();
                    if (!this.dl_identity_obtained) {
                        this.dl_identity = torrent_hash == null ? this.torrent.getHash() : torrent_hash;
                        this.dl_identity_hashcode = new String(this.dl_identity).hashCode();
                    }
                    if (!Arrays.equals(this.dl_identity, this.torrent.getHash())) {
                        this.torrent = null;
                        throw new Exception("Download identity changed - please remove and re-add the download");
                    }
                    this.read_torrent_state = null;
                    LocaleUtilDecoder locale_decoder = LocaleUtil.getSingleton().getTorrentEncoding(this.torrent);
                    this.display_name = locale_decoder.decodeString(this.torrent.getName());
                    this.display_name = FileUtil.convertOSSpecificChars(this.display_name);
                    this.internal_name = ByteFormatter.nicePrint(this.torrent.getHash(), true);
                    File save_dir_file = new File(torrent_save_dir);
                    if (torrent_save_file == null) {
                        try {
                            if (save_dir_file.exists()) {
                                save_dir_file = save_dir_file.getCanonicalFile();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        if (this.torrent.isSimpleTorrent()) {
                            if (save_dir_file.exists()) {
                                if (save_dir_file.isDirectory()) {
                                    torrent_save_file = this.display_name;
                                } else {
                                    torrent_save_dir = save_dir_file.getParent().toString();
                                    torrent_save_file = save_dir_file.getName();
                                }
                            } else {
                                if (save_dir_file.getParent() == null) {
                                    throw new Exception("Data location '" + torrent_save_dir + "' is invalid");
                                }
                                torrent_save_dir = save_dir_file.getParent().toString();
                                torrent_save_file = save_dir_file.getName();
                            }
                        } else {
                            if (save_dir_file.exists()) {
                                if (!save_dir_file.isDirectory()) {
                                    throw new Exception("'" + torrent_save_dir + "' is not a directory");
                                }
                                if (save_dir_file.getName().equals(this.display_name)) {
                                    torrent_save_dir = save_dir_file.getParent().toString();
                                }
                            }
                            torrent_save_file = this.display_name;
                        }
                    }
                    this.torrent_save_location = new File(torrent_save_dir, torrent_save_file);
                    File linked_target = this.getSaveLocation();
                    if (!linked_target.exists() && !new_torrent && !Constants.isWindows && has_ever_been_started) {
                        throw new Exception(MessageText.getString("DownloadManager.error.datamissing") + " " + linked_target.toString());
                    }
                    if (new_torrent) {
                        this.download_manager_state.setTrackerResponseCache(new HashMap());
                        if (open_for_seeding) {
                            DiskManagerFactory.setTorrentResumeDataNearlyComplete(this.download_manager_state);
                        } else {
                            this.download_manager_state.clearResumeData();
                        }
                    }
                    this.torrent_comment = locale_decoder.decodeString(this.torrent.getComment());
                    if (this.torrent_comment == null) {
                        this.torrent_comment = "";
                    }
                    this.torrent_created_by = locale_decoder.decodeString(this.torrent.getCreatedBy());
                    if (this.torrent_created_by == null) {
                        this.torrent_created_by = "";
                    }
                    if (DiskManagerFactory.isTorrentResumeDataComplete(this)) {
                        this.download_manager_state.clearTrackerResponseCache();
                        this.stats.setDownloadCompleted(1000);
                        this.setOnlySeeding(true);
                    } else {
                        this.setOnlySeeding(false);
                    }
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                    this.setFailed(TorrentUtils.exceptionToText(e));
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                    this.setFailed(MessageText.getString("DownloadManager.error.unsupportedencoding"));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.setFailed(e);
                }
                finally {
                    this.dl_identity_obtained = true;
                }
                if (this.download_manager_state == null) {
                    this.read_torrent_state = new Object[]{torrent_save_dir, torrent_save_file, torrent_hash, new Boolean(new_torrent), new Boolean(open_for_seeding), new Boolean(has_ever_been_started), new Integer(initial_state)};
                    this.download_manager_state = DownloadManagerStateImpl.getDownloadState(this);
                    this.torrent_save_location = torrent_save_file == null ? new File(torrent_save_dir) : new File(torrent_save_dir, torrent_save_file);
                } else {
                    if (this.download_manager_state.getNetworks().length == 0) {
                        String[] networks = AENetworkClassifier.getNetworks(this.torrent, this.display_name);
                        this.download_manager_state.setNetworks(networks);
                    }
                    if (this.download_manager_state.getPeerSources().length == 0) {
                        String[] ps = PEPeerSource.getPeerSources();
                        this.download_manager_state.setPeerSources(ps);
                    }
                }
                Object var13_16 = null;
                if (this.torrent_save_location == null) break block44;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (this.torrent_save_location != null) {
                    try {
                        this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
                    }
                    catch (Throwable e) {
                        this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
                    }
                }
                this.controller.setInitialState(initial_state);
                throw throwable;
            }
            try {
                this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
                break block44;
            }
            catch (Throwable e) {
                this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
            }
            {
            }
        }
        this.controller.setInitialState(initial_state);
    }

    protected void readTorrent() {
        if (this.read_torrent_state == null) {
            return;
        }
        this.readTorrent((String)this.read_torrent_state[0], (String)this.read_torrent_state[1], (byte[])this.read_torrent_state[2], (Boolean)this.read_torrent_state[3], (Boolean)this.read_torrent_state[4], (Boolean)this.read_torrent_state[5], (Integer)this.read_torrent_state[6]);
    }

    protected void readParameters() {
        this.max_connections = this.getDownloadState().getIntParameter("max.peers");
        this.max_uploads_when_seeding_enabled = this.getDownloadState().getBooleanParameter("max.uploads.when.seeding.enabled");
        this.max_uploads_when_seeding = this.getDownloadState().getIntParameter("max.uploads.when.seeding");
    }

    protected int getMaxConnections() {
        return this.max_connections;
    }

    protected boolean isMaxUploadsWhenSeedingEnabled() {
        return this.max_uploads_when_seeding_enabled;
    }

    protected int getMaxUploadsWhenSeeding() {
        return this.max_uploads_when_seeding;
    }

    protected void setFileLinks() {
        this.cached_save_location = null;
        DiskManagerFactory.setFileLinks(this, this.download_manager_state.getFileLinks());
        this.controller.fileInfoChanged();
    }

    protected void clearFileLinks() {
        this.download_manager_state.clearFileLinks();
    }

    protected void updateFileLinks(String _old_dir, String _new_dir, File _old_save_dir) {
        try {
            String old_dir = new File(_old_dir).getCanonicalPath();
            String new_dir = new File(_new_dir).getCanonicalPath();
            String old_save_dir = _old_save_dir.getCanonicalPath();
            Map links = this.download_manager_state.getFileLinks();
            Iterator it = links.keySet().iterator();
            while (it.hasNext()) {
                String from_str;
                File from = (File)it.next();
                File to = (File)links.get(from);
                if (to == null || !(from_str = from.getCanonicalPath()).startsWith(old_save_dir)) continue;
                String from_suffix = from_str.substring(old_dir.length());
                String new_from_str = from_suffix.startsWith(File.separator) ? new_dir + from_suffix : new_dir + File.separator + from_suffix;
                String to_str = to.getCanonicalPath();
                if (to_str.startsWith(old_save_dir)) {
                    String to_suffix = to_str.substring(old_dir.length());
                    String new_to_str = to_suffix.startsWith(File.separator) ? new_dir + to_suffix : new_dir + File.separator + to_suffix;
                    to = new File(new_to_str);
                }
                this.download_manager_state.setFileLink(from, null);
                this.download_manager_state.setFileLink(new File(new_from_str), to);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void destroy() {
        this.clearFileLinks();
    }

    public boolean filesExist() {
        return this.controller.filesExist();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public String getInternalName() {
        return this.internal_name;
    }

    public String getErrorDetails() {
        return this.controller.getErrorDetail();
    }

    public long getSize() {
        if (this.torrent != null) {
            return this.torrent.getSize();
        }
        return 0L;
    }

    protected void setFailed() {
        this.setFailed((String)null);
    }

    protected void setFailed(Throwable e) {
        this.setFailed(Debug.getNestedExceptionMessage(e));
    }

    protected void setFailed(String str) {
        this.controller.setFailed(str);
    }

    public void saveResumeData() {
        if (this.getState() == 50) {
            try {
                this.getDiskManager().dumpResumeDataToDisk(false, false);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        if (!this.onlySeeding) {
            this.download_manager_state.save();
        }
    }

    public void saveDownload() {
        DiskManager disk_manager = this.controller.getDiskManager();
        if (disk_manager != null) {
            disk_manager.saveState();
        }
        this.download_manager_state.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.torrent == null) {
            this.readTorrent();
        }
        if (this.torrent == null) {
            this.setFailed();
            return;
        }
        if (this.onlySeeding && !this.filesExist()) {
            return;
        }
        try {
            try {
                this.this_mon.enter();
                if (this.tracker_client != null) {
                    Debug.out("DownloadManager: initialize called with tracker client still available");
                    this.tracker_client.destroy();
                }
                this.tracker_client = TRTrackerAnnouncerFactory.create(this.torrent, this.download_manager_state.getNetworks());
                this.tracker_client.setTrackerResponseCache(this.download_manager_state.getTrackerResponseCache());
                this.tracker_client.addListener(this.tracker_client_listener);
            }
            finally {
                this.this_mon.exit();
            }
            this.controller.initializeDiskManager(10);
        }
        catch (TRTrackerAnnouncerException e) {
            this.setFailed(e);
        }
    }

    public void setStateWaiting() {
        this.controller.setStateWaiting();
    }

    public void setStateFinishing() {
        this.controller.setStateFinishing();
    }

    public void setStateQueued() {
        this.controller.setStateQueued();
    }

    public int getState() {
        return this.controller.getState();
    }

    public int getSubState() {
        return this.controller.getSubState();
    }

    public boolean canForceRecheck() {
        if (this.getTorrent() == null) {
            return false;
        }
        return this.controller.canForceRecheck();
    }

    public void forceRecheck() {
        this.controller.forceRecheck();
    }

    public void resetFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.clearResumeData(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    public void recheckFile(DiskManagerFileInfo file) {
        int state = this.getState();
        if (state == 70 || state == 100) {
            DiskManagerFactory.recheckFile(this, file);
        } else {
            Debug.out("Download not stopped");
        }
    }

    public void restartDownload(boolean use_resume) {
        this.controller.restartDownload(use_resume);
    }

    public void startDownload() {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc == null) {
            Debug.out("DownloadManager:startDownload called with no tracker client");
        } else {
            this.controller.startDownload(tc);
        }
    }

    public void startDownloadInitialized(boolean initialise_stopped_downloads) {
        int state = this.getState();
        if (state == 0 || initialise_stopped_downloads && state == 70) {
            this.initialize();
        }
        if ((state = this.getState()) == 40) {
            this.startDownload();
        }
    }

    public void stopIt(int state_after_stopping, boolean remove_torrent, boolean remove_data) {
        this.controller.stopIt(state_after_stopping, remove_torrent, remove_data);
    }

    public boolean pause() {
        return this.globalManager.pauseDownload(this);
    }

    public boolean isPaused() {
        return this.globalManager.isPaused(this);
    }

    public void resume() {
        this.globalManager.resumeDownload(this);
    }

    public boolean getOnlySeeding() {
        return this.onlySeeding;
    }

    public void setOnlySeeding(boolean _onlySeeding) {
        if (this.onlySeeding != _onlySeeding) {
            this.onlySeeding = _onlySeeding;
            if (_onlySeeding && this.filesExist()) {
                this.stats.setDownloadCompleted(1000);
            }
            if (this.position != -1) {
                DownloadManager[] dms = new DownloadManager[]{this};
                this.position = this.globalManager.getDownloadManagers().size() + 1;
                if (COConfigurationManager.getBooleanParameter("Newly Seeding Torrents Get First Priority")) {
                    this.globalManager.moveTop(dms);
                } else {
                    this.globalManager.moveEnd(dms);
                }
                this.globalManager.fixUpDownloadManagerPositions();
            }
            this.listeners.dispatch(3, new Object[]{this, new Boolean(_onlySeeding)});
        }
    }

    public int getNbSeeds() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbSeeds();
        }
        return 0;
    }

    public int getNbPeers() {
        PEPeerManager peerManager = this.controller.getPeerManager();
        if (peerManager != null) {
            return peerManager.getNbPeers();
        }
        return 0;
    }

    public String getTrackerStatus() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getStatusString();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            return response.getStatusString();
        }
        return "";
    }

    public void setTrackerScrapeResponse(TRTrackerScraperResponse response) {
        this.tracker_listeners.dispatch(2, response);
    }

    public TRTrackerAnnouncer getTrackerClient() {
        return this.tracker_client;
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        TRTrackerAnnouncer cl = this.getTrackerClient();
        if (cl == null) {
            Debug.out("setAnnounceResult called when download not running");
            return;
        }
        cl.setAnnounceResult(result);
    }

    public void setScrapeResult(DownloadScrapeResult result) {
        if (this.torrent != null && result != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            TRTrackerScraperResponse current_resp = this.getTrackerScrapeResponse();
            URL target_url = current_resp != null ? current_resp.getURL() : this.torrent.getAnnounceURL();
            scraper.setScrape(this.torrent, target_url, result);
        }
    }

    public int getNbPieces() {
        if (this.torrent == null) {
            return 0;
        }
        return this.torrent.getNumberOfPieces();
    }

    public int getTrackerTime() {
        TRTrackerScraperResponse response;
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            return tc.getTimeUntilNextUpdate();
        }
        if (this.torrent != null && (response = this.getTrackerScrapeResponse()) != null) {
            if (response.getStatus() == 3) {
                return -1;
            }
            return (int)((response.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L);
        }
        return 60;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public File getSaveLocation() {
        File save_location = this.torrent_save_location;
        if (save_location == this.cached_save_location) {
            return this.cached_save_location_result;
        }
        File res = this.download_manager_state.getFileLink(save_location);
        if (res == null) {
            res = save_location;
        } else {
            try {
                res = res.getCanonicalFile();
            }
            catch (Throwable e) {
                res = res.getAbsoluteFile();
            }
        }
        this.cached_save_location = save_location;
        this.cached_save_location_result = res;
        return res;
    }

    public File getAbsoluteSaveLocation() {
        return this.torrent_save_location;
    }

    public void setTorrentSaveDir(String new_dir) {
        File old_location = this.torrent_save_location;
        String old_dir = old_location.getParent();
        if (new_dir.equals(old_dir)) {
            return;
        }
        this.updateFileLinks(old_dir, new_dir, this.torrent.isSimpleTorrent() ? old_location.getParentFile() : old_location);
        this.torrent_save_location = new File(new_dir, old_location.getName());
        try {
            this.torrent_save_location = this.torrent_save_location.getCanonicalFile();
        }
        catch (Throwable e) {
            this.torrent_save_location = this.torrent_save_location.getAbsoluteFile();
        }
        this.controller.fileInfoChanged();
    }

    public String getPieceLength() {
        if (this.torrent != null) {
            return DisplayFormatters.formatByteCountToKiBEtc(this.torrent.getPieceLength());
        }
        return "";
    }

    public String getTorrentFileName() {
        return this.torrentFileName;
    }

    public void setTorrentFileName(String string) {
        this.torrentFileName = string;
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        TRTrackerScraperResponse r = null;
        TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            r = scraper.scrape(tc);
        }
        if (r == null && this.torrent != null) {
            TRTrackerScraperResponse non_null_response = null;
            TOTorrentAnnounceURLSet[] sets = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (sets.length == 0) {
                r = scraper.scrape(this.torrent);
            } else {
                Random scrape_random = new Random(this.scrape_random_seed);
                block0: for (int i = 0; r == null && i < sets.length; ++i) {
                    URL url;
                    int j;
                    TOTorrentAnnounceURLSet set = sets[i];
                    URL[] urls = set.getAnnounceURLs();
                    ArrayList<URL> rand_urls = new ArrayList<URL>();
                    for (j = 0; j < urls.length; ++j) {
                        url = urls[j];
                        int pos = (int)(scrape_random.nextDouble() * (double)(rand_urls.size() + 1));
                        rand_urls.add(pos, url);
                    }
                    for (j = 0; r == null && j < rand_urls.size(); ++j) {
                        url = (URL)rand_urls.get(j);
                        r = scraper.scrape(this.torrent, url);
                        if (r == null) continue;
                        int status = r.getStatus();
                        if (status == 2) {
                            if (!this.torrent.setAnnounceURL(url)) continue block0;
                            this.setTrackerScrapeResponse(r);
                            continue block0;
                        }
                        if (status == 0 || status == 3) continue block0;
                        if (r.isValid() && status != 1) continue;
                        if (non_null_response == null) {
                            non_null_response = r;
                        }
                        r = null;
                    }
                }
                if (r == null) {
                    r = non_null_response;
                }
            }
        }
        return r;
    }

    public void checkTracker(boolean force) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(force);
        }
    }

    public void scrapeTracker(boolean force) {
        if (this.torrent != null) {
            TRTrackerScraper scraper = this.globalManager.getTrackerScraper();
            scraper.scrape(this.torrent, force);
        }
    }

    protected void setTrackerRefreshDelayOverrides(int percent) {
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.setRefreshDelayOverrides(percent);
        }
    }

    public String getTorrentComment() {
        return this.torrent_comment;
    }

    public String getTorrentCreatedBy() {
        return this.torrent_created_by;
    }

    public long getTorrentCreationDate() {
        if (this.torrent == null) {
            return 0L;
        }
        return this.torrent.getCreationDate();
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public DiskManager getDiskManager() {
        return this.controller.getDiskManager();
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return this.controller.getDiskManagerFileInfo();
    }

    public PEPeerManager getPeerManager() {
        return this.controller.getPeerManager();
    }

    public boolean isDownloadComplete() {
        return this.onlySeeding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadManagerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.addListener(listener);
            listener.stateChanged(this, this.getState());
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadManagerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.removeListener(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStateChanged() {
        try {
            this.listeners_mon.enter();
            int new_state = this.controller.getState();
            boolean new_force_start = this.controller.isForceStart();
            if (new_state != this.last_informed_state || new_force_start != this.latest_informed_force_start) {
                this.last_informed_state = new_state;
                this.latest_informed_force_start = new_force_start;
                this.listeners.dispatch(1, new Object[]{this, new Integer(new_state)});
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informDownloadEnded() {
        try {
            this.listeners_mon.enter();
            this.listeners.dispatch(2, new Object[]{this});
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informPositionChanged(int new_position) {
        try {
            this.listeners_mon.enter();
            int old_position = this.position;
            if (new_position != old_position) {
                this.position = new_position;
                this.listeners.dispatch(4, new Object[]{this, new Integer(old_position), new Integer(new_position)});
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void addPeerListener(DownloadManagerPeerListener listener) {
        this.addPeerListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerListener(DownloadManagerPeerListener listener, boolean bDispatchForExisting) {
        try {
            int i;
            this.peer_listeners_mon.enter();
            this.peer_listeners.addListener(listener);
            if (!bDispatchForExisting) {
                return;
            }
            for (i = 0; i < this.current_peers.size(); ++i) {
                this.peer_listeners.dispatch(listener, 1, this.current_peers.get(i));
            }
            for (i = 0; i < this.current_pieces.size(); ++i) {
                this.peer_listeners.dispatch(listener, 3, this.current_pieces.get(i));
            }
            PEPeerManager temp = this.controller.getPeerManager();
            if (temp != null) {
                this.peer_listeners.dispatch(listener, 5, temp);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void removePeerListener(DownloadManagerPeerListener listener) {
        this.peer_listeners.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.add(peer);
            this.peer_listeners.dispatch(1, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeer(PEPeer peer) {
        try {
            this.peer_listeners_mon.enter();
            this.current_peers.remove(peer);
            this.peer_listeners.dispatch(2, peer);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPeer[] getCurrentPeers() {
        try {
            this.peer_listeners_mon.enter();
            PEPeer[] pEPeerArray = this.current_peers.toArray(new PEPeer[this.current_peers.size()]);
            return pEPeerArray;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPiece(PEPiece piece) {
        try {
            this.peer_listeners_mon.enter();
            this.current_pieces.add(piece);
            this.peer_listeners.dispatch(3, piece);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePiece(PEPiece piece) {
        try {
            this.peer_listeners_mon.enter();
            this.current_pieces.remove(piece);
            this.peer_listeners.dispatch(4, piece);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PEPiece[] getCurrentPieces() {
        try {
            this.peer_listeners_mon.enter();
            PEPiece[] pEPieceArray = this.current_pieces.toArray(new PEPiece[this.current_pieces.size()]);
            return pEPieceArray;
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStarted(PEPeerManager pm) {
        try {
            this.peer_listeners_mon.enter();
            this.peer_listeners.dispatch(5, pm);
        }
        finally {
            this.peer_listeners_mon.exit();
        }
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null) {
            tc.update(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informStopped(PEPeerManager pm) {
        if (pm != null) {
            try {
                this.peer_listeners_mon.enter();
                this.peer_listeners.dispatch(6, pm);
            }
            finally {
                this.peer_listeners_mon.exit();
            }
        }
        try {
            this.this_mon.enter();
            if (this.tracker_client != null) {
                this.tracker_client.addListener(this.stopping_tracker_client_listener);
                this.tracker_client.removeListener(this.tracker_client_listener);
                this.download_manager_state.setTrackerResponseCache(this.tracker_client.getTrackerResponseCache());
                this.tracker_client.stop();
                this.tracker_client.destroy();
                this.tracker_client = null;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isForceStart() {
        return this.controller.isForceStart();
    }

    public void setForceStart(boolean forceStart) {
        this.controller.setForceStart(forceStart);
    }

    protected void downloadEnded(boolean never_downloaded) {
        TRTrackerAnnouncer tc;
        if (!never_downloaded) {
            if (this.isForceStart()) {
                this.setForceStart(false);
            }
            this.setOnlySeeding(true);
            this.informDownloadEnded();
        }
        if ((tc = this.tracker_client) != null) {
            tc.complete(never_downloaded);
        }
    }

    public void addDiskListener(DownloadManagerDiskListener listener) {
        this.controller.addDiskListener(listener);
    }

    public void removeDiskListener(DownloadManagerDiskListener listener) {
        this.controller.removeDiskListener(listener);
    }

    public int getHealthStatus() {
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            boolean isSeed;
            int nbSeeds = this.getNbSeeds();
            int nbPeers = this.getNbPeers();
            int nbRemotes = peerManager.getNbRemoteConnections();
            TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
            int trackerStatus = announce_response.getStatus();
            boolean bl = isSeed = state == 60;
            if (nbSeeds + nbPeers == 0) {
                if (isSeed) {
                    return 2;
                }
                return 5;
            }
            if (!(isSeed || trackerStatus != 0 && trackerStatus != 1)) {
                return 2;
            }
            if (nbRemotes == 0) {
                TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
                if (scrape_response != null && scrape_response.isValid() && nbSeeds == scrape_response.getSeeds() && nbPeers == scrape_response.getPeers()) {
                    return 4;
                }
                return 3;
            }
            return 4;
        }
        if (state == 100) {
            return 6;
        }
        return 1;
    }

    public int getNATStatus() {
        int state = this.getState();
        PEPeerManager peerManager = this.controller.getPeerManager();
        TRTrackerAnnouncer tc = this.getTrackerClient();
        if (tc != null && peerManager != null && (state == 50 || state == 60)) {
            if (peerManager.getNbRemoteConnections() > 0) {
                return 1;
            }
            long last_good_time = peerManager.getLastRemoteConnectionTime();
            if (last_good_time > 0L) {
                if (SystemTime.getCurrentTime() - last_good_time < 1800000L) {
                    return 1;
                }
                return 2;
            }
            TRTrackerAnnouncerResponse announce_response = tc.getLastResponse();
            int trackerStatus = announce_response.getStatus();
            if (trackerStatus == 0 || trackerStatus == 1) {
                return 0;
            }
            if (SystemTime.getCurrentTime() - peerManager.getTimeStarted() < 180000L) {
                return 0;
            }
            TRTrackerScraperResponse scrape_response = this.getTrackerScrapeResponse();
            if (scrape_response != null && scrape_response.isValid() && peerManager.getNbSeeds() == scrape_response.getSeeds() && peerManager.getNbPeers() == scrape_response.getPeers()) {
                return 0;
            }
            return 3;
        }
        return 0;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int new_position) {
        this.informPositionChanged(new_position);
    }

    public void addTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.addListener(listener);
    }

    public void removeTrackerListener(DownloadManagerTrackerListener listener) {
        this.tracker_listeners.removeListener(listener);
    }

    protected void deleteDataFiles() {
        DiskManagerFactory.deleteDataFiles(this.torrent, this.torrent_save_location.getParent(), this.torrent_save_location.getName());
    }

    protected void deleteTorrentFile() {
        if (this.torrentFileName != null) {
            TorrentUtils.delete(new File(this.torrentFileName));
        }
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager_state;
    }

    public Object getData(String key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        try {
            this.peer_listeners_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                }
            } else {
                this.data.put(key, value);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public boolean isDataAlreadyAllocated() {
        return this.data_already_allocated;
    }

    public void setDataAlreadyAllocated(boolean already_allocated) {
        this.data_already_allocated = already_allocated;
    }

    public void setSeedingRank(int rank) {
        this.iSeedingRank = rank;
    }

    public int getSeedingRank() {
        return this.iSeedingRank;
    }

    public long getCreationTime() {
        return this.creation_time;
    }

    public void setCreationTime(long t) {
        this.creation_time = t;
    }

    public boolean isAZMessagingEnabled() {
        return this.az_messaging_enabled;
    }

    public void setAZMessagingEnabled(boolean enable) {
        this.az_messaging_enabled = enable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveDataFiles(File new_parent_dir) throws DownloadManagerException {
        if (!this.isPersistent()) {
            throw new DownloadManagerException("Download is not persistent");
        }
        File old_file = this.getSaveLocation();
        try {
            old_file = old_file.getCanonicalFile();
            new_parent_dir = new_parent_dir.getCanonicalFile();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DownloadManagerException("Failed to get canonical paths", e);
        }
        if (new_parent_dir.equals(old_file.getParentFile())) {
            return;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null) {
            if (!old_file.exists()) {
                new_parent_dir.mkdirs();
                this.setTorrentSaveDir(new_parent_dir.toString());
                return;
            }
            File new_file = new File(new_parent_dir, old_file.getName());
            if (!FileUtil.renameFile(old_file, new_file)) throw new DownloadManagerException("rename operation failed");
            this.setTorrentSaveDir(new_parent_dir.toString());
            return;
        } else {
            dm.moveDataFiles(new_parent_dir);
        }
    }

    public void moveTorrentFile(File new_parent_dir) throws DownloadManagerException {
        File new_file;
        if (!this.isPersistent()) {
            throw new DownloadManagerException("Download is not persistent");
        }
        int state = this.getState();
        if (state == 70 || state == 100) {
            File old_file = new File(this.getTorrentFileName());
            if (!old_file.exists()) {
                Debug.out("torrent file doesn't exist!");
                return;
            }
            new_file = new File(new_parent_dir, old_file.getName());
            try {
                old_file = old_file.getCanonicalFile();
                new_parent_dir = new_parent_dir.getCanonicalFile();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new DownloadManagerException("Failed to get canonical paths", e);
            }
            if (new_parent_dir.equals(old_file.getParentFile())) {
                return;
            }
            if (!TorrentUtils.move(old_file, new_file)) {
                throw new DownloadManagerException("rename operation failed");
            }
        } else {
            throw new DownloadManagerException("download not stopped or in error state");
        }
        this.setTorrentFileName(new_file.toString());
    }

    private byte[] getIdentity() {
        return this.dl_identity;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DownloadManagerImpl) {
            DownloadManagerImpl other = (DownloadManagerImpl)obj;
            byte[] id1 = this.getIdentity();
            byte[] id2 = other.getIdentity();
            if (id1 == null || id2 == null) {
                return false;
            }
            return Arrays.equals(id1, id2);
        }
        return false;
    }

    public int hashCode() {
        return this.dl_identity_hashcode;
    }

    public String getRelationText() {
        return "TorrentDLM: '" + this.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.tracker_client};
    }
}

