/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private File file;
    private int file_index;
    private CacheFile cache_file;
    private String extension;
    private long length;
    private long downloaded;
    private int firstPieceNumber = -1;
    private int nbPieces = 0;
    private DiskManagerHelper diskManager;
    private TOTorrentFile torrent_file;
    private boolean priority = false;
    private boolean skipped = false;

    public DiskManagerFileInfoImpl(DiskManagerHelper _disk_manager, File _file, int _file_index, TOTorrentFile _torrent_file, boolean _linear_storage) throws CacheFileManagerException {
        this.diskManager = _disk_manager;
        this.torrent_file = _torrent_file;
        this.file = _file;
        this.file_index = _file_index;
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, _file, _linear_storage ? 1 : 2);
    }

    public String getCacheFileOwnerName() {
        return this.diskManager.getInternalName();
    }

    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    public File getCacheFileControlFile(String name) {
        return this.diskManager.getDownloadState().getStateFile(name);
    }

    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    protected void moveFile(File newFile) throws CacheFileManagerException {
        this.cache_file.moveFile(newFile);
        this.file = newFile;
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        int old_mode = this.cache_file.getAccessMode();
        this.cache_file.setAccessMode(mode == 1 ? 1 : 2);
        if (old_mode != mode) {
            this.diskManager.accessModeChanged(this, old_mode, mode);
        }
    }

    public int getAccessMode() {
        int mode = this.cache_file.getAccessMode();
        return mode == 1 ? 1 : 2;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getFile(boolean follow_link) {
        File res;
        if (follow_link && (res = this.getLink()) != null) {
            return res;
        }
        return this.file;
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean setLink(File link_destination) {
        Debug.out("setLink: download must be stopped");
        return false;
    }

    public File getLink() {
        return this.diskManager.getDownloadState().getFileLink(this.getFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStorageType(int type) {
        boolean bl;
        int old_type;
        String[] types = this.diskManager.getStorageTypes();
        int n = old_type = types[this.file_index].equals("L") ? 1 : 2;
        if (type == old_type) {
            return true;
        }
        if (type == 2) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return false;
        }
        try {
            this.cache_file.setStorageType(type == 1 ? 1 : 2);
            bl = true;
            Object var7_6 = null;
            types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                Debug.printStackTrace(e);
                this.diskManager.setFailed(this, "Failed to change storage type for '" + this.getFile(true) + "': " + Debug.getNestedExceptionMessage(e));
                bl2 = false;
                Object var7_7 = null;
                types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                types[this.file_index] = this.cache_file.getStorageType() == 1 ? "L" : "C";
                DownloadManagerState dm_state = this.diskManager.getDownloadState();
                dm_state.setListAttribute("storetypes", types);
                dm_state.save();
                throw throwable;
            }
            DownloadManagerState dm_state = this.diskManager.getDownloadState();
            dm_state.setListAttribute("storetypes", types);
            dm_state.save();
            return bl2;
        }
        DownloadManagerState dm_state = this.diskManager.getDownloadState();
        dm_state.setListAttribute("storetypes", types);
        dm_state.save();
        return bl;
    }

    public int getStorageType() {
        String[] types = this.diskManager.getStorageTypes();
        return types[this.file_index].equals("L") ? 1 : 2;
    }

    protected boolean isLinked() {
        return this.getLink() != null;
    }

    public int getFirstPieceNumber() {
        return this.firstPieceNumber;
    }

    public int getLastPieceNumber() {
        return this.firstPieceNumber + this.nbPieces - 1;
    }

    public long getLength() {
        return this.length;
    }

    public int getIndex() {
        return this.file_index;
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setFirstPieceNumber(int i) {
        this.firstPieceNumber = i;
    }

    public void setLength(long l) {
        this.length = l >= 0L ? l : 0L;
    }

    public void setNbPieces(int i) {
        this.nbPieces = i;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean b) {
        this.priority = b;
        this.diskManager.priorityChanged(this);
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean _skipped) {
        this.skipped = _skipped;
        this.diskManager.skippedFileSetChanged(this);
    }

    public DiskManager getDiskManager() {
        return this.diskManager;
    }
}

