/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManager;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.services.UPnPWANCommonInterfaceConfig;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPPlugin
implements Plugin,
UPnPMappingListener {
    private static final String PLUGIN_CONFIGSECTION_ID = "UPnP";
    protected PluginInterface plugin_interface;
    protected LoggerChannel log;
    protected UPnPMappingManager mapping_manager = UPnPMappingManager.getSingleton();
    protected UPnP upnp;
    protected BooleanParameter alert_success_param;
    protected BooleanParameter grab_ports_param;
    protected BooleanParameter alert_other_port_param;
    protected BooleanParameter alert_device_probs_param;
    protected BooleanParameter release_mappings_param;
    protected StringParameter selected_interfaces_param;
    protected List mappings = new ArrayList();
    protected List services = new ArrayList();
    protected Map root_info_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("UPnPPlugin");

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Universal Plug and Play (UPnP)");
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
            }

            public void closedownInitiated() {
                if (UPnPPlugin.this.services.size() == 0) {
                    UPnPPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", "");
                }
            }

            public void closedownComplete() {
                UPnPPlugin.this.closeDown(true);
            }
        });
        this.log = this.plugin_interface.getLogger().getTimeStampedChannel(PLUGIN_CONFIGSECTION_ID);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel model = ui_manager.createBasicPluginViewModel(PLUGIN_CONFIGSECTION_ID);
        model.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        BasicPluginConfigModel config = ui_manager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addLabelParameter2("upnp.info");
        ActionParameter wiki = config.addActionParameter2("Utils.link.visit", "MainWindow.about.internet.wiki");
        wiki.setStyle(2);
        wiki.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                try {
                    UPnPPlugin.this.plugin_interface.getUIManager().openURL(new URL("http://azureus.aelitis.com/wiki/index.php/UPnP"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        final BooleanParameter enable_param = config.addBooleanParameter2("upnp.enable", "upnp.enable", true);
        this.grab_ports_param = config.addBooleanParameter2("upnp.grabports", "upnp.grabports", false);
        this.release_mappings_param = config.addBooleanParameter2("upnp.releasemappings", "upnp.releasemappings", true);
        ActionParameter refresh_param = config.addActionParameter2("upnp.refresh.label", "upnp.refresh.button");
        refresh_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                UPnPPlugin.this.upnp.reset();
            }
        });
        config.addLabelParameter2("blank.resource");
        this.alert_success_param = config.addBooleanParameter2("upnp.alertsuccess", "upnp.alertsuccess", false);
        this.alert_other_port_param = config.addBooleanParameter2("upnp.alertothermappings", "upnp.alertothermappings", true);
        this.alert_device_probs_param = config.addBooleanParameter2("upnp.alertdeviceproblems", "upnp.alertdeviceproblems", true);
        this.selected_interfaces_param = config.addStringParameter2("upnp.selectedinterfaces", "upnp.selectedinterfaces", "");
        enable_param.addEnabledOnSelection(this.alert_success_param);
        enable_param.addEnabledOnSelection(this.grab_ports_param);
        enable_param.addEnabledOnSelection(refresh_param);
        enable_param.addEnabledOnSelection(this.alert_other_port_param);
        enable_param.addEnabledOnSelection(this.alert_device_probs_param);
        enable_param.addEnabledOnSelection(this.release_mappings_param);
        boolean enabled = enable_param.getValue();
        model.getStatus().setText(enabled ? "Running" : "Disabled");
        enable_param.addListener(new ParameterListener(){

            public void parameterChanged(Parameter p) {
                boolean e = enable_param.getValue();
                model.getStatus().setText(e ? "Running" : "Disabled");
                if (e) {
                    UPnPPlugin.this.startUp();
                } else {
                    UPnPPlugin.this.closeDown(true);
                }
            }
        });
        model.getActivity().setVisible(false);
        model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        if (enabled) {
            this.startUp();
        }
    }

    protected void startUp() {
        if (this.upnp != null) {
            this.upnp.reset();
            return;
        }
        final LoggerChannel core_log = this.plugin_interface.getLogger().getChannel("UPnP Core");
        try {
            this.upnp = UPnPFactory.getSingleton(new UPnPAdapter(){

                public SimpleXMLParserDocument parseXML(String data) throws SimpleXMLParserDocumentException {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getSimpleXMLParserDocumentFactory().create(data);
                }

                public ResourceDownloaderFactory getResourceDownloaderFactory() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                }

                public UTTimer createTimer(String name) {
                    return UPnPPlugin.this.plugin_interface.getUtilities().createTimer(name, true);
                }

                public void createThread(String name, Runnable runnable) {
                    UPnPPlugin.this.plugin_interface.getUtilities().createThread(name, runnable);
                }

                public Comparator getAlphanumericComparator() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().getAlphanumericComparator(true);
                }

                public void trace(String str) {
                    core_log.log(str);
                }

                public void log(Throwable e) {
                    core_log.log(e);
                    Debug.printStackTrace(e);
                }

                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                public String getTraceDir() {
                    return UPnPPlugin.this.plugin_interface.getUtilities().getAzureusUserDir();
                }
            }, this.getSelectedInterfaces());
            this.upnp.addRootDeviceListener(new UPnPListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void rootDeviceFound(UPnPRootDevice device) {
                    try {
                        UPnPPlugin.this.processDevice(device.getDevice());
                        try {
                            UPnPPlugin.this.this_mon.enter();
                            UPnPPlugin.this.root_info_map.put(device.getLocation(), device.getInfo());
                            Iterator it = UPnPPlugin.this.root_info_map.values().iterator();
                            String all_info = "";
                            while (it.hasNext()) {
                                String info = (String)it.next();
                                if (info == null) continue;
                                all_info = all_info + (all_info.length() == 0 ? "" : ",") + info;
                            }
                            if (all_info.length() > 0) {
                                UPnPPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("plugin.info", all_info);
                            }
                        }
                        finally {
                            UPnPPlugin.this.this_mon.exit();
                        }
                    }
                    catch (Throwable e) {
                        UPnPPlugin.this.log.log("Root device processing fails", e);
                    }
                }
            });
            this.upnp.addLogListener(new UPnPLogListener(){

                public void log(String str) {
                    UPnPPlugin.this.log.log(str);
                }

                public void logAlert(String str, boolean error, int type) {
                    boolean logged = false;
                    if (UPnPPlugin.this.alert_device_probs_param.getValue()) {
                        if (type == 1) {
                            UPnPPlugin.this.log.logAlertRepeatable(error ? 3 : 2, str);
                            logged = true;
                        } else {
                            boolean do_it = false;
                            if (type == 3) {
                                byte[] fp = UPnPPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(str.getBytes());
                                String key = "upnp.alert.fp." + UPnPPlugin.this.plugin_interface.getUtilities().getFormatters().encodeBytesToString(fp);
                                PluginConfig pc = UPnPPlugin.this.plugin_interface.getPluginconfig();
                                if (!pc.getPluginBooleanParameter(key, false)) {
                                    pc.setPluginParameter(key, true);
                                    do_it = true;
                                }
                            } else {
                                do_it = true;
                            }
                            if (do_it) {
                                UPnPPlugin.this.log.logAlert(error ? 3 : 2, str);
                                logged = true;
                            }
                        }
                    }
                    if (!logged) {
                        UPnPPlugin.this.log.log(str);
                    }
                }
            });
            this.mapping_manager.addListener(new UPnPMappingManagerListener(){

                public void mappingAdded(UPnPMapping mapping) {
                    UPnPPlugin.this.addMapping(mapping);
                }
            });
            UPnPMapping[] upnp_mappings = this.mapping_manager.getMappings();
            for (int i = 0; i < upnp_mappings.length; ++i) {
                this.addMapping(upnp_mappings[i]);
            }
        }
        catch (Throwable e) {
            this.log.log(e);
        }
    }

    protected void closeDown(boolean end_of_day) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (!mapping.isEnabled()) continue;
            for (int j = 0; j < this.services.size(); ++j) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                service.removeMapping(this.log, mapping, end_of_day);
            }
        }
    }

    protected String[] getSelectedInterfaces() {
        String si = this.selected_interfaces_param.getValue().trim();
        StringTokenizer tok = new StringTokenizer(si, ";");
        ArrayList<String> res = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (s.length() <= 0) continue;
            res.add(s);
        }
        return res.toArray(new String[res.size()]);
    }

    protected void processDevice(UPnPDevice device) throws UPnPException {
        this.processServices(device, device.getServices());
        UPnPDevice[] kids = device.getSubDevices();
        for (int i = 0; i < kids.length; ++i) {
            this.processDevice(kids[i]);
        }
    }

    protected void processServices(UPnPDevice device, UPnPService[] device_services) throws UPnPException {
        for (int i = 0; i < device_services.length; ++i) {
            UPnPService s = device_services[i];
            String service_type = s.getServiceType();
            if (service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1") || service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANPPPConnection:1")) {
                final UPnPWANConnection wan_service = (UPnPWANConnection)s.getSpecificService();
                device.getRootDevice().addListener(new UPnPRootDeviceListener(){

                    public void lost(UPnPRootDevice root, boolean replaced) {
                        UPnPPlugin.this.removeService(wan_service, replaced);
                    }
                });
                this.addService(wan_service);
                continue;
            }
            if (!service_type.equalsIgnoreCase("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1")) continue;
            try {
                UPnPWANCommonInterfaceConfig config = (UPnPWANCommonInterfaceConfig)s.getSpecificService();
                long[] speeds = config.getCommonLinkProperties();
                if (speeds[0] <= 0L || speeds[1] <= 0L) continue;
                this.log.log("Device speed: down=" + this.plugin_interface.getUtilities().getFormatters().formatByteCountToKiBEtcPerSec(speeds[0] / 8L) + ", up=" + this.plugin_interface.getUtilities().getFormatters().formatByteCountToKiBEtcPerSec(speeds[1] / 8L));
                continue;
            }
            catch (Throwable e) {
                this.log.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addService(UPnPWANConnection wan_service) throws UPnPException {
        try {
            this.this_mon.enter();
            this.log.log("    Found " + (wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection"));
            UPnPWANConnectionPortMapping[] ports = wan_service.getPortMappings();
            for (int j = 0; j < ports.length; ++j) {
                this.log.log("      mapping [" + j + "] " + ports[j].getExternalPort() + "/" + (ports[j].isTCP() ? "TCP" : "UDP") + " [" + ports[j].getDescription() + "] -> " + ports[j].getInternalHost());
            }
            this.services.add(new UPnPPluginService(wan_service, ports, this.alert_success_param, this.grab_ports_param, this.alert_other_port_param, this.release_mappings_param));
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeService(UPnPWANConnection wan_service, boolean replaced) {
        try {
            this.this_mon.enter();
            String name = wan_service.getGenericService().getServiceType().indexOf("PPP") == -1 ? "WANIPConnection" : "WANPPPConnection";
            String text = MessageText.getString("upnp.alert.lostdevice", new String[]{name, wan_service.getGenericService().getDevice().getRootDevice().getLocation().getHost()});
            this.log.log(text);
            if (!replaced && this.alert_device_probs_param.getValue()) {
                this.log.logAlertRepeatable(2, text);
            }
            for (int i = 0; i < this.services.size(); ++i) {
                UPnPPluginService ps = (UPnPPluginService)this.services.get(i);
                if (ps.getService() != wan_service) continue;
                this.services.remove(i);
                break;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMapping(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.add(mapping);
            this.log.log("Mapping request: " + mapping.getString() + ", enabled = " + mapping.isEnabled());
            mapping.addListener(this);
            this.checkState();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void mappingChanged(UPnPMapping mapping) {
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mappingDestroyed(UPnPMapping mapping) {
        try {
            this.this_mon.enter();
            this.mappings.remove(mapping);
            for (int j = 0; j < this.services.size(); ++j) {
                UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                service.removeMapping(this.log, mapping, false);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.mappings.size(); ++i) {
                UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
                for (int j = 0; j < this.services.size(); ++j) {
                    UPnPPluginService service = (UPnPPluginService)this.services.get(j);
                    service.checkMapping(this.log, mapping);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        return UPnPMappingManager.getSingleton().addMapping(desc_resource, tcp, port, enabled);
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        return UPnPMappingManager.getSingleton().getMapping(tcp, port);
    }
}

