/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl;

import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheUploader;
import com.aelitis.azureus.plugins.jpc.cache.impl.PieceRequest;
import com.aelitis.azureus.plugins.jpc.peer.impl.messaging.JPCCacheReply;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessageManager;
import org.gudy.azureus2.plugins.messaging.bittorrent.BTMessagePiece;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueueListener;
import org.gudy.azureus2.plugins.peers.Peer;

public class JPCCacheMultiplexerHelper {
    private final int MAX_REQUEST_HISTORY = 150;
    private final JPCPlugin jpc_plugin;
    private final Peer peer;
    private final Download download;
    private final int downloader_id;
    private final Listener listener;
    private JPCCacheUploader cache = null;
    private final LinkedList requests = new LinkedList();
    private final OutgoingMessageQueueListener queue_listener = new OutgoingMessageQueueListener(){

        public boolean messageAdded(Message mesg) {
            if (JPCCacheMultiplexerHelper.this.cache == null) {
                return true;
            }
            if (mesg.getID().equals("BT_UNCHOKE")) {
                JPCCacheMultiplexerHelper.this.listener.establishmentNeeded();
                return true;
            }
            if (mesg.getID().equals("BT_PIECE")) {
                BTMessagePiece piece = BTMessageManager.createCoreBTPieceAdaptation(mesg);
                byte[] hash = JPCCacheMultiplexerHelper.this.download.getTorrent().getHash();
                int number = piece.getPieceNumber();
                int offset = piece.getPieceOffset();
                ByteBuffer data = piece.getPieceData();
                PieceRequest request2 = new PieceRequest(hash, number, offset, data.remaining());
                boolean found = JPCCacheMultiplexerHelper.this.requests.remove(request2);
                if (!found) {
                    JPCCacheMultiplexerHelper.this.jpc_plugin.log("Piece data [" + number + ":" + offset + "+" + data.remaining() + "] not requested via cache, sending direct as normal", 2);
                    return true;
                }
                JPCCacheMultiplexerHelper.this.cache.sendBlock(JPCCacheMultiplexerHelper.this.downloader_id, hash, number, offset, data);
                JPCCacheMultiplexerHelper.this.listener.messageSent();
                return false;
            }
            return true;
        }

        public void messageSent(Message message) {
        }

        public void bytesSent(int byte_count) {
        }
    };

    public JPCCacheMultiplexerHelper(JPCPlugin plugin, Download download, Peer download_peer, int downloader_id, Listener listener) {
        this.jpc_plugin = plugin;
        this.peer = download_peer;
        this.download = download;
        this.downloader_id = downloader_id;
        this.listener = listener;
    }

    public void sessionEstablished(JPCCacheUploader up_cache, int upload_id) {
        this.cache = up_cache;
        this.peer.getConnection().getOutgoingMessageQueue().sendMessage(new JPCCacheReply(upload_id));
        this.peer.getConnection().getOutgoingMessageQueue().registerListener(this.queue_listener);
    }

    public void receivedRequest(byte[] hash, int piece_index, int start_offset, int length) {
        this.requests.add(new PieceRequest(hash, piece_index, start_offset, length));
        Message request2 = BTMessageManager.createCoreBTRequest(piece_index, start_offset, length);
        this.peer.getConnection().getIncomingMessageQueue().notifyOfExternalReceive(request2);
    }

    public void receivedDownloaded(byte[] hash, int piece_index, int start_offset, int length) {
        Message fake = BTMessageManager.createCoreBTPiece(piece_index, start_offset, ByteBuffer.allocate(length));
        this.peer.getConnection().getOutgoingMessageQueue().notifyOfExternalSend(fake);
    }

    public void destroy() {
        this.peer.getConnection().getOutgoingMessageQueue().deregisterListener(this.queue_listener);
    }

    public static interface Listener {
        public void messageSent();

        public void establishmentNeeded();
    }
}

