/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloader;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheDownloaderAdapter;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheFactory;
import com.aelitis.azureus.plugins.jpc.cache.JPCCacheManager;
import com.aelitis.azureus.plugins.jpc.cache.impl.JPCCacheMultiplexer;
import com.aelitis.azureus.plugins.jpc.discovery.JPCDiscovery;
import com.aelitis.azureus.plugins.jpc.discovery.JPCDiscoveryAdapter;
import com.aelitis.azureus.plugins.jpc.discovery.JPCDiscoveryFactory;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.utils.Monitor;

public class JPCCacheManagerImpl
implements JPCCacheManager {
    private final JPCPlugin jpc_plugin;
    private final HashMap upload_caches = new HashMap();
    private final Monitor upload_caches_mon;
    private JPCCacheDownloader download_cache = null;

    public JPCCacheManagerImpl(JPCPlugin plugin) {
        this.jpc_plugin = plugin;
        this.upload_caches_mon = this.jpc_plugin.getPluginInterface().getUtilities().getMonitor();
    }

    public void connectLocalDownloadCache(final JPCCacheDownloaderAdapter adapter) {
        this.jpc_plugin.getPluginInterface().getUtilities().createThread("JPCLocalCacheConnect", new Runnable(){

            public void run() {
                try {
                    JPCDiscoveryFactory.create(JPCCacheManagerImpl.this.jpc_plugin, new JPCDiscoveryAdapter(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void cacheDiscovered(JPCDiscovery discovery, boolean same_as_before) {
                            InetSocketAddress cache_address = discovery.getCacheAddress();
                            if (cache_address == null) {
                                1.access$100(this.this$1).connectionError(new JPCException("download cache_address == null"));
                            } else {
                                if (same_as_before && JPCCacheManagerImpl.access$300(1.access$200(this.this$1)).isConnected()) {
                                    JPCCacheManagerImpl.access$000(1.access$200(this.this$1)).log("Local download cache server [" + cache_address + "] re-discovered at same address; re-verifying...", 2);
                                    1.access$100(this.this$1).connectSuccess(JPCCacheManagerImpl.access$300(1.access$200(this.this$1)), false);
                                    return;
                                }
                                JPCCacheManagerImpl.access$302(1.access$200(this.this$1), JPCCacheFactory.createDownloader(JPCCacheManagerImpl.access$000(1.access$200(this.this$1)), cache_address));
                                JPCCacheManagerImpl.access$000(1.access$200(this.this$1)).log("Local download cache server [" + cache_address + "] connection attempt started.", 2);
                                try {
                                    JPCCacheManagerImpl.access$300(1.access$200(this.this$1)).connect(1.access$100(this.this$1));
                                }
                                catch (JPCException e) {
                                    e.printStackTrace();
                                    1.access$100(this.this$1).connectionError(e);
                                }
                            }
                        }
                    });
                }
                catch (JPCException e) {
                    JPCCacheManagerImpl.this.jpc_plugin.log("Failed to connect to local download cache", e, 1);
                }
            }

            static /* synthetic */ JPCCacheDownloaderAdapter access$100(1 x0) {
                return x0.adapter;
            }

            static /* synthetic */ JPCCacheManagerImpl access$200(1 x0) {
                return x0.JPCCacheManagerImpl.this;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWithRemoteUploadCache(InetSocketAddress address, Download download, Peer download_peer, int downloader_id) {
        try {
            this.upload_caches_mon.enter();
            JPCCacheMultiplexer cache_mux = (JPCCacheMultiplexer)this.upload_caches.get(address);
            if (cache_mux == null) {
                this.jpc_plugin.log("No existing upload cache connection to [" + address + "], establishing new.", 2);
                cache_mux = new JPCCacheMultiplexer(this.jpc_plugin, this, JPCCacheFactory.createUploader(this.jpc_plugin, address));
                this.upload_caches.put(address, cache_mux);
            } else {
                this.jpc_plugin.log("upload cache connection to [" + address + "] already established, mux'ing in new session", 2);
            }
            cache_mux.registerSession(download, download_peer, downloader_id);
        }
        finally {
            this.upload_caches_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRemoteUploadCacheRegistration(int downloader_id) {
        try {
            this.upload_caches_mon.enter();
            Iterator it = this.upload_caches.values().iterator();
            while (it.hasNext()) {
                JPCCacheMultiplexer cache_mux = (JPCCacheMultiplexer)it.next();
                if (!cache_mux.deregisterSession(downloader_id)) continue;
                break;
            }
        }
        finally {
            this.upload_caches_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRemoteUploadCache(InetSocketAddress address) {
        try {
            this.upload_caches_mon.enter();
            this.upload_caches.remove(address);
        }
        finally {
            this.upload_caches_mon.exit();
        }
    }

    static /* synthetic */ JPCCacheDownloader access$300(JPCCacheManagerImpl x0) {
        return x0.download_cache;
    }

    static /* synthetic */ JPCCacheDownloader access$302(JPCCacheManagerImpl x0, JPCCacheDownloader x1) {
        x0.download_cache = x1;
        return x0.download_cache;
    }
}

