/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class PeerItemFactory {
    public static final int PEER_SOURCE_TRACKER = 0;
    public static final int PEER_SOURCE_DHT = 1;
    public static final int PEER_SOURCE_PEER_EXCHANGE = 2;
    public static final int PEER_SOURCE_PLUGIN = 3;
    public static final int PEER_SOURCE_INCOMING = 4;
    public static final int HANDSHAKE_TYPE_PLAIN = 0;
    public static final int HANDSHAKE_TYPE_CRYPTO = 1;
    private static final WeakHashMap peer_items = new WeakHashMap();
    private static final AEMonitor item_mon = new AEMonitor("PeerItemFactory");

    public static PeerItem createPeerItem(String address, int port, int source, int handshake_type) {
        return PeerItemFactory.getLightweight(new PeerItem(address, port, source, handshake_type));
    }

    public static PeerItem createPeerItem(byte[] serialization, int source, int handshake_type) {
        return PeerItemFactory.getLightweight(new PeerItem(serialization, source, handshake_type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PeerItem getLightweight(PeerItem key) {
        try {
            item_mon.enter();
            WeakReference ref = (WeakReference)peer_items.get(key);
            if (ref == null) {
                peer_items.put(key, new WeakReference<PeerItem>(key));
                PeerItem peerItem = key;
                return peerItem;
            }
            PeerItem item = (PeerItem)ref.get();
            if (item == null) {
                Debug.out("OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOPS: ref.get() == null");
                peer_items.put(key, new WeakReference<PeerItem>(key));
                PeerItem peerItem = key;
                return peerItem;
            }
            PeerItem peerItem = item;
            return peerItem;
        }
        finally {
            item_mon.exit();
        }
    }
}

