/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportHelper {
    private static boolean enable_efficient_io = !Constants.JAVA_VERSION.startsWith("1.4");
    private final SocketChannel channel;

    public TCPTransportHelper(SocketChannel _channel) {
        this.channel = _channel;
    }

    public int write(ByteBuffer buffer) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        return this.channel.write(buffer);
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (enable_efficient_io) {
            try {
                return this.channel.write(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket write failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        }
        long written_sofar = 0L;
        for (int i = array_offset; i < array_offset + length; ++i) {
            int data_length = buffers[i].remaining();
            int written = this.channel.write(buffers[i]);
            written_sofar += (long)written;
            if (written < data_length) break;
        }
        return written_sofar;
    }

    public int read(ByteBuffer buffer) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0;
        }
        return this.channel.read(buffer);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.channel == null) {
            Debug.out("channel == null");
            return 0L;
        }
        if (buffers == null) {
            Debug.out("read: buffers == null");
            return 0L;
        }
        long bytes_read = 0L;
        if (enable_efficient_io) {
            try {
                bytes_read = this.channel.read(buffers, array_offset, length);
            }
            catch (IOException ioe) {
                String msg = ioe.getMessage();
                if (msg != null && msg.equals("A non-blocking socket operation could not be completed immediately")) {
                    enable_efficient_io = false;
                    Logger.log(new LogAlert(false, 1, "WARNING: Multi-buffer socket read failed; switching to single-buffer mode.\nUpgrade to JRE 1.5 (5.0) series to fix this problem!"));
                }
                throw ioe;
            }
        } else {
            for (int i = array_offset; i < array_offset + length; ++i) {
                int data_length = buffers[i].remaining();
                int read = this.channel.read(buffers[i]);
                bytes_read += (long)read;
                if (read < data_length) break;
            }
        }
        if (bytes_read < 0L) {
            throw new IOException("end of stream on socket read");
        }
        return bytes_read;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }
}

