/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilterTransparent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPProtocolDecoderInitial
extends TCPProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static VirtualChannelSelector read_selector = NetworkManager.getSingleton().getReadSelector();
    private static VirtualChannelSelector write_selector = NetworkManager.getSingleton().getWriteSelector();
    private TCPProtocolDecoderAdapter adapter;
    private TCPTransportHelperFilter filter;
    private SocketChannel channel;
    private byte[] shared_secret;
    private ByteBuffer decode_buffer;
    private int decode_read;
    private long start_time = SystemTime.getCurrentTime();
    private TCPProtocolDecoderPHE phe_decoder;
    private long last_read_time = 0L;
    private boolean processing_complete;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TCPProtocolDecoderInitial(SocketChannel _channel, byte[] _shared_secret, boolean _outgoing, TCPProtocolDecoderAdapter _adapter) throws IOException {
        super(true);
        this.channel = _channel;
        this.shared_secret = _shared_secret;
        this.adapter = _adapter;
        final TCPTransportHelper transport_helper = new TCPTransportHelper(this.channel);
        final TCPTransportHelperFilterTransparent transparent_filter = new TCPTransportHelperFilterTransparent(transport_helper, false);
        this.filter = transparent_filter;
        if (_outgoing) {
            if (!TCPProtocolDecoderPHE.isCryptoOK()) throw new IOException("Crypto required but unavailable");
            this.decodePHE(null);
            return;
        } else {
            this.decode_buffer = ByteBuffer.allocate(this.adapter.getMaximumPlainHeaderLength());
            read_selector.register(this.channel, new VirtualChannelSelector.VirtualSelectorListener(){

                public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                    try {
                        int len = transport_helper.read(TCPProtocolDecoderInitial.this.decode_buffer);
                        if (len < 0) {
                            TCPProtocolDecoderInitial.this.failed(new IOException("end of stream on socket read: in=" + TCPProtocolDecoderInitial.this.decode_buffer.position()));
                        } else if (len == 0) {
                            return false;
                        }
                        TCPProtocolDecoderInitial.this.last_read_time = SystemTime.getCurrentTime();
                        TCPProtocolDecoderInitial.this.decode_read += len;
                        int match = TCPProtocolDecoderInitial.this.adapter.matchPlainHeader(TCPProtocolDecoderInitial.this.decode_buffer);
                        if (match != 1) {
                            read_selector.cancel(TCPProtocolDecoderInitial.this.channel);
                            if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && match == 2) {
                                if (NetworkManager.INCOMING_HANDSHAKE_FALLBACK_ALLOWED) {
                                    Logger.log(new LogEvent(LOGID, "Incoming TCP connection [" + TCPProtocolDecoderInitial.this.channel + "] is not encrypted but has been accepted as fallback is enabled"));
                                } else if (AddressUtils.isLANLocalAddress(TCPProtocolDecoderInitial.this.channel.socket().getInetAddress().getHostAddress())) {
                                    Logger.log(new LogEvent(LOGID, "Incoming TCP connection [" + TCPProtocolDecoderInitial.this.channel + "] is not encrypted but has been accepted as lan-local"));
                                } else {
                                    throw new IOException("Crypto required but incoming connection has none");
                                }
                            }
                            TCPProtocolDecoderInitial.this.decode_buffer.flip();
                            transparent_filter.insertRead(TCPProtocolDecoderInitial.this.decode_buffer);
                            TCPProtocolDecoderInitial.this.complete();
                        } else if (!TCPProtocolDecoderInitial.this.decode_buffer.hasRemaining()) {
                            read_selector.cancel(TCPProtocolDecoderInitial.this.channel);
                            TCPProtocolDecoderInitial.this.decode_buffer.flip();
                            TCPProtocolDecoderInitial.this.decodePHE(TCPProtocolDecoderInitial.this.decode_buffer);
                        }
                        return true;
                    }
                    catch (Throwable e) {
                        this.selectFailure(selector, sc, attachment, e);
                        return false;
                    }
                }

                public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                    read_selector.cancel(TCPProtocolDecoderInitial.this.channel);
                    TCPProtocolDecoderInitial.this.failed(msg);
                }
            }, this);
        }
    }

    protected void decodePHE(ByteBuffer buffer) throws IOException {
        TCPProtocolDecoderAdapter phe_adapter = new TCPProtocolDecoderAdapter(){

            public void decodeComplete(TCPProtocolDecoder decoder) {
                TCPProtocolDecoderInitial.this.filter = decoder.getFilter();
                TCPProtocolDecoderInitial.this.complete();
            }

            public void decodeFailed(TCPProtocolDecoder decoder, Throwable cause) {
                TCPProtocolDecoderInitial.this.failed(cause);
            }

            public int getMaximumPlainHeaderLength() {
                throw new RuntimeException();
            }

            public int matchPlainHeader(ByteBuffer buffer) {
                throw new RuntimeException();
            }
        };
        this.phe_decoder = new TCPProtocolDecoderPHE(this.channel, this.shared_secret, buffer, phe_adapter);
    }

    public boolean isComplete(long now) {
        if (!this.processing_complete) {
            long time;
            long timeout;
            if (this.start_time > now) {
                this.start_time = now;
            }
            if (this.last_read_time > now) {
                this.last_read_time = now;
            }
            if (this.phe_decoder != null) {
                this.last_read_time = this.phe_decoder.getLastReadTime();
            }
            if (this.last_read_time == 0L) {
                timeout = 60000L;
                time = this.start_time;
            } else {
                timeout = 10000L;
                time = this.last_read_time;
            }
            if (now - time > timeout) {
                try {
                    read_selector.cancel(this.channel);
                    write_selector.cancel(this.channel);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                String phe_str = "";
                if (this.phe_decoder != null) {
                    phe_str = ", crypto: " + this.phe_decoder.getString();
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Incoming TCP connection [" + this.channel + "] forcibly timed out after " + timeout / 1000L + "sec due to socket inactivity"));
                }
                this.failed(new Throwable("Protocol decode aborted: timed out after " + timeout / 1000L + "sec: " + this.decode_read + " bytes read" + phe_str));
            }
        }
        return this.processing_complete;
    }

    public TCPTransportHelperFilter getFilter() {
        return this.filter;
    }

    protected void complete() {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeComplete(this);
        }
    }

    protected void failed(Throwable reason) {
        if (!this.processing_complete) {
            this.processing_complete = true;
            this.adapter.decodeFailed(this, reason);
        }
    }
}

