/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class TCPProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int TIMEOUT_CHECK = 5000;
    private static final int LOG_TICKS = 12;
    private static List decoders = new ArrayList();
    private static AEMonitor class_mon = new AEMonitor("TCPProtocolDecoder:class");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TCPProtocolDecoder(boolean run_timer) {
        if (run_timer) {
            try {
                class_mon.enter();
                decoders.add(this);
            }
            finally {
                class_mon.exit();
            }
        }
    }

    public abstract boolean isComplete(long var1);

    public abstract TCPTransportHelperFilter getFilter();

    public static void addSecret(byte[] secret) {
        TCPProtocolDecoderPHE.addSecretSupport(secret);
    }

    public static void removeSecret(byte[] secret) {
        TCPProtocolDecoderPHE.removeSecretSupport(secret);
    }

    static {
        new AEThread("TCPProtocolDecoder:timer", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                int loop = 0;
                while (true) {
                    ++loop;
                    long now = SystemTime.getCurrentTime();
                    try {
                        class_mon.enter();
                        if (loop % 12 == 0 && Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Active protocol decoders = " + decoders.size()));
                        }
                        Iterator it = decoders.iterator();
                        while (it.hasNext()) {
                            TCPProtocolDecoder decoder = (TCPProtocolDecoder)it.next();
                            if (!decoder.isComplete(now)) continue;
                            it.remove();
                        }
                    }
                    finally {
                        class_mon.exit();
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Throwable e) {
                    }
                }
            }
        }.start();
    }
}

