/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerDownloader;
import com.aelitis.azureus.core.networkmanager.impl.MultiPeerUploader;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerDownloader;
import com.aelitis.azureus.core.networkmanager.impl.SinglePeerUploader;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class EntityHandler {
    private final HashMap upgraded_connections = new HashMap();
    private final AEMonitor lock = new AEMonitor("EntityHandler");
    private final MultiPeerUploader global_uploader;
    private final MultiPeerDownloader global_downloader;
    private boolean global_registered = false;
    private final int handler_type;

    public EntityHandler(int type, RateHandler rate_handler) {
        this.handler_type = type;
        if (this.handler_type == 0) {
            this.global_uploader = new MultiPeerUploader(rate_handler);
            this.global_downloader = null;
        } else {
            this.global_downloader = new MultiPeerDownloader(rate_handler);
            this.global_uploader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnection connection) {
        try {
            this.lock.enter();
            if (!this.global_registered) {
                if (this.handler_type == 0) {
                    NetworkManager.getSingleton().addWriteEntity(this.global_uploader);
                } else {
                    NetworkManager.getSingleton().addReadEntity(this.global_downloader);
                }
                this.global_registered = true;
            }
        }
        finally {
            this.lock.exit();
        }
        if (this.handler_type == 0) {
            this.global_uploader.addPeerConnection(connection);
        } else {
            this.global_downloader.addPeerConnection(connection);
        }
    }

    public void cancelPeerConnection(NetworkConnection connection) {
        SinglePeerDownloader download_entity;
        if (this.handler_type == 0) {
            SinglePeerUploader upload_entity;
            if (!this.global_uploader.removePeerConnection(connection) && (upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection)) != null) {
                NetworkManager.getSingleton().removeWriteEntity(upload_entity);
            }
        } else if (!this.global_downloader.removePeerConnection(connection) && (download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection)) != null) {
            NetworkManager.getSingleton().removeReadEntity(download_entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(NetworkConnection connection, RateHandler handler) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = new SinglePeerUploader(connection, handler);
                if (!this.global_uploader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: upload entity not found/removed !");
                }
                NetworkManager.getSingleton().addWriteEntity(upload_entity);
                this.upgraded_connections.put(connection, upload_entity);
            } else {
                SinglePeerDownloader download_entity = new SinglePeerDownloader(connection, handler);
                if (!this.global_downloader.removePeerConnection(connection)) {
                    Debug.out("upgradePeerConnection:: download entity not found/removed !");
                }
                NetworkManager.getSingleton().addReadEntity(download_entity);
                this.upgraded_connections.put(connection, download_entity);
            }
        }
        finally {
            this.lock.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnection connection) {
        try {
            this.lock.enter();
            if (this.handler_type == 0) {
                SinglePeerUploader upload_entity = (SinglePeerUploader)this.upgraded_connections.remove(connection);
                if (upload_entity != null) {
                    NetworkManager.getSingleton().removeWriteEntity(upload_entity);
                } else {
                    Debug.out("upload_entity == null");
                }
                this.global_uploader.addPeerConnection(connection);
            } else {
                SinglePeerDownloader download_entity = (SinglePeerDownloader)this.upgraded_connections.remove(connection);
                if (download_entity != null) {
                    NetworkManager.getSingleton().removeReadEntity(download_entity);
                } else {
                    Debug.out("download_entity == null");
                }
                this.global_downloader.addPeerConnection(connection);
            }
        }
        finally {
            this.lock.exit();
        }
    }
}

