/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ConnectDisconnectManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static int MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 3;
    public static int MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 5;
    private static final int CONNECT_ATTEMPT_TIMEOUT = 30000;
    private static final int CONNECT_ATTEMPT_STALL_TIME = 3000;
    private static final boolean SHOW_CONNECT_STATS = false;
    private final VirtualChannelSelector connect_selector = new VirtualChannelSelector(8, true);
    private final LinkedList new_requests = new LinkedList();
    private final ArrayList canceled_requests = new ArrayList();
    private final AEMonitor new_canceled_mon = new AEMonitor("ConnectDisconnectManager:NCM");
    private final HashMap pending_attempts = new HashMap();
    private final LinkedList pending_closes = new LinkedList();
    private final Map delayed_closes = new HashMap();
    private final AEMonitor pending_closes_mon = new AEMonitor("ConnectDisconnectManager:PC");
    private final Random random = new Random();

    public ConnectDisconnectManager() {
        AEThread loop = new AEThread("ConnectDisconnectManager"){

            public void runSupport() {
                ConnectDisconnectManager.this.mainLoop();
            }
        };
        loop.setDaemon(true);
        loop.start();
    }

    private void mainLoop() {
        while (true) {
            this.addNewOutboundRequests();
            this.runSelect();
            this.doClosings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewOutboundRequests() {
        while (this.pending_attempts.size() < MIN_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            ConnectionRequest cr = null;
            try {
                this.new_canceled_mon.enter();
                if (this.new_requests.isEmpty()) break;
                cr = (ConnectionRequest)this.new_requests.removeFirst();
            }
            finally {
                this.new_canceled_mon.exit();
            }
            if (cr == null) continue;
            this.addNewRequest(cr);
        }
    }

    private void addNewRequest(final ConnectionRequest request2) {
        request2.listener.connectAttemptStarted();
        try {
            request2.channel = SocketChannel.open();
            try {
                String bindIP;
                int local_bind_port;
                String ip_tos;
                int snd_size;
                int rcv_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                if (rcv_size > 0) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Setting socket receive buffer size for outgoing connection [" + request2.address + "] to: " + rcv_size));
                    }
                    request2.channel.socket().setReceiveBufferSize(rcv_size);
                }
                if ((snd_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF")) > 0) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Setting socket send buffer size for outgoing connection [" + request2.address + "] to: " + snd_size));
                    }
                    request2.channel.socket().setSendBufferSize(snd_size);
                }
                if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPTOS")).length() > 0) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Setting socket TOS field for outgoing connection [" + request2.address + "] to: " + ip_tos));
                    }
                    request2.channel.socket().setTrafficClass(Integer.decode(ip_tos));
                }
                if ((local_bind_port = COConfigurationManager.getIntParameter("network.bind.local.port")) > 0) {
                    request2.channel.socket().setReuseAddress(true);
                }
                if ((bindIP = COConfigurationManager.getStringParameter("Bind IP", "")).length() > 6) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + request2.address + "] to local IP address: " + bindIP));
                    }
                    request2.channel.socket().bind(new InetSocketAddress(InetAddress.getByName(bindIP), local_bind_port));
                } else if (local_bind_port > 0) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + request2.address + "] to local port #: " + local_bind_port));
                    }
                    request2.channel.socket().bind(new InetSocketAddress(local_bind_port));
                }
            }
            catch (Throwable t) {
                String msg = "Error while processing advanced socket options.";
                Debug.out(msg, t);
                Logger.log(new LogAlert(false, msg, t));
            }
            request2.channel.configureBlocking(false);
            request2.connect_start_time = SystemTime.getCurrentTime();
            if (request2.channel.connect(request2.address)) {
                this.finishConnect(request2);
            } else {
                this.pending_attempts.put(request2, null);
                this.connect_selector.register(request2.channel, new VirtualChannelSelector.VirtualSelectorListener(){

                    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                        ConnectDisconnectManager.this.pending_attempts.remove(request2);
                        ConnectDisconnectManager.this.finishConnect(request2);
                        return true;
                    }

                    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                        ConnectDisconnectManager.this.pending_attempts.remove(request2);
                        ConnectDisconnectManager.this.closeConnection(request2.channel);
                        request2.listener.connectFailure(msg);
                    }
                }, null);
            }
        }
        catch (Throwable t) {
            String full = request2.address.toString();
            String hostname = request2.address.getHostName();
            int port = request2.address.getPort();
            boolean unresolved = request2.address.isUnresolved();
            InetAddress inet_address = request2.address.getAddress();
            String full_sub = inet_address == null ? request2.address.toString() : inet_address.toString();
            String host_address = inet_address == null ? request2.address.toString() : inet_address.getHostAddress();
            String msg = "ConnectDisconnectManager::address exception: full=" + full + ", hostname=" + hostname + ", port=" + port + ", unresolved=" + unresolved + ", full_sub=" + full_sub + ", host_address=" + host_address;
            if (request2.channel != null) {
                String channel = request2.channel.toString();
                String socket = request2.channel.socket().toString();
                String local_address = request2.channel.socket().getLocalAddress().toString();
                int local_port = request2.channel.socket().getLocalPort();
                SocketAddress ra = request2.channel.socket().getRemoteSocketAddress();
                String remote_address = ra != null ? ra.toString() : "<null>";
                int remote_port = request2.channel.socket().getPort();
                msg = msg + "\n channel=" + channel + ", socket=" + socket + ", local_address=" + local_address + ", local_port=" + local_port + ", remote_address=" + remote_address + ", remote_port=" + remote_port;
            } else {
                msg = msg + "\n channel=<null>";
            }
            Debug.out(msg, t);
            if (request2.channel != null) {
                this.closeConnection(request2.channel);
            }
            request2.listener.connectFailure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(ConnectionRequest request2) {
        block9: {
            try {
                if (request2.channel.finishConnect()) {
                    boolean canceled = false;
                    try {
                        this.new_canceled_mon.enter();
                        canceled = this.canceled_requests.contains(request2.listener);
                    }
                    finally {
                        this.new_canceled_mon.exit();
                    }
                    if (canceled) {
                        this.closeConnection(request2.channel);
                    } else {
                        this.connect_selector.cancel(request2.channel);
                        request2.listener.connectSuccess(request2.channel);
                    }
                    break block9;
                }
                Debug.out("finishConnect() failed");
                request2.listener.connectFailure(new Throwable("finishConnect() failed"));
                this.closeConnection(request2.channel);
            }
            catch (Throwable t) {
                request2.listener.connectFailure(t);
                this.closeConnection(request2.channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSelect() {
        try {
            this.new_canceled_mon.enter();
            Iterator can_it = this.canceled_requests.iterator();
            while (can_it.hasNext()) {
                ConnectListener key = (ConnectListener)can_it.next();
                ConnectionRequest to_remove = null;
                Iterator pen_it = this.pending_attempts.keySet().iterator();
                while (pen_it.hasNext()) {
                    ConnectionRequest request2 = (ConnectionRequest)pen_it.next();
                    if (request2.listener != key) continue;
                    this.connect_selector.cancel(request2.channel);
                    this.closeConnection(request2.channel);
                    to_remove = request2;
                    break;
                }
                if (to_remove == null) continue;
                this.pending_attempts.remove(to_remove);
            }
            this.canceled_requests.clear();
        }
        finally {
            this.new_canceled_mon.exit();
        }
        try {
            this.connect_selector.select(100L);
        }
        catch (Throwable t) {
            Debug.out("connnectSelectLoop() EXCEPTION: ", t);
        }
        int num_stalled_requests = 0;
        Iterator i = this.pending_attempts.keySet().iterator();
        while (i.hasNext()) {
            ConnectionRequest request3 = (ConnectionRequest)i.next();
            long waiting_time = SystemTime.getCurrentTime() - request3.connect_start_time;
            if (waiting_time > 30000L) {
                i.remove();
                this.connect_selector.cancel(request3.channel);
                this.closeConnection(request3.channel);
                request3.listener.connectFailure(new Throwable("Connection attempt aborted: timed out after 30sec"));
                continue;
            }
            if (waiting_time >= 3000L) {
                ++num_stalled_requests;
                continue;
            }
            if (waiting_time >= 0L) continue;
            request3.connect_start_time = SystemTime.getCurrentTime();
        }
        if (num_stalled_requests == this.pending_attempts.size() && this.pending_attempts.size() < MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            ConnectionRequest cr = null;
            try {
                this.new_canceled_mon.enter();
                if (!this.new_requests.isEmpty()) {
                    cr = (ConnectionRequest)this.new_requests.removeFirst();
                }
            }
            finally {
                this.new_canceled_mon.exit();
            }
            if (cr != null) {
                this.addNewRequest(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClosings() {
        try {
            this.pending_closes_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (this.delayed_closes.size() > 0) {
                Iterator it = this.delayed_closes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry2 = it.next();
                    long wait = (Long)entry2.getValue() - now;
                    if (wait >= 0L && wait <= 60000L) continue;
                    this.pending_closes.addLast(entry2.getKey());
                    it.remove();
                }
            }
            while (!this.pending_closes.isEmpty()) {
                SocketChannel channel = (SocketChannel)this.pending_closes.removeFirst();
                if (channel == null) continue;
                this.connect_selector.cancel(channel);
                try {
                    channel.close();
                }
                catch (Throwable t) {}
            }
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNewConnection(InetSocketAddress address, ConnectListener listener) {
        ConnectionRequest cr = new ConnectionRequest(address, listener);
        try {
            this.new_canceled_mon.enter();
            int insert_pos = this.random.nextInt(this.new_requests.size() + 1);
            this.new_requests.add(insert_pos, cr);
        }
        finally {
            this.new_canceled_mon.exit();
        }
    }

    public void closeConnection(SocketChannel channel) {
        this.closeConnection(channel, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(SocketChannel channel, int delay) {
        try {
            this.pending_closes_mon.enter();
            if (delay == 0) {
                if (!this.delayed_closes.containsKey(channel) && !this.pending_closes.contains(channel)) {
                    this.pending_closes.addLast(channel);
                }
            } else {
                this.delayed_closes.put(channel, new Long(SystemTime.getCurrentTime() + (long)delay));
            }
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(ConnectListener listener_key) {
        try {
            this.new_canceled_mon.enter();
            Iterator i = this.new_requests.iterator();
            while (i.hasNext()) {
                ConnectionRequest request2 = (ConnectionRequest)i.next();
                if (request2.listener != listener_key) continue;
                i.remove();
                return;
            }
            this.canceled_requests.add(listener_key);
        }
        finally {
            this.new_canceled_mon.exit();
        }
    }

    static {
        MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
        if (MAX_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
            MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
            COConfigurationManager.setParameter("network.max.simultaneous.connect.attempts", 1);
        }
        if ((MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2) < 1) {
            MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
        }
        COConfigurationManager.addParameterListener("network.max.simultaneous.connect.attempts", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
                MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2;
                if (MIN_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
                    MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
                }
            }
        });
    }

    public static interface ConnectListener {
        public void connectAttemptStarted();

        public void connectSuccess(SocketChannel var1);

        public void connectFailure(Throwable var1);
    }

    private static class ConnectionRequest {
        private final InetSocketAddress address;
        private final ConnectListener listener;
        private final long request_start_time;
        private long connect_start_time;
        private SocketChannel channel;

        private ConnectionRequest(InetSocketAddress _address, ConnectListener _listener) {
            this.address = _address;
            this.listener = _listener;
            this.request_start_time = SystemTime.getCurrentTime();
        }
    }
}

