/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceImpl;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceManagerImpl;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginListener;
import java.net.InetAddress;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;

public class AZMyInstanceImpl
extends AZInstanceImpl {
    public static final long FORCE_READ_EXT_MIN = 28800000L;
    private AzureusCore core;
    private AZInstanceManagerImpl manager;
    private String id;
    private InetAddress internal_address;
    private int tcp_port;
    private long last_force_read_ext;
    private InetAddress last_external_address;
    private boolean dht_listener_added;

    protected AZMyInstanceImpl(AzureusCore _core, AZInstanceManagerImpl _manager) {
        this.core = _core;
        this.manager = _manager;
        this.id = COConfigurationManager.getStringParameter("ID", "");
        if (this.id.length() == 0) {
            this.id = "" + SystemTime.getCurrentTime();
        }
        this.id = ByteFormatter.encodeString(new SHA1Simple().calculateHash(this.id.getBytes()));
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                AZMyInstanceImpl.this.readConfig(false);
            }
        });
        this.readConfig(true);
    }

    protected void readConfig(boolean first_time) {
        InetAddress new_internal_address = null;
        String internal_address_str = COConfigurationManager.getStringParameter("Bind IP");
        if (internal_address_str.length() >= 7) {
            try {
                new_internal_address = InetAddress.getByName(internal_address_str);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (new_internal_address == null) {
            try {
                new_internal_address = InetAddress.getByName("0.0.0.0");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        int new_tcp_port = COConfigurationManager.getIntParameter("TCP.Listen.Port");
        boolean same = true;
        if (!first_time) {
            same = this.internal_address.equals(new_internal_address) && this.tcp_port == new_tcp_port;
        }
        this.internal_address = new_internal_address;
        this.tcp_port = new_tcp_port;
        if (!same) {
            this.manager.informChanged(this);
        }
    }

    protected InetAddress readExternalAddress() {
        String str_address;
        PluginInterface dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        DHTPlugin dht = null;
        if (dht_pi != null && (dht = (DHTPlugin)dht_pi.getPlugin()) != null && !this.dht_listener_added) {
            this.dht_listener_added = true;
            dht.addListener(new DHTPluginListener(){

                public void localAddressChanged(DHTPluginContact local_contact) {
                    AZMyInstanceImpl.this.manager.informChanged(AZMyInstanceImpl.this);
                }
            });
        }
        InetAddress external_address = null;
        if ((dht == null || dht.getStatus() != 3) && (str_address = VersionCheckClient.getSingleton().getExternalIpAddress(true)) != null) {
            try {
                external_address = InetAddress.getByName(str_address);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (external_address == null && dht != null) {
            try {
                external_address = dht.getLocalAddress().getAddress().getAddress();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (external_address == null) {
            long now = SystemTime.getCurrentTime();
            if (this.last_force_read_ext > now) {
                this.last_force_read_ext = now;
            }
            if (now - this.last_force_read_ext > 28800000L) {
                this.last_force_read_ext = now;
                external_address = this.core.getPluginManager().getDefaultPluginInterface().getUtilities().getPublicAddress();
            }
        }
        if (external_address == null) {
            if (this.last_external_address != null) {
                external_address = this.last_external_address;
            } else {
                try {
                    external_address = InetAddress.getByName("127.0.0.1");
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            this.last_external_address = external_address;
        }
        return external_address;
    }

    public String getID() {
        return this.id;
    }

    public InetAddress getInternalAddress() {
        return this.internal_address;
    }

    public InetAddress getExternalAddress() {
        return this.readExternalAddress();
    }

    public int getTrackerClientPort() {
        return this.tcp_port;
    }

    public int getDHTPort() {
        PluginInterface dht_pi = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (dht_pi != null) {
            DHTPlugin dht = (DHTPlugin)dht_pi.getPlugin();
            return dht.getPort();
        }
        return 0;
    }
}

