/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class DiskAccessControllerInstance {
    private String name;
    private int max_mb_queued;
    private groupSemaphore max_mb_sem;
    private long request_bytes_queued;
    private long requests_queued;
    private requestDispatcher[] dispatchers;
    private long last_check = 0L;
    private Map request_map = new HashMap();
    private static final int REQUEST_NUM_LOG_CHUNK = 100;
    private static final int REQUEST_BYTE_LOG_CHUNK = 0x100000;
    private int next_request_num_log = 100;
    private long next_request_byte_log = 0x100000L;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return null;
        }
    };

    public DiskAccessControllerInstance(String _name, int _max_threads, int _max_mb) {
        this.name = _name;
        this.max_mb_queued = _max_mb;
        this.max_mb_sem = new groupSemaphore(this.max_mb_queued);
        this.dispatchers = new requestDispatcher[_max_threads];
        for (int i = 0; i < _max_threads; ++i) {
            this.dispatchers[i] = new requestDispatcher(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueRequest(DiskAccessRequestImpl request2) {
        requestDispatcher dispatcher;
        TOTorrent torrent = request2.getFile().getTorrentFile().getTorrent();
        Map map = this.request_map;
        synchronized (map) {
            int min_index = 0;
            int min_size = Integer.MAX_VALUE;
            long now = System.currentTimeMillis();
            boolean check = false;
            if (now - this.last_check > 60000L || now < this.last_check) {
                check = true;
                this.last_check = now;
            }
            if (check) {
                Iterator it = this.request_map.values().iterator();
                while (it.hasNext()) {
                    requestDispatcher d = (requestDispatcher)it.next();
                    long last_active = d.getLastRequestTime();
                    if (now - last_active > 60000L) {
                        it.remove();
                        continue;
                    }
                    if (now >= last_active) continue;
                    d.setLastRequestTime(now);
                }
            }
            if ((dispatcher = (requestDispatcher)this.request_map.get(torrent)) == null) {
                for (int i = 0; i < this.dispatchers.length; ++i) {
                    int size = this.dispatchers[i].size();
                    if (size == 0) {
                        min_index = i;
                        break;
                    }
                    if (size >= min_size) continue;
                    min_size = size;
                    min_index = i;
                }
                dispatcher = this.dispatchers[min_index];
                this.request_map.put(torrent, dispatcher);
            }
            dispatcher.setLastRequestTime(now);
        }
        dispatcher.queue(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.request_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued += (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = new_mb - old_mb;
            if (mb_diff > this.max_mb_queued) {
                this.max_mb_sem.releaseGroup(mb_diff - this.max_mb_queued);
                this.max_mb_queued = mb_diff;
            }
            ++this.requests_queued;
            if (this.requests_queued >= (long)this.next_request_num_log) {
                this.next_request_num_log += 100;
            }
            if (this.request_bytes_queued >= this.next_request_byte_log) {
                this.next_request_byte_log += 0x100000L;
            }
        }
        if (mb_diff > 0) {
            this.max_mb_sem.reserveGroup(mb_diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSpaceAllowance(DiskAccessRequestImpl request2) {
        int mb_diff;
        Map map = this.request_map;
        synchronized (map) {
            int old_mb = (int)(this.request_bytes_queued / 0x100000L);
            this.request_bytes_queued -= (long)request2.getSize();
            int new_mb = (int)(this.request_bytes_queued / 0x100000L);
            mb_diff = old_mb - new_mb;
            --this.requests_queued;
        }
        if (mb_diff > 0) {
            this.max_mb_sem.releaseGroup(mb_diff);
        }
    }

    public static void main(String[] args) {
        final groupSemaphore sem = new groupSemaphore(9);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                public void run() {
                    int count = 0;
                    while (true) {
                        int group = RandomUtils.generateRandomIntUpto(10);
                        System.out.println(Thread.currentThread().getName() + " reserving " + group);
                        sem.reserveGroup(group);
                        try {
                            Thread.sleep(5 + RandomUtils.generateRandomIntUpto(5));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        sem.releaseGroup(group);
                        if (++count % 100 != 0) continue;
                        System.out.println(Thread.currentThread().getName() + ": " + count + " ops");
                    }
                }
            }.start();
        }
    }

    protected static class groupSemaphore {
        private int value;
        private List waiters = new LinkedList();

        protected groupSemaphore(int _value) {
            this.value = _value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reserveGroup(int num) {
            mutableInteger wait;
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (num <= this.value && this.waiters.size() == 0) {
                    this.value -= num;
                    return;
                }
                wait = new mutableInteger(num - this.value);
                this.value = 0;
                this.waiters.add(wait);
            }
            wait.reserve();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseGroup(int num) {
            groupSemaphore groupSemaphore2 = this;
            synchronized (groupSemaphore2) {
                if (this.waiters.size() == 0) {
                    this.value += num;
                } else {
                    while (this.waiters.size() > 0) {
                        mutableInteger wait = (mutableInteger)this.waiters.get(0);
                        int wait_num = wait.getValue();
                        if (wait_num <= num) {
                            wait.release();
                            this.waiters.remove(0);
                            num -= wait_num;
                            continue;
                        }
                        wait.setValue(wait_num - num);
                        num = 0;
                        break;
                    }
                    this.value = num;
                }
            }
        }

        protected static class mutableInteger {
            private int i;
            private boolean released;

            protected mutableInteger(int _i) {
                this.i = _i;
            }

            protected int getValue() {
                return this.i;
            }

            protected void setValue(int _i) {
                this.i = _i;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void release() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    this.released = true;
                    this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void reserve() {
                mutableInteger mutableInteger2 = this;
                synchronized (mutableInteger2) {
                    if (this.released) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Semaphore: operation interrupted");
                    }
                }
            }
        }
    }

    protected class requestDispatcher {
        private int index;
        private AEThread thread;
        private LinkedList requests = new LinkedList();
        private AESemaphore request_sem = new AESemaphore("DiskAccessControllerInstance:requestDispatcher");
        private long last_request_time;

        protected requestDispatcher(int _index) {
            this.index = _index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void queue(DiskAccessRequestImpl request2) {
            if (tls.get() != null) {
                try {
                    request2.runSupport();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            } else {
                DiskAccessControllerInstance.this.getSpaceAllowance(request2);
                LinkedList linkedList = this.requests;
                synchronized (linkedList) {
                    this.requests.add(request2);
                    this.request_sem.release();
                    if (this.thread == null) {
                        this.thread = new AEThread(this, "DiskAccessController:requestDispatcher[" + this.index + "]", true){
                            private final /* synthetic */ requestDispatcher this$1;
                            {
                                this.this$1 = this$1;
                                super(x0, x1);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void runSupport() {
                                DiskAccessControllerInstance.access$000().set(this);
                                while (true) {
                                    if (requestDispatcher.access$100(this.this$1).reserve(30000L)) {
                                        DiskAccessRequestImpl request2;
                                        LinkedList linkedList = requestDispatcher.access$200(this.this$1);
                                        synchronized (linkedList) {
                                            request2 = (DiskAccessRequestImpl)requestDispatcher.access$200(this.this$1).remove(0);
                                        }
                                        try {
                                            request2.runSupport();
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                        finally {
                                            requestDispatcher.access$300(this.this$1).releaseSpaceAllowance(request2);
                                        }
                                        continue;
                                    }
                                    LinkedList linkedList = requestDispatcher.access$200(this.this$1);
                                    synchronized (linkedList) {
                                        if (requestDispatcher.access$200(this.this$1).size() == 0) {
                                            requestDispatcher.access$402(this.this$1, null);
                                            break;
                                        }
                                    }
                                }
                            }
                        };
                        this.thread.start();
                    }
                }
            }
        }

        protected long getLastRequestTime() {
            return this.last_request_time;
        }

        protected void setLastRequestTime(long l) {
            this.last_request_time = l;
        }

        protected int size() {
            return this.requests.size();
        }

        static /* synthetic */ AESemaphore access$100(requestDispatcher x0) {
            return x0.request_sem;
        }

        static /* synthetic */ LinkedList access$200(requestDispatcher x0) {
            return x0.requests;
        }

        static /* synthetic */ DiskAccessControllerInstance access$300(requestDispatcher x0) {
            return x0.DiskAccessControllerInstance.this;
        }

        static /* synthetic */ AEThread access$402(requestDispatcher x0, AEThread x1) {
            x0.thread = x1;
            return x0.thread;
        }
    }
}

