/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.networkmanager.TransportFactory;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;

public class ClientConnection {
    private TCPTransport parent_transport;
    private final TCPTransport light_transport;
    private final OutgoingMessageQueue out_queue;
    private final AZMessageDecoder decoder;
    private static final AZMessageEncoder encoder = new AZMessageEncoder();
    private long last_activity_time;
    private final AEMonitor msg_mon = new AEMonitor("ClientConnection");
    private final ArrayList sending_msgs = new ArrayList();
    private Map user_data;
    private boolean close_pending;
    private boolean closed;
    private String debug_string = "<>";

    public ClientConnection(SocketChannel channel) {
        this.decoder = new AZMessageDecoder();
        this.light_transport = TransportFactory.createLightweightTCPTransport(channel);
        this.out_queue = new OutgoingMessageQueue(encoder, this.light_transport);
        this.last_activity_time = System.currentTimeMillis();
    }

    public ClientConnection(TCPTransport transport) {
        this(transport.getSocketChannel());
        this.parent_transport = transport;
    }

    public Message[] readMessages() throws IOException {
        int bytes_read = this.decoder.performStreamDecode(this.light_transport, 0x100000);
        if (bytes_read > 0) {
            this.last_activity_time = System.currentTimeMillis();
        }
        return this.decoder.removeDecodedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(final ClientMessage client_msg, final Message msg) {
        try {
            this.msg_mon.enter();
            this.sending_msgs.add(client_msg);
        }
        finally {
            this.msg_mon.exit();
        }
        this.out_queue.registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageSent(Message message) {
                if (message.equals(msg)) {
                    try {
                        ClientConnection.this.msg_mon.enter();
                        ClientConnection.this.sending_msgs.remove(client_msg);
                    }
                    finally {
                        ClientConnection.this.msg_mon.exit();
                    }
                    client_msg.getHandler().sendAttemptCompleted(client_msg, true);
                }
            }
        });
        this.out_queue.addMessage(msg, false);
    }

    public boolean writeMessages() throws IOException {
        int bytes_written = this.out_queue.deliverToTransport(0x100000, false);
        if (bytes_written > 0) {
            this.last_activity_time = System.currentTimeMillis();
        }
        return this.out_queue.getTotalSize() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ClientMessage[] messages = null;
        try {
            this.msg_mon.enter();
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.sending_msgs.isEmpty()) {
                messages = this.sending_msgs.toArray(new ClientMessage[this.sending_msgs.size()]);
            }
        }
        finally {
            this.msg_mon.exit();
        }
        if (messages != null) {
            for (int i = 0; i < messages.length; ++i) {
                ClientMessage msg = messages[i];
                msg.getHandler().sendAttemptCompleted(msg, false);
            }
        }
        this.decoder.destroy();
        this.out_queue.destroy();
        if (this.parent_transport != null) {
            this.parent_transport.close();
        } else {
            this.light_transport.close();
        }
    }

    public void closePending() {
        this.last_activity_time = System.currentTimeMillis();
        this.close_pending = true;
    }

    public boolean isClosePending() {
        return this.close_pending;
    }

    public SocketChannel getSocketChannel() {
        return this.light_transport.getSocketChannel();
    }

    public long getLastActivityTime() {
        return this.last_activity_time;
    }

    public void resetLastActivityTime() {
        this.last_activity_time = System.currentTimeMillis();
    }

    public Object getUserData(Object key) {
        Map m = this.user_data;
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object data) {
        try {
            this.msg_mon.enter();
            HashMap<Object, Object> m = this.user_data == null ? new HashMap<Object, Object>() : new HashMap(this.user_data);
            m.put(key, data);
            this.user_data = m;
        }
        finally {
            this.msg_mon.exit();
        }
    }

    public void setDebugString(String debug) {
        this.debug_string = debug;
    }

    public String getDebugString() {
        return this.debug_string;
    }
}

