/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class RecentUpDownRatioItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public RecentUpDownRatioItem() {
        super("RecentUpDownRatio", 2, -2, 65, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeerTransportProtocol peer = (PEPeerTransportProtocol)cell.getDataSource();
        float value = 0.0f;
        long lDivisor = 0L;
        long lDivident = 0L;
        if (peer != null) {
            lDivisor = peer.getTyrantStats().getDataBytesReceivedInTheLast(45L);
            lDivident = peer.getTyrantStats().getDataBytesSentInTheLast(45L);
            if (lDivisor > 128L) {
                value = (float)lDivident / (float)lDivisor;
                if (value == 0.0f) {
                    value = -1.0f;
                }
            } else if (lDivident > 0L) {
                value = 3.1536E7f;
            }
        }
        if (!cell.setSortValue((long)(value * 1000.0f)) && cell.isValid()) {
            return;
        }
        String s = lDivisor <= 0L ? "" : (value == 3.1536E7f ? "\u221e:1" : (value == -1.0f ? "1:\u221e" : DisplayFormatters.formatDecimal(value, 2) + ":1"));
        cell.setText(s);
    }
}

