/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;

public abstract class OptionsConsoleCommand
extends IConsoleCommand {
    private Options options = new Options();
    private CommandLineParser parser = null;

    public OptionsConsoleCommand(String[] commandNames) {
        super(commandNames);
    }

    public void execute(String commandName, ConsoleInput console, List arguments) {
        CommandLineParser parser = this.getParser();
        try {
            String[] args = new String[arguments.size()];
            int i = 0;
            for (String arg : arguments) {
                args[i++] = arg;
            }
            CommandLine line = parser.parse(this.getOptions(), args);
            this.execute(commandName, console, line);
        }
        catch (ParseException e) {
            console.out.println(">> Invalid arguments: " + e.getMessage());
            this.printHelp(console.out, arguments);
        }
    }

    public void printHelp(PrintStream out, List args) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("> -----");
        writer.println(this.getCommandDescriptions());
        formatter.printOptions(writer, 80, this.getOptions(), 4, 4);
        writer.println("> -----");
        writer.flush();
    }

    public abstract void execute(String var1, ConsoleInput var2, CommandLine var3);

    protected CommandLineParser getParser() {
        if (this.parser == null) {
            this.parser = new PosixParser();
        }
        return this.parser;
    }

    protected Options getOptions() {
        return this.options;
    }
}

