/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class MakeTorrent
implements TOTorrentProgressListener {
    private boolean verbose;
    private static final String[] validKeys = new String[]{"comment", "announce-list", "target", "force_piece_size_pow2", "verbose"};

    public void reportCurrentTask(String task_description) {
        if (this.verbose) {
            System.out.println(task_description);
        }
    }

    public void reportProgress(int percent_complete) {
        if (this.verbose) {
            System.out.print("\r" + percent_complete + "%    ");
        }
    }

    public MakeTorrent(String file, URL url, Map parameters) {
        String announceList;
        File fSrc = new File(file);
        String torrentName = (String)parameters.get("target");
        if (torrentName == null) {
            torrentName = file + ".torrent";
        }
        File fDst = new File(torrentName);
        if (parameters.get("verbose") != null) {
            this.verbose = true;
        }
        TOTorrent torrent = null;
        String pieceSizeStr = (String)parameters.get("force_piece_size_pow2");
        if (pieceSizeStr != null) {
            try {
                long pieceSize = 1L << Integer.parseInt(pieceSizeStr);
                TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(fSrc, url, pieceSize);
                creator.addListener(this);
                torrent = creator.create();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            TOTorrentCreator creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(fSrc, url);
            creator.addListener(this);
            torrent = creator.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String comment = (String)parameters.get("comment");
        if (comment != null) {
            torrent.setComment(comment);
        }
        if ((announceList = (String)parameters.get("announce-list")) != null) {
            StringTokenizer st = new StringTokenizer(announceList, "|");
            ArrayList list = new ArrayList();
            ArrayList<String> urls = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String _url = st.nextToken();
                urls.add(_url);
            }
            list.add(urls);
            TorrentUtils.listToAnnounceGroups(list, torrent);
        }
        try {
            torrent.serialiseToBEncodedFile(fDst);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            MakeTorrent.usage();
            System.exit(0);
        }
        HashMap parameters = new HashMap();
        for (int i = 2; i < args.length; ++i) {
            boolean ok = MakeTorrent.parseParameter(args[i], parameters);
            if (ok) continue;
            System.exit(-1);
        }
        File f = new File(args[1]);
        if (!f.exists()) {
            System.out.println(args[1] + " is not a valid file / directory");
            System.exit(-1);
        }
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (Exception e) {
            System.out.println(args[0] + " is not a valid url");
            System.exit(-1);
        }
        new MakeTorrent(args[1], url, parameters);
    }

    public static void usage() {
        System.out.println("Usage :");
        System.out.println("MakeTorrent <trackerurl> <file|dir> [options]");
        System.out.println("Options :");
        System.out.println("--comment=<comment>            Adds a comment to the torrent");
        System.out.println("--force_piece_size_pow2=<pow2> Specifies the piece size to use");
        System.out.println("--target=<target file>         Specifies a target torrent file");
        System.out.println("--verbose                      Verbose");
        System.out.println("--announce-list=url1[|url2|...] Use a list of trackers");
    }

    public static boolean parseParameter(String parameter, Map parameters) {
        if (parameter == null) {
            return false;
        }
        if (parameter.equalsIgnoreCase("--v") || parameter.equalsIgnoreCase("--verbose")) {
            parameters.put("verbose", new Integer(1));
        }
        if (parameter.startsWith("--")) {
            try {
                StringTokenizer st = new StringTokenizer(parameter.substring(2), "=");
                String key = st.nextToken();
                String value = "";
                String sep = "";
                while (st.hasMoreTokens()) {
                    value = value + sep + st.nextElement();
                    sep = "=";
                }
                boolean valid = false;
                for (int i = 0; i < validKeys.length; ++i) {
                    if (!validKeys[i].equalsIgnoreCase(key)) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    System.out.println("Invalid parameter : " + key);
                    return false;
                }
                parameters.put(key, value);
                return true;
            }
            catch (Exception e) {
                System.out.println("Cannot parse " + parameter);
                return false;
            }
        }
        System.out.println("Cannot parse " + parameter);
        return false;
    }
}

