/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.peers.Piece;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class PeerManagerImpl
implements PeerManager {
    protected PEPeerManager manager;
    protected static AEMonitor pm_map_mon = new AEMonitor("PeerManager:Map");
    private Map foreign_map = new HashMap();
    private Map listener_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("PeerManager");
    private final DiskManagerPiece[] dm_pieces;
    private final PEPiece[] pe_pieces;
    private pieceFacade[] piece_facades;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerManagerImpl getPeerManager(PEPeerManager _manager) {
        try {
            pm_map_mon.enter();
            PeerManagerImpl res = (PeerManagerImpl)_manager.getData("PluginPeerManager");
            if (res == null) {
                res = new PeerManagerImpl(_manager);
                _manager.setData("PluginPeerManager", res);
            }
            PeerManagerImpl peerManagerImpl = res;
            return peerManagerImpl;
        }
        finally {
            pm_map_mon.exit();
        }
    }

    protected PeerManagerImpl(PEPeerManager _manager) {
        this.manager = _manager;
        this.dm_pieces = _manager.getDiskManager().getPieces();
        this.pe_pieces = _manager.getPieces();
    }

    public PEPeerManager getDelegate() {
        return this.manager;
    }

    public DiskManager getDiskManager() {
        return new DiskManagerImpl(this);
    }

    public PeerManagerStats getStats() {
        return new PeerManagerStatsImpl(this.manager);
    }

    public boolean isSeeding() {
        return this.manager.getDiskManager().getRemainingExcludingDND() == 0L;
    }

    public boolean isSuperSeeding() {
        return this.manager.isSuperSeedMode();
    }

    public Download getDownload() throws DownloadException {
        return DownloadManagerImpl.getDownloadStatic(this.manager.getDiskManager().getTorrent());
    }

    public Piece[] getPieces() {
        if (this.piece_facades == null) {
            pieceFacade[] pf = new pieceFacade[this.manager.getDiskManager().getNbPieces()];
            for (int i = 0; i < pf.length; ++i) {
                pf[i] = new pieceFacade(i);
            }
            this.piece_facades = pf;
        }
        return this.piece_facades;
    }

    public PeerStats createPeerStats(Peer peer) {
        return new PeerStatsImpl(this, peer, this.manager.createPeerStats());
    }

    public void requestComplete(PeerReadRequest request2, PooledByteBuffer data, Peer sender) {
        this.manager.writeBlock(request2.getPieceNumber(), request2.getOffset(), ((PooledByteBufferImpl)data).getBuffer(), this.mapForeignPeer(sender), false);
        PeerForeignDelegate delegate = this.lookupForeignPeer(sender);
        if (delegate != null) {
            delegate.dataReceived();
        }
    }

    public void requestCancelled(PeerReadRequest request2, Peer sender) {
        this.manager.requestCanceled((DiskManagerReadRequest)request2);
    }

    public void addPeer(Peer peer) {
        this.manager.addPeer(this.mapForeignPeer(peer));
    }

    public void removePeer(Peer peer) {
        this.manager.removePeer(this.mapForeignPeer(peer));
    }

    public void addPeer(String ip_address, int tcp_port) {
        this.manager.addPeer(ip_address, tcp_port, 0, false);
    }

    public void addPeer(String ip_address, int tcp_port, boolean use_crypto) {
        this.manager.addPeer(ip_address, tcp_port, 0, use_crypto);
    }

    public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
        this.manager.addPeer(ip_address, tcp_port, udp_port, use_crypto);
    }

    public Peer[] getPeers() {
        List l = this.manager.getPeers();
        Peer[] res = new Peer[l.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new PeerImpl((PEPeer)l.get(i));
        }
        return res;
    }

    public long getTimeSinceConnectionEstablished(Peer peer) {
        if (peer instanceof PeerImpl) {
            return ((PeerImpl)peer).getDelegate().getTimeSinceConnectionEstablished();
        }
        PeerForeignDelegate delegate = this.lookupForeignPeer(peer);
        if (delegate != null) {
            return delegate.getTimeSinceConnectionEstablished();
        }
        return 0L;
    }

    public PEPeer mapForeignPeer(Peer _foreign) {
        if (_foreign instanceof PeerImpl) {
            return ((PeerImpl)_foreign).getDelegate();
        }
        PEPeer local = (PEPeer)this.foreign_map.get(_foreign);
        if (local == null) {
            local = new PeerForeignDelegate(this, _foreign);
            _foreign.setUserData(PeerManagerImpl.class, local);
            this.foreign_map.put(_foreign, local);
        }
        return local;
    }

    protected PeerForeignDelegate lookupForeignPeer(Peer _foreign) {
        return (PeerForeignDelegate)_foreign.getUserData(PeerManagerImpl.class);
    }

    public List mapForeignPeers(Peer[] _foreigns) {
        ArrayList<PEPeer> res = new ArrayList<PEPeer>();
        for (int i = 0; i < _foreigns.length; ++i) {
            PEPeer local = this.mapForeignPeer(_foreigns[i]);
            if (res.contains(local)) continue;
            res.add(local);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final PeerManagerListener l) {
        try {
            this.this_mon.enter();
            final HashMap peer_map = new HashMap();
            PEPeerManagerListener core_listener = new PEPeerManagerListener(){

                public void peerAdded(PEPeerManager manager, PEPeer peer) {
                    PeerImpl pi = new PeerImpl(peer);
                    peer_map.put(peer, pi);
                    l.peerAdded(PeerManagerImpl.this, pi);
                }

                public void peerRemoved(PEPeerManager manager, PEPeer peer) {
                    PeerImpl pi = (PeerImpl)peer_map.remove(peer);
                    if (pi != null) {
                        l.peerRemoved(PeerManagerImpl.this, pi);
                    }
                }
            };
            this.listener_map.put(l, core_listener);
            this.manager.addListener(core_listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerManagerListener l) {
        try {
            this.this_mon.enter();
            PEPeerManagerListener core_listener = (PEPeerManagerListener)this.listener_map.remove(l);
            if (core_listener != null) {
                this.manager.removeListener(core_listener);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected class pieceFacade
    implements Piece {
        private final int index;

        protected pieceFacade(int _index) {
            this.index = _index;
        }

        public boolean isDone() {
            return PeerManagerImpl.this.dm_pieces[this.index].isDone();
        }

        public boolean isNeeded() {
            return PeerManagerImpl.this.dm_pieces[this.index].isNeeded();
        }

        public boolean isDownloading() {
            return PeerManagerImpl.this.pe_pieces[this.index] != null;
        }

        public boolean isFullyAllocatable() {
            if (PeerManagerImpl.this.pe_pieces[this.index] != null) {
                return false;
            }
            return PeerManagerImpl.this.dm_pieces[this.index].isInteresting();
        }

        public int getAllocatableRequestCount() {
            PEPiece pe_piece = PeerManagerImpl.this.pe_pieces[this.index];
            if (pe_piece != null) {
                return pe_piece.getNbUnrequested();
            }
            if (PeerManagerImpl.this.dm_pieces[this.index].isInteresting()) {
                return PeerManagerImpl.this.dm_pieces[this.index].getNbBlocks();
            }
            return 0;
        }
    }
}

