/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;

public abstract class TRTrackerServerTCP
extends TRTrackerServerImpl {
    private static int THREAD_POOL_SIZE = COConfigurationManager.getIntParameter("Tracker Max Threads");
    public static long PROCESSING_GET_LIMIT = COConfigurationManager.getIntParameter("Tracker Max GET Time") * 1000;
    public static int PROCESSING_POST_MULTIPLIER = COConfigurationManager.getIntParameter("Tracker Max POST Time Multiplier");
    private boolean ssl;
    private int port;
    private boolean apply_ip_filter;
    private ThreadPool thread_pool;
    private AEMonitor this_mon = new AEMonitor("TRTrackerServerTCP");
    static boolean LOG_DOS_TO_FILE;
    protected static File dos_log_file;
    protected static AEMonitor class_mon;
    Map DOS_map = new LinkedHashMap(1000, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return TRTrackerServerTCP.this.checkDOSRemove(eldest);
        }
    };
    List dos_list = new ArrayList(128);
    long last_dos_check = 0L;
    long MAX_DOS_ENTRIES = 10000L;
    long MAX_DOS_RETENTION = 10000L;
    int DOS_CHECK_DEAD_WOOD_COUNT = 512;
    int DOS_MIN_INTERVAL = 1000;
    int dos_check_count = 0;

    public TRTrackerServerTCP(String _name, int _port, boolean _ssl, boolean _apply_ip_filter) throws TRTrackerServerException {
        super(_name);
        this.port = _port;
        this.ssl = _ssl;
        this.apply_ip_filter = _apply_ip_filter;
        this.thread_pool = new ThreadPool("TrackerServer:TCP:" + this.port, THREAD_POOL_SIZE);
        if (PROCESSING_GET_LIMIT > 0L) {
            this.thread_pool.setExecutionLimit(PROCESSING_GET_LIMIT);
        }
    }

    public void runProcessor(TRTrackerServerProcessorTCP processor) {
        this.thread_pool.run(processor);
    }

    protected boolean isIPFilterEnabled() {
        return this.apply_ip_filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkDOS(String ip) throws UnknownHostException {
        boolean res;
        InetAddress inet_address = InetAddress.getByName(ip);
        if (inet_address.isLoopbackAddress() || InetAddress.getLocalHost().equals(inet_address)) {
            return false;
        }
        this.last_dos_check = SystemTime.getCurrentTime();
        DOSEntry entry = (DOSEntry)this.DOS_map.get(ip);
        if (entry == null) {
            entry = new DOSEntry(ip);
            this.DOS_map.put(ip, entry);
            res = false;
        } else {
            boolean bl = res = this.last_dos_check - entry.last_time < (long)this.DOS_MIN_INTERVAL;
            if (res && LOG_DOS_TO_FILE) {
                this.dos_list.add(entry);
            }
            entry.last_time = this.last_dos_check;
        }
        ++this.dos_check_count;
        if (this.dos_check_count != this.DOS_CHECK_DEAD_WOOD_COUNT) return res;
        this.dos_check_count = 0;
        Iterator it = this.DOS_map.values().iterator();
        while (it.hasNext()) {
            DOSEntry this_entry = (DOSEntry)it.next();
            if (this.last_dos_check - this_entry.last_time <= this.MAX_DOS_RETENTION) break;
            it.remove();
        }
        if (this.dos_list.size() <= 0) return res;
        try {
            class_mon.enter();
            if (dos_log_file == null) {
                dos_log_file = new File(System.getProperty("user.dir") + File.separator + "dos.log");
            }
            PrintWriter pw = null;
            pw = new PrintWriter(new FileWriter(dos_log_file, true));
            for (int i = 0; i < this.dos_list.size(); ++i) {
                DOSEntry this_entry = (DOSEntry)this.dos_list.get(i);
                String ts = new SimpleDateFormat("hh:mm:ss - ").format(new Date(this_entry.last_time));
                pw.println(ts + this_entry.ip);
            }
            this.dos_list.clear();
            if (pw == null) return res;
            try {
                pw.close();
                return res;
            }
            catch (Throwable e) {}
            return res;
            catch (Throwable e) {
                this.dos_list.clear();
                if (pw == null) return res;
                try {
                    pw.close();
                    return res;
                }
                catch (Throwable e2) {}
                return res;
                catch (Throwable throwable) {
                    this.dos_list.clear();
                    if (pw == null) throw throwable;
                    try {
                        pw.close();
                        throw throwable;
                    }
                    catch (Throwable e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected boolean checkDOSRemove(Map.Entry eldest) {
        boolean res = (long)this.DOS_map.size() > this.MAX_DOS_ENTRIES || this.last_dos_check - ((DOSEntry)eldest.getValue()).last_time > this.MAX_DOS_RETENTION;
        return res;
    }

    public int getPort() {
        return this.port;
    }

    protected void setPort(int _port) {
        this.port = _port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return this.ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleExternalRequest(InetSocketAddress client_address, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os) throws IOException {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TRTrackerServerListener listener;
            try {
                this.this_mon.enter();
                if (i >= this.listeners.size()) break;
                listener = (TRTrackerServerListener)this.listeners.elementAt(i);
            }
            finally {
                this.this_mon.exit();
            }
            if (!listener.handleExternalRequest(client_address, user, url, absolute_url, header, is, os)) continue;
            return true;
        }
        return false;
    }

    static {
        if (THREAD_POOL_SIZE <= 0) {
            THREAD_POOL_SIZE = 1;
        }
        if (PROCESSING_GET_LIMIT < 0L) {
            PROCESSING_GET_LIMIT = 0L;
        }
        if (PROCESSING_POST_MULTIPLIER < 0) {
            PROCESSING_POST_MULTIPLIER = 0;
        }
        LOG_DOS_TO_FILE = false;
        LOG_DOS_TO_FILE = System.getProperty("azureus.log.dos") != null;
        class_mon = new AEMonitor("TRTrackerServerTCP:class");
    }

    protected class DOSEntry {
        String ip;
        long last_time;

        protected DOSEntry(String _ip) {
            this.ip = _ip;
            this.last_time = TRTrackerServerTCP.this.last_dos_check;
        }
    }
}

