/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.category.impl.CategoryImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryManagerImpl {
    private static CategoryManagerImpl catMan;
    private static Category catAll;
    private static Category catUncategorized;
    private static boolean doneLoading;
    private static AEMonitor class_mon;
    private Map categories = new HashMap();
    private AEMonitor categories_mon = new AEMonitor("Categories");
    private static final int LDT_CATEGORY_ADDED = 1;
    private static final int LDT_CATEGORY_REMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryManagerListener target = (CategoryManagerListener)_listener;
            if (type == 1) {
                target.categoryAdded((Category)value);
            } else if (type == 2) {
                target.categoryRemoved((Category)value);
            }
        }
    });

    protected CategoryManagerImpl() {
        this.loadCategories();
    }

    public void addCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.addListener(l);
    }

    public void removeCategoryManagerListener(CategoryManagerListener l) {
        this.category_listeners.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryManagerImpl getInstance() {
        try {
            class_mon.enter();
            if (catMan == null) {
                catMan = new CategoryManagerImpl();
            }
            CategoryManagerImpl categoryManagerImpl = catMan;
            return categoryManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCategories() {
        if (doneLoading) {
            return;
        }
        doneLoading = true;
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        Map map = null;
        ArrayList<String> catNames = new ArrayList<String>();
        try {
            File configFile = FileUtil.getUserFile("categories.config");
            fin = new FileInputStream(configFile);
            bin = new BufferedInputStream(fin, 8192);
            map = BDecoder.decode(bin);
            List catList = (List)map.get("categories");
            for (int i = 0; i < catList.size(); ++i) {
                Map mCategory = (Map)catList.get(i);
                try {
                    String catName = new String((byte[])mCategory.get("name"), "UTF8");
                    catNames.add(catName);
                    continue;
                }
                catch (UnsupportedEncodingException e1) {
                    // empty catch block
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception e) {}
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e) {}
        }
        this.makeSpecialCategories();
        if (map != null && catNames.size() > 0) {
            try {
                this.categories_mon.enter();
                for (int i = 0; i < catNames.size(); ++i) {
                    String name = (String)catNames.get(i);
                    CategoryImpl cat = new CategoryImpl(name);
                    this.categories.put(name, cat);
                }
            }
            finally {
                this.categories_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCategories() {
        try {
            this.categories_mon.enter();
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(this.categories.size());
            for (Category cat : this.categories.values()) {
                if (cat.getType() != 0) continue;
                HashMap<String, String> catMap = new HashMap<String, String>();
                catMap.put("name", cat.getName());
                list.add(catMap);
            }
            map.put("categories", list);
            FileOutputStream fos = null;
            try {
                byte[] torrentData = BEncoder.encode(map);
                File oldFile = FileUtil.getUserFile("categories.config");
                File newFile = FileUtil.getUserFile("categories.config.new");
                fos = new FileOutputStream(newFile);
                fos.getChannel().force(true);
                fos.write(torrentData);
                fos.flush();
                fos.close();
                fos = null;
                if (!oldFile.exists() || oldFile.delete()) {
                    newFile.renameTo(oldFile);
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        finally {
            this.categories_mon.exit();
        }
    }

    public Category createCategory(String name) {
        this.makeSpecialCategories();
        Category newCategory = this.getCategory(name);
        if (newCategory == null) {
            newCategory = new CategoryImpl(name);
            this.categories.put(name, newCategory);
            this.saveCategories();
            this.category_listeners.dispatch(1, newCategory);
            return (Category)this.categories.get(name);
        }
        return newCategory;
    }

    public void removeCategory(Category category) {
        if (this.categories.containsKey(category.getName())) {
            this.categories.remove(category.getName());
            this.saveCategories();
            this.category_listeners.dispatch(2, category);
        }
    }

    public Category[] getCategories() {
        if (this.categories.size() > 0) {
            return this.categories.values().toArray(new Category[this.categories.size()]);
        }
        return new Category[0];
    }

    public Category getCategory(String name) {
        return (Category)this.categories.get(name);
    }

    public Category getCategory(int type) {
        if (type == 1) {
            return catAll;
        }
        if (type == 2) {
            return catUncategorized;
        }
        return null;
    }

    private void makeSpecialCategories() {
        if (catAll == null) {
            catAll = new CategoryImpl("Categories.all", 1);
            this.categories.put("Categories.all", catAll);
        }
        if (catUncategorized == null) {
            catUncategorized = new CategoryImpl("Categories.uncategorized", 2);
            this.categories.put("Categories.uncategorized", catUncategorized);
        }
    }

    static {
        catAll = null;
        catUncategorized = null;
        doneLoading = false;
        class_mon = new AEMonitor("CategoryManager:class");
    }
}

