/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.download.session.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.peermanager.connection.AZPeerConnection;
import com.aelitis.azureus.core.peermanager.download.TorrentDownload;
import com.aelitis.azureus.core.peermanager.download.session.AuthenticatorException;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSession;
import com.aelitis.azureus.core.peermanager.download.session.TorrentSessionListener;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionAck;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionBitfield;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionCancel;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionEnd;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionHave;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionPiece;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionRequest;
import com.aelitis.azureus.core.peermanager.messaging.azureus.session.AZSessionSyn;
import java.util.Arrays;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class AZTorrentSession
implements TorrentSession {
    private static int next_session_id = 0;
    private static final AEMonitor session_mon = new AEMonitor("TorrentSession");
    private int local_session_id;
    private int remote_session_id;
    private final TorrentDownload download;
    private final AZPeerConnection peer;
    private final TorrentSessionListener listener;
    private TimerEvent syn_timeout_timer;
    private final IncomingMessageQueue.MessageQueueListener incoming_q_listener = new IncomingMessageQueue.MessageQueueListener(){

        public boolean messageReceived(Message message) {
            AZSessionPiece piece;
            AZSessionHave have;
            AZSessionCancel cancel;
            AZSessionRequest req;
            AZSessionBitfield bitf;
            AZSessionEnd end;
            AZSessionAck ack;
            if (message.getID().equals("AZ_SESSION_ACK") && Arrays.equals((ack = (AZSessionAck)message).getInfoHash(), AZTorrentSession.this.download.getInfoHash())) {
                AZTorrentSession.this.remote_session_id = ack.getSessionID();
                AZTorrentSession.this.syn_timeout_timer.cancel();
                try {
                    AZTorrentSession.this.download.getSessionAuthenticator().verifySessionAck(AZTorrentSession.this.peer, ack.getSessionInfo());
                    AZTorrentSession.this.listener.sessionIsEstablished();
                }
                catch (AuthenticatorException ae) {
                    AZTorrentSession.this.end("AuthenticatorException:: " + ae.getMessage(), true);
                }
                ack.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_END") && Arrays.equals((end = (AZSessionEnd)message).getInfoHash(), AZTorrentSession.this.download.getInfoHash())) {
                System.out.println("AZ_TORRENT_SESSION_END received: " + end.getEndReason());
                AZTorrentSession.this.listener.sessionIsEnded(end.getEndReason());
                AZTorrentSession.this.destroy();
                end.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_BITFIELD") && (bitf = (AZSessionBitfield)message).getSessionID() == AZTorrentSession.this.local_session_id) {
                AZTorrentSession.this.listener.receivedSessionBitfield(bitf.getBitfield());
                bitf.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_REQUEST") && (req = (AZSessionRequest)message).getSessionID() == AZTorrentSession.this.local_session_id) {
                AZTorrentSession.this.listener.receivedSessionRequest(req.getUnchokeID(), req.getPieceNumber(), req.getPieceOffset(), req.getLength());
                req.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_CANCEL") && (cancel = (AZSessionCancel)message).getSessionID() == AZTorrentSession.this.local_session_id) {
                AZTorrentSession.this.listener.receivedSessionCancel(cancel.getPieceNumber(), cancel.getPieceOffset(), cancel.getLength());
                cancel.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_HAVE") && (have = (AZSessionHave)message).getSessionID() == AZTorrentSession.this.local_session_id) {
                int[] piecenums = have.getPieceNumbers();
                for (int i = 0; i < piecenums.length; ++i) {
                    AZTorrentSession.this.listener.receivedSessionHave(piecenums[i]);
                }
                have.destroy();
                return true;
            }
            if (message.getID().equals("AZ_SESSION_PIECE") && (piece = (AZSessionPiece)message).getSessionID() == AZTorrentSession.this.local_session_id) {
                try {
                    DirectByteBuffer data = AZTorrentSession.this.download.getSessionAuthenticator().decodeSessionData(AZTorrentSession.this.peer, piece.getPieceData());
                    AZTorrentSession.this.listener.receivedSessionPiece(piece.getPieceNumber(), piece.getPieceOffset(), data);
                }
                catch (AuthenticatorException ae) {
                    piece.getPieceData().returnToPool();
                    AZTorrentSession.this.end("AuthenticatorException:: " + ae.getMessage(), true);
                }
                piece.destroy();
                return true;
            }
            return false;
        }

        public void protocolBytesReceived(int byte_count) {
        }

        public void dataBytesReceived(int byte_count) {
        }
    };
    private final OutgoingMessageQueue.MessageQueueListener sent_message_listener = new OutgoingMessageQueue.MessageQueueListener(){

        public boolean messageAdded(Message message) {
            return true;
        }

        public void messageSent(Message message) {
            AZSessionPiece piece;
            if (message.getID().equals("AZ_SESSION_PIECE") && (piece = (AZSessionPiece)message).getSessionID() == AZTorrentSession.this.remote_session_id) {
                AZTorrentSession.this.listener.sentSessionPiece(message);
            }
        }

        public void messageQueued(Message message) {
        }

        public void messageRemoved(Message message) {
        }

        public void protocolBytesSent(int byte_count) {
        }

        public void dataBytesSent(int byte_count) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AZTorrentSession(TorrentDownload download, AZPeerConnection peer, TorrentSessionListener listener, int remote_id, Map incoming_syn) {
        this.download = download;
        this.peer = peer;
        this.remote_session_id = remote_id;
        this.listener = listener;
        try {
            session_mon.enter();
            this.local_session_id = next_session_id++;
        }
        finally {
            session_mon.exit();
        }
        peer.getNetworkConnection().getIncomingMessageQueue().registerQueueListener(this.incoming_q_listener);
        peer.getNetworkConnection().getOutgoingMessageQueue().registerQueueListener(this.sent_message_listener);
        this.authenticate(incoming_syn);
    }

    private void authenticate(Map incoming_syn) {
        if (incoming_syn == null) {
            AZSessionSyn syn = new AZSessionSyn(this.download.getInfoHash(), this.local_session_id, this.download.getSessionAuthenticator().createSessionSyn(this.peer));
            this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(syn, false);
            this.syn_timeout_timer = SimpleTimer.addEvent("AZTorrentSession:SynTImer", SystemTime.getCurrentTime() + 60000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    AZTorrentSession.this.end("No session ACK received after 60sec, request timed out.", true);
                }
            });
        } else {
            try {
                Map ack_reply = this.download.getSessionAuthenticator().verifySessionSyn(this.peer, incoming_syn);
                AZSessionAck ack = new AZSessionAck(this.download.getInfoHash(), this.local_session_id, ack_reply);
                this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(ack, false);
                this.listener.sessionIsEstablished();
            }
            catch (AuthenticatorException ae) {
                this.end("AuthenticatorException:: " + ae.getMessage(), true);
            }
        }
    }

    private void end(String end_reason, boolean notify_listener) {
        System.out.println("endSession:: " + end_reason);
        AZSessionEnd end = new AZSessionEnd(this.download.getInfoHash(), end_reason);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(end, false);
        if (notify_listener) {
            this.listener.sessionIsEnded(end_reason);
        }
        this.destroy();
    }

    private void destroy() {
        if (this.syn_timeout_timer != null) {
            this.syn_timeout_timer.cancel();
        }
        this.peer.getNetworkConnection().getIncomingMessageQueue().cancelQueueListener(this.incoming_q_listener);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().cancelQueueListener(this.sent_message_listener);
    }

    public void endSession(String reason) {
        this.end(reason, false);
    }

    public void sendSessionBitfield(DirectByteBuffer bitfield) {
        AZSessionBitfield bitf = new AZSessionBitfield(this.remote_session_id, bitfield);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(bitf, false);
    }

    public void sendSessionRequest(byte unchoke_id, int piece_number, int piece_offset, int length) {
        AZSessionRequest req = new AZSessionRequest(this.remote_session_id, unchoke_id, piece_number, piece_offset, length);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(req, false);
    }

    public void sendSessionCancel(int piece_number, int piece_offset, int length) {
        AZSessionCancel can = new AZSessionCancel(this.remote_session_id, piece_number, piece_offset, length);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(can, false);
    }

    public void sendSessionHave(int[] piece_numbers) {
        AZSessionHave have = new AZSessionHave(this.remote_session_id, piece_numbers);
        this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(have, false);
    }

    public Object sendSessionPiece(int piece_number, int piece_offset, DirectByteBuffer data) {
        try {
            DirectByteBuffer encoded = this.download.getSessionAuthenticator().encodeSessionData(this.peer, data);
            AZSessionPiece piece = new AZSessionPiece(this.remote_session_id, piece_number, piece_offset, encoded);
            this.peer.getNetworkConnection().getOutgoingMessageQueue().addMessage(piece, false);
            return piece;
        }
        catch (AuthenticatorException ae) {
            data.returnToPool();
            this.end("AuthenticatorException:: " + ae.getMessage(), true);
            return null;
        }
    }
}

