/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class SelectorGuard {
    private static final int SELECTOR_SPIN_THRESHOLD = 200;
    private static final int SELECTOR_FAILURE_THRESHOLD = 10000;
    private static final int MAX_IGNORES = 5;
    private boolean marked = false;
    private int consecutiveZeroSelects = 0;
    private long beforeSelectTime;
    private long select_op_time;
    private final String type;
    private final GuardListener listener;
    private int ignores = 0;

    public SelectorGuard(String _type, GuardListener _listener) {
        this.type = _type;
        this.listener = _listener;
    }

    public void markPreSelectTime() {
        this.beforeSelectTime = SystemTime.getCurrentTime();
        this.marked = true;
    }

    public void verifySelectorIntegrity(int num_keys_ready, long time_threshold) {
        if (num_keys_ready > 0) {
            ++this.ignores;
            if (this.ignores > 5) {
                this.ignores = 0;
                this.consecutiveZeroSelects = 0;
            }
            return;
        }
        if (this.marked) {
            this.marked = false;
        } else {
            Debug.out("Error: You must run markPreSelectTime() before calling isSelectorOK");
        }
        this.select_op_time = SystemTime.getCurrentTime() - this.beforeSelectTime;
        if (this.select_op_time > time_threshold || this.select_op_time < 0L) {
            this.consecutiveZeroSelects = 0;
            return;
        }
        ++this.consecutiveZeroSelects;
        if (this.consecutiveZeroSelects % 20 == 0 && Constants.isWindows) {
            Debug.out("consecutiveZeroSelects=" + this.consecutiveZeroSelects);
        }
        if (this.consecutiveZeroSelects > 200) {
            if (Constants.isWindows) {
                if (!this.listener.safeModeSelectEnabled()) {
                    String msg = "Likely faulty socket selector detected: reverting to safe-mode socket selection. [JRE " + Constants.JAVA_VERSION + "]\n";
                    msg = msg + "Please see http://azureus.aelitis.com/wiki/index.php/LikelyFaultySocketSelector for help.";
                    Debug.out(msg);
                    Logger.log(new LogAlert(false, 1, msg));
                    this.consecutiveZeroSelects = 0;
                    this.listener.spinDetected();
                    return;
                }
            } else {
                this.consecutiveZeroSelects = 0;
                try {
                    Thread.sleep(50L);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return;
            }
        }
        if (this.consecutiveZeroSelects > 10000) {
            String msg = "Likely network disconnect/reconnect: Repairing socket channel selector. [JRE " + Constants.JAVA_VERSION + "]\n";
            msg = msg + "Please see http://azureus.aelitis.com/wiki/index.php/LikelyNetworkDisconnectReconnect for help.";
            Debug.out(msg);
            Logger.log(new LogAlert(false, 1, msg));
            this.consecutiveZeroSelects = 0;
            this.listener.failureDetected();
            return;
        }
    }

    public static interface GuardListener {
        public boolean safeModeSelectEnabled();

        public void spinDetected();

        public void failureDetected();
    }
}

