/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.NavDialogCreationOptions;
import org.eclipse.swt.internal.carbon.NavReplyRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        String fullPath = null;
        this.fileNames = new String[0];
        int titlePtr = 0;
        if (this.title != null) {
            char[] buffer = new char[this.title.length()];
            this.title.getChars(0, buffer.length, buffer, 0);
            titlePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        int fileNamePtr = 0;
        if (this.fileName != null) {
            char[] buffer = new char[this.fileName.length()];
            this.fileName.getChars(0, buffer.length, buffer, 0);
            fileNamePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        NavDialogCreationOptions options = new NavDialogCreationOptions();
        options.windowTitle = options.clientName = titlePtr;
        options.parentWindow = OS.GetControlOwner(this.parent.handle);
        options.optionFlags = 4352;
        options.location_h = (short)-1;
        options.location_v = (short)-1;
        options.saveFileName = fileNamePtr;
        int identifiers = 0;
        int kUTTypeData = 0;
        int[] outDialog = new int[1];
        if ((this.style & 0x2000) != 0) {
            OS.NavCreatePutFileDialog(options, 0, 0, 0, 0, outDialog);
        } else {
            if ((this.style & 2) != 0) {
                options.optionFlags |= 0x80;
            }
            OS.NavCreateGetFileDialog(options, 0, 0, 0, 0, 0, outDialog);
        }
        if (outDialog[0] != 0) {
            if (this.filterExtensions == null) {
                this.filterExtensions = new String[0];
            }
            OS.NavDialogRun(outDialog[0]);
            int action = OS.NavDialogGetUserAction(outDialog[0]);
            switch (action) {
                case 2: 
                case 3: 
                case 4: {
                    NavReplyRecord record = new NavReplyRecord();
                    OS.NavDialogGetReply(outDialog[0], record);
                    AEDesc selection = new AEDesc();
                    selection.descriptorType = record.selection_descriptorType;
                    selection.dataHandle = record.selection_dataHandle;
                    int[] count = new int[1];
                    OS.AECountItems(selection, count);
                    if (count[0] <= 0) break;
                    this.fileNames = new String[count[0]];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr(maximumSize);
                    int[] aeKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int[] actualSize = new int[1];
                    int pathString = 0;
                    int fullString = 0;
                    int fileString = 0;
                    if ((this.style & 0x2000) != 0) {
                        if (OS.AEGetNthPtr(selection, 1, 1718841958, aeKeyword, typeCode, dataPtr, maximumSize, actualSize) == 0) {
                            byte[] fsRef = new byte[actualSize[0]];
                            OS.memcpy(fsRef, dataPtr, actualSize[0]);
                            int pathUrl = OS.CFURLCreateFromFSRef(0, fsRef);
                            int fullUrl = OS.CFURLCreateCopyAppendingPathComponent(0, pathUrl, record.saveFileName, false);
                            pathString = OS.CFURLCopyFileSystemPath(pathUrl, 0);
                            fullString = OS.CFURLCopyFileSystemPath(fullUrl, 0);
                            fileString = record.saveFileName;
                            OS.CFRelease(pathUrl);
                            OS.CFRelease(fullUrl);
                        }
                    } else {
                        int i = 0;
                        while (i < count[0]) {
                            if (OS.AEGetNthPtr(selection, i + 1, 1718841958, aeKeyword, typeCode, dataPtr, maximumSize, actualSize) == 0) {
                                byte[] fsRef = new byte[actualSize[0]];
                                OS.memcpy(fsRef, dataPtr, actualSize[0]);
                                int url = OS.CFURLCreateFromFSRef(0, fsRef);
                                if (i == 0) {
                                    int pathUrl = OS.CFURLCreateCopyDeletingLastPathComponent(0, url);
                                    pathString = OS.CFURLCopyFileSystemPath(pathUrl, 0);
                                    fullString = OS.CFURLCopyFileSystemPath(url, 0);
                                    fileString = OS.CFURLCopyLastPathComponent(url);
                                    OS.CFRelease(pathUrl);
                                } else {
                                    int lastString = OS.CFURLCopyLastPathComponent(url);
                                    int length = OS.CFStringGetLength(lastString);
                                    char[] buffer = new char[length];
                                    CFRange range = new CFRange();
                                    range.length = length;
                                    OS.CFStringGetCharacters(lastString, range, buffer);
                                    this.fileNames[i] = new String(buffer);
                                    OS.CFRelease(lastString);
                                }
                                OS.CFRelease(url);
                            }
                            ++i;
                        }
                    }
                    OS.DisposePtr(dataPtr);
                    if (pathString != 0) {
                        int length = OS.CFStringGetLength(pathString);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters(pathString, range, buffer);
                        OS.CFRelease(pathString);
                        this.filterPath = new String(buffer);
                    }
                    if (fullString != 0) {
                        int length = OS.CFStringGetLength(fullString);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters(fullString, range, buffer);
                        OS.CFRelease(fullString);
                        fullPath = new String(buffer);
                    }
                    if (fileString == 0) break;
                    int length = OS.CFStringGetLength(fileString);
                    char[] buffer = new char[length];
                    CFRange range = new CFRange();
                    range.length = length;
                    OS.CFStringGetCharacters(fileString, range, buffer);
                    OS.CFRelease(fileString);
                    this.fileName = this.fileNames[0] = new String(buffer);
                }
            }
        }
        if (titlePtr != 0) {
            OS.CFRelease(titlePtr);
        }
        if (fileNamePtr != 0) {
            OS.CFRelease(fileNamePtr);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogDispose(outDialog[0]);
        }
        if (identifiers != 0) {
            int count = OS.CFArrayGetCount(identifiers);
            int i = 0;
            while (i < count) {
                OS.CFRelease(OS.CFArrayGetValueAtIndex(identifiers, i));
                ++i;
            }
            OS.CFRelease(identifiers);
        }
        if (kUTTypeData != 0) {
            OS.CFRelease(kUTTypeData);
        }
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

