/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pf.text.StringPattern;

public class ExtendedFileFilter
implements FilenameFilter {
    protected static final int DIR_CHECK_NAME = 1;
    protected static final int DIR_INCLUDE = 2;
    protected static final int DIR_EXCLUDE = 3;
    private List stringPatterns = new Vector();
    private int dirHandling = 1;

    protected List getStringPatterns() {
        return this.stringPatterns;
    }

    protected void setStringPatterns(List newValue) {
        this.stringPatterns = newValue;
    }

    protected int getDirHandling() {
        return this.dirHandling;
    }

    protected void setDirHandling(int newValue) {
        this.dirHandling = newValue;
    }

    public void addPattern(String pattern) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(pattern, false);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, char digitWildcard) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(pattern, false, digitWildcard);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, boolean ignoreCase) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(pattern, ignoreCase);
        this.getStringPatterns().add(stringPattern);
    }

    public void addPattern(String pattern, boolean ignoreCase, char digitWildcard) {
        StringPattern stringPattern = null;
        stringPattern = new StringPattern(pattern, ignoreCase, digitWildcard);
        this.getStringPatterns().add(stringPattern);
    }

    public void checkNameOfDirectories() {
        this.setDirHandling(1);
    }

    public void alwaysIncludeDirectories() {
        this.setDirHandling(2);
    }

    public void alwaysExcludeDirectories() {
        this.setDirHandling(3);
    }

    public boolean accept(File dir, String name) {
        File fileOrDir = null;
        fileOrDir = new File(dir, name);
        if (fileOrDir.isDirectory()) {
            if (this.mustIncludeDirectories()) {
                return true;
            }
            if (this.mustExcludeDirectories()) {
                return false;
            }
        }
        return this.checkAgainstPatterns(name);
    }

    protected boolean checkAgainstPatterns(String name) {
        Iterator iterator = null;
        StringPattern pattern2 = null;
        for (StringPattern pattern2 : this.getStringPatterns()) {
            if (!pattern2.matches(name)) continue;
            return true;
        }
        return false;
    }

    public boolean mustIncludeDirectories() {
        return this.getDirHandling() == 2;
    }

    public boolean mustExcludeDirectories() {
        return this.getDirHandling() == 3;
    }
}

