/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlockCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlocksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PieceNumberItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.RequestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.ReservedByItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.WritersItem;

public class PiecesView
extends TableView
implements DownloadManagerPeerListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new PieceNumberItem(), new SizeItem(), new BlockCountItem(), new BlocksItem(), new CompletedItem(), new AvailabilityItem(), new TypeItem(), new ReservedByItem(), new WritersItem(), new PriorityItem(), new SpeedItem(), new RequestedItem()};
    DownloadManager manager;

    public PiecesView() {
        super("Pieces", "PiecesView", basicItems, basicItems[0].getName(), 0x10010004);
        this.bEnableTabViews = true;
    }

    public void dataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (this.manager != null && this.getTable() != null) {
            this.manager.addPeerListener(this, false);
            this.addExistingDatasources();
        }
    }

    public void initialize(Composite composite) {
        super.initialize(composite);
        Legend.createLegendComposite(this.getTableComposite(), BlocksItem.colors, new String[]{"PiecesView.legend.requested", "PiecesView.legend.written", "PiecesView.legend.downloaded", "PiecesView.legend.incache"});
    }

    public void tableStructureChanged() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        super.tableStructureChanged();
        if (this.manager != null) {
            this.manager.addPeerListener(this, false);
            this.addExistingDatasources();
        }
    }

    public void delete() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        super.delete();
    }

    public void pieceAdded(PEPiece created) {
        this.addDataSource(created);
    }

    public void pieceRemoved(PEPiece removed) {
        this.removeDataSource(removed);
    }

    public void peerAdded(PEPeer peer) {
    }

    public void peerRemoved(PEPeer peer) {
    }

    public void peerManagerAdded(PEPeerManager manager) {
    }

    public void peerManagerRemoved(PEPeerManager manager) {
        this.removeAllTableRows();
    }

    private void addExistingDatasources() {
        if (this.manager == null) {
            return;
        }
        Object[] dataSources = this.manager.getCurrentPieces();
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        this.addDataSources(dataSources);
        this.processDataSourceQueue();
    }

    public void initializeTable(Table table) {
        super.initializeTable(table);
        this.manager.addPeerListener(this, false);
        this.addExistingDatasources();
    }
}

