/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.nat;

import com.aelitis.azureus.core.AzureusCoreFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class NatTestWindow {
    Display display;
    Button bTest;
    Button bApply;
    Button bCancel;
    StyledText textResults;
    Checker checker;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");

    public NatTestWindow() {
        final Shell shell = ShellFactory.createShell(2144);
        shell.setText(MessageText.getString("configureWizard.nat.title"));
        if (!Constants.isOSX) {
            shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.display = shell.getDisplay();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textServerTCPListen.setLayoutData((Object)gridData);
        textServerTCPListen.setText("" + this.serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                int TCPListenPort;
                NatTestWindow.this.serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
            }
        });
        this.bTest = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTest, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTest.setLayoutData((Object)gridData);
        this.textResults = new StyledText(panel, 2562);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 100;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.textResults.setLayoutData((Object)gridData);
        this.textResults.setBackground(panel.getDisplay().getSystemColor(1));
        this.bTest.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                NatTestWindow.this.bTest.setEnabled(false);
                NatTestWindow.this.textResults.setText("");
                NatTestWindow.this.checker = new Checker(NatTestWindow.this.serverTCPListenPort);
                NatTestWindow.this.checker.start();
            }
        });
        this.bApply = new Button(panel, 8);
        this.bApply.setText(MessageText.getString("Button.apply"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 2;
        this.bApply.setLayoutData((Object)gridData);
        this.bApply.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int old_tcp = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int old_udp = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                int old_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
                COConfigurationManager.setParameter("TCP.Listen.Port", NatTestWindow.this.serverTCPListenPort);
                if (old_tcp == old_udp) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", NatTestWindow.this.serverTCPListenPort);
                }
                if (old_tcp == old_udp2) {
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", NatTestWindow.this.serverTCPListenPort);
                }
                shell.close();
            }
        });
        this.bCancel = new Button(panel, 8);
        this.bCancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bCancel.setLayoutData((Object)gridData);
        this.bCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.close();
            }
        });
        shell.setDefaultButton(this.bApply);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }
        });
        shell.pack();
        Utils.centreWindow(shell);
        shell.open();
    }

    public void printMessage(final String message) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (NatTestWindow.this.textResults == null || NatTestWindow.this.textResults.isDisposed()) {
                    return;
                }
                NatTestWindow.this.textResults.append(message);
            }
        });
    }

    public class Checker
    extends AEThread {
        private int TCPListenPort;

        public Checker(int tcp_listen_port) {
            super("NAT Checker");
            this.TCPListenPort = tcp_listen_port;
        }

        public void runSupport() {
            NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " " + this.TCPListenPort + " ... ");
            int portResult = NatChecker.test(AzureusCoreFactory.getSingleton(), this.TCPListenPort);
            switch (portResult) {
                case 1: {
                    NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.ok") + "\n");
                    break;
                }
                case 2: {
                    NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.ko") + "\n");
                    break;
                }
                default: {
                    NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.unable") + "\n");
                }
            }
            NatTestWindow.this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (NatTestWindow.this.bTest != null && !NatTestWindow.this.bTest.isDisposed()) {
                        NatTestWindow.this.bTest.setEnabled(true);
                    }
                }
            });
        }
    }
}

