/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePiecerPriorityShaper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerChannelImpl
implements DiskManagerChannel,
DiskManagerFileInfoListener,
DownloadManagerPeerListener,
PiecePiecerPriorityShaper {
    private static final boolean TRACE = false;
    private static final int COMPACT_DELAY = 32;
    private static final int MAX_READ_CHUNK = 65536;
    private static final Comparator comparator = new Comparator(){

        public int compare(Object _o1, Object _o2) {
            dataEntry o1 = (dataEntry)_o1;
            dataEntry o2 = (dataEntry)_o2;
            long offset1 = o1.getOffset();
            long length1 = o1.getLength();
            long offset2 = o2.getOffset();
            long length2 = o2.getLength();
            long res = offset1 == offset2 ? length1 - length2 : offset1 - offset2;
            if (res == 0L) {
                return 0;
            }
            if (res < 0L) {
                return -1;
            }
            return 1;
        }
    };
    private static final String channel_key = "DiskManagerChannel";
    private static int channel_id_next;
    private DownloadImpl download;
    private DiskManagerFileInfoImpl plugin_file;
    private DiskManagerFileInfo core_file;
    private Set data_written = new TreeSet(comparator);
    private int compact_delay = 32;
    private List waiters = new ArrayList();
    private long file_offset_in_torrent;
    private long piece_size;
    private static final int PIECES_TO_BUFFER_MIN = 10;
    private Average byte_rate = Average.getInstance(1000, 20);
    private long current_position;
    private int pieces_to_buffer = 10;
    private PEPeerManager peer_manager;
    private int[] priority_offsets;
    private int channel_id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DiskManagerChannelImpl(DownloadImpl _download, DiskManagerFileInfoImpl _plugin_file) {
        this.download = _download;
        this.plugin_file = _plugin_file;
        this.core_file = this.plugin_file.getCore();
        Class<DiskManagerChannelImpl> clazz = DiskManagerChannelImpl.class;
        synchronized (DiskManagerChannelImpl.class) {
            this.channel_id = channel_id_next++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            TOTorrentFile tf = this.core_file.getTorrentFile();
            TOTorrent torrent = tf.getTorrent();
            TOTorrentFile[] tfs = torrent.getFiles();
            this.priority_offsets = new int[torrent.getNumberOfPieces()];
            this.core_file.getDownloadManager().addPeerListener(this);
            for (int i = 0; i < this.core_file.getIndex(); ++i) {
                this.file_offset_in_torrent += tfs[i].getLength();
            }
            this.piece_size = tf.getTorrent().getPieceLength();
            this.core_file.addListener(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerRequest createRequest() {
        if (this.core_file.getDownloaded() != this.core_file.getLength()) {
            boolean force_start;
            if (this.core_file.isSkipped()) {
                this.core_file.setSkipped(false);
            }
            if (!(force_start = this.download.isForceStart())) {
                DownloadImpl downloadImpl = this.download;
                synchronized (downloadImpl) {
                    HashMap<String, String> dl_state = (HashMap<String, String>)this.download.getDownload().getData(channel_key);
                    if (dl_state == null) {
                        dl_state = new HashMap<String, String>();
                        this.download.getDownload().setData(channel_key, dl_state);
                    }
                    dl_state.put("" + this.channel_id, "");
                }
                this.download.setForceStart(true);
            }
        }
        return new request();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataWritten(long offset, long length) {
        dataEntry entry = new dataEntry(offset, length);
        Set set = this.data_written;
        synchronized (set) {
            this.data_written.add(entry);
            --this.compact_delay;
            if (this.compact_delay == 0) {
                this.compact_delay = 32;
                Iterator it = this.data_written.iterator();
                dataEntry prev_e = null;
                while (it.hasNext()) {
                    dataEntry this_e = (dataEntry)it.next();
                    if (prev_e == null) {
                        prev_e = this_e;
                        continue;
                    }
                    long prev_offset = prev_e.getOffset();
                    long prev_length = prev_e.getLength();
                    long this_offset = this_e.getOffset();
                    long this_length = this_e.getLength();
                    if (this_offset <= prev_offset + prev_length) {
                        it.remove();
                        prev_e.setLength(Math.max(prev_offset + prev_length, this_offset + this_length) - prev_offset);
                        continue;
                    }
                    prev_e = this_e;
                }
            }
            for (int i = 0; i < this.waiters.size(); ++i) {
                ((AESemaphore)this.waiters.get(i)).release();
            }
        }
    }

    public void dataChecked(long offset, long length) {
    }

    public void peerManagerAdded(PEPeerManager manager) {
        this.peer_manager = manager;
        manager.getPiecePicker().addPriorityShaper(this);
    }

    public void peerManagerRemoved(PEPeerManager manager) {
        this.peer_manager = null;
        manager.getPiecePicker().removePriorityShaper(this);
    }

    public void peerAdded(PEPeer peer) {
    }

    public void peerRemoved(PEPeer peer) {
    }

    public void pieceAdded(PEPiece piece) {
    }

    public void pieceRemoved(PEPiece piece) {
    }

    public int[] updatePriorityOffsets(PiecePicker picker) {
        long overall_pos = this.current_position + this.file_offset_in_torrent;
        int first_piece = (int)(overall_pos / this.piece_size);
        Arrays.fill(this.priority_offsets, 0);
        for (int i = first_piece; i < first_piece + this.pieces_to_buffer && i < this.priority_offsets.length; ++i) {
            this.priority_offsets[i] = 1000000 - (i - first_piece) * 10000;
        }
        return this.priority_offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.core_file.removeListener(this);
        this.core_file.getDownloadManager().removePeerListener(this);
        if (this.peer_manager != null) {
            this.peer_manager.getPiecePicker().removePriorityShaper(this);
        }
        boolean stop_force_start = false;
        DownloadImpl downloadImpl = this.download;
        synchronized (downloadImpl) {
            Map dl_state = (Map)this.download.getDownload().getData(channel_key);
            if (dl_state != null) {
                dl_state.remove("" + this.channel_id);
                if (dl_state.size() == 0) {
                    stop_force_start = true;
                }
            }
        }
        if (stop_force_start) {
            this.download.setForceStart(false);
        }
    }

    protected static class dataEntry {
        private long offset;
        private long length;

        protected dataEntry(long _offset, long _length) {
            this.offset = _offset;
            this.length = _length;
        }

        protected long getOffset() {
            return this.offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected void setLength(long _length) {
            this.length = _length;
        }

        protected String getString() {
            return "offset=" + this.offset + ",length=" + this.length;
        }
    }

    protected class request
    implements DiskManagerRequest {
        private int request_type;
        private long request_offset;
        private long request_length;
        private List listeners = new ArrayList();
        private volatile boolean cancelled;
        AESemaphore wait_sem = new AESemaphore("DiskManagerChannelImpl:wait");

        protected request() {
        }

        public void setType(int _type) {
            this.request_type = _type;
        }

        public void setOffset(long _offset) {
            this.request_offset = _offset;
        }

        public void setLength(long _length) {
            this.request_length = _length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getRemaining() {
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                return this.request_length - (DiskManagerChannelImpl.this.current_position - this.request_offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getAvailableBytes() {
            if (DiskManagerChannelImpl.this.plugin_file.getDownloaded() == DiskManagerChannelImpl.this.plugin_file.getLength()) {
                return this.getRemaining();
            }
            int download_state = DiskManagerChannelImpl.this.download.getState();
            if (download_state != 4 && download_state != 5) {
                return -1L;
            }
            Set set = DiskManagerChannelImpl.this.data_written;
            synchronized (set) {
                Iterator it = DiskManagerChannelImpl.this.data_written.iterator();
                dataEntry last_entry = null;
                while (it.hasNext()) {
                    dataEntry entry = (dataEntry)it.next();
                    long entry_offset = entry.getOffset();
                    long entry_length = entry.getLength();
                    if (last_entry == null) {
                        if (entry_offset > DiskManagerChannelImpl.this.current_position) break;
                        if (entry_offset > DiskManagerChannelImpl.this.current_position || DiskManagerChannelImpl.this.current_position >= entry_offset + entry_length) continue;
                        last_entry = entry;
                        continue;
                    }
                    if (last_entry.getOffset() + last_entry.getLength() != entry.getOffset()) break;
                    last_entry = entry;
                }
                if (last_entry == null) {
                    return 0L;
                }
                return last_entry.getOffset() + last_entry.getLength() - DiskManagerChannelImpl.this.current_position;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long rem = this.request_length;
            long pos = this.request_offset;
            while (true) {
                try {
                    if (rem <= 0L || this.cancelled) break;
                    int len = 0;
                    Set set = DiskManagerChannelImpl.this.data_written;
                    synchronized (set) {
                        dataEntry entry;
                        long entry_offset;
                        DiskManagerChannelImpl.this.current_position = pos;
                        Iterator it = DiskManagerChannelImpl.this.data_written.iterator();
                        while (it.hasNext() && (entry_offset = (entry = (dataEntry)it.next()).getOffset()) <= pos) {
                            long entry_length = entry.getLength();
                            long available = entry_offset + entry_length - pos;
                            if (available <= 0L) continue;
                            len = (int)(available < 65536L ? available : 65536L);
                            break;
                        }
                    }
                    if (len > 0) {
                        DirectByteBuffer buffer = DiskManagerChannelImpl.this.core_file.read(pos, len);
                        this.inform(new event(new PooledByteBufferImpl(buffer), pos, len));
                        pos += (long)len;
                        rem -= (long)len;
                        Set set2 = DiskManagerChannelImpl.this.data_written;
                        synchronized (set2) {
                            DiskManagerChannelImpl.this.byte_rate.addValue(len);
                            DiskManagerChannelImpl.this.current_position = pos;
                            continue;
                        }
                    }
                    this.inform(new event(pos));
                    set = DiskManagerChannelImpl.this.data_written;
                    synchronized (set) {
                        DiskManagerChannelImpl.this.waiters.add(this.wait_sem);
                    }
                    try {
                        this.wait_sem.reserve();
                    }
                    finally {
                        set = DiskManagerChannelImpl.this.data_written;
                        synchronized (set) {
                            DiskManagerChannelImpl.this.waiters.remove(this.wait_sem);
                        }
                    }
                }
                catch (Throwable e) {
                    this.inform(e);
                    break;
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.inform(new Throwable("Request cancelled"));
            this.wait_sem.release();
        }

        protected void inform(Throwable e) {
            this.inform(new event(e));
        }

        protected void inform(event ev) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((DiskManagerListener)this.listeners.get(i)).eventOccurred(ev);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }

        public void addListener(DiskManagerListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(DiskManagerListener listener) {
            this.listeners.remove(listener);
        }

        protected class event
        implements DiskManagerEvent {
            private int event_type;
            private Throwable error;
            private PooledByteBuffer buffer;
            private long event_offset;
            private int event_length;

            protected event(Throwable _error) {
                this.event_type = 2;
                this.error = _error;
            }

            protected event(long _offset) {
                this.event_type = 3;
                this.event_offset = _offset;
            }

            protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                this.event_type = 1;
                this.buffer = _buffer;
                this.event_offset = _offset;
                this.event_length = _length;
            }

            public int getType() {
                return this.event_type;
            }

            public DiskManagerRequest getRequest() {
                return request.this;
            }

            public long getOffset() {
                return this.event_offset;
            }

            public int getLength() {
                return this.event_length;
            }

            public PooledByteBuffer getBuffer() {
                return this.buffer;
            }

            public Throwable getFailure() {
                return this.error;
            }
        }
    }
}

