/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequest;
import org.gudy.azureus2.core3.util.ConcurrentHasherRequestListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.ThreadPool;

public class ConcurrentHasher {
    protected static ConcurrentHasher singleton = new ConcurrentHasher();
    protected int processor_num;
    protected List requests = new LinkedList();
    protected List hashers = new ArrayList();
    protected AESemaphore request_sem = new AESemaphore("ConcHashReqQ");
    protected AESemaphore scheduler_sem = new AESemaphore("ConcHashSched");
    protected AEMonitor requests_mon = new AEMonitor("ConcurrentHasher:R");
    private static boolean friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");

    public static ConcurrentHasher getSingleton() {
        return singleton;
    }

    public static boolean concurrentHashingAvailable() {
        return ConcurrentHasher.getSingleton().processor_num > 1;
    }

    protected ConcurrentHasher() {
        this.processor_num = Runtime.getRuntime().availableProcessors();
        if (this.processor_num <= 0) {
            this.processor_num = 1;
        }
        for (int i = 0; i < this.processor_num + 1; ++i) {
            this.scheduler_sem.release();
        }
        final ThreadPool pool = new ThreadPool("ConcurrentHasher", 64);
        AEThread scheduler = new AEThread("CuncurrentHasher:scheduler"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                while (true) {
                    SHA1Hasher hasher;
                    ConcurrentHasherRequest req;
                    ConcurrentHasher.this.request_sem.reserve();
                    try {
                        ConcurrentHasher.this.requests_mon.enter();
                        req = (ConcurrentHasherRequest)ConcurrentHasher.this.requests.remove(0);
                        hasher = ConcurrentHasher.this.hashers.size() == 0 ? new SHA1Hasher() : (SHA1Hasher)ConcurrentHasher.this.hashers.remove(ConcurrentHasher.this.hashers.size() - 1);
                    }
                    finally {
                        ConcurrentHasher.this.requests_mon.exit();
                    }
                    pool.run(new AERunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            block13: {
                                try {
                                    req.run(hasher);
                                    Object var2_1 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var2_2 = null;
                                    try {
                                        ConcurrentHasher.this.requests_mon.enter();
                                        ConcurrentHasher.this.hashers.add(hasher);
                                    }
                                    finally {
                                        ConcurrentHasher.this.requests_mon.exit();
                                    }
                                    if (friendly_hashing && req.isLowPriority()) {
                                        try {
                                            int size = req.getSize();
                                            int max = 250;
                                            int min = 50;
                                            size /= 1024;
                                            size /= 8;
                                            size = Math.min(size, 250);
                                            size = Math.max(size, 50);
                                            Thread.sleep(size);
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    ConcurrentHasher.this.scheduler_sem.release();
                                    throw throwable;
                                }
                                try {
                                    ConcurrentHasher.this.requests_mon.enter();
                                    ConcurrentHasher.this.hashers.add(hasher);
                                }
                                finally {
                                    ConcurrentHasher.this.requests_mon.exit();
                                }
                                if (friendly_hashing && req.isLowPriority()) {
                                    try {
                                        int size = req.getSize();
                                        int max = 250;
                                        int min = 50;
                                        size /= 1024;
                                        size /= 8;
                                        size = Math.min(size, 250);
                                        size = Math.max(size, 50);
                                        Thread.sleep(size);
                                        break block13;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                    {
                                    }
                                }
                            }
                            ConcurrentHasher.this.scheduler_sem.release();
                        }
                    });
                }
            }
        };
        scheduler.setDaemon(true);
        scheduler.start();
    }

    public ConcurrentHasherRequest addRequest(ByteBuffer buffer) {
        return this.addRequest(buffer, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHasherRequest addRequest(ByteBuffer buffer, ConcurrentHasherRequestListener listener, boolean low_priorty) {
        ConcurrentHasherRequest req = new ConcurrentHasherRequest(this, buffer, listener, low_priorty);
        this.scheduler_sem.reserve();
        try {
            this.requests_mon.enter();
            this.requests.add(req);
        }
        finally {
            this.requests_mon.exit();
        }
        this.request_sem.release();
        return req;
    }

    public static void main(String[] args) {
    }

    static {
        COConfigurationManager.addParameterListener("diskmanager.friendly.hashchecking", new ParameterListener(){

            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        });
    }
}

