/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.natchecker;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatCheckerServer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;

public class NatChecker {
    private static final LogIDs LOGID = LogIDs.NET;
    public static final int NAT_OK = 1;
    public static final int NAT_KO = 2;
    public static final int NAT_UNABLE = 3;
    private static final String[] urls = new String[]{"http://azureus.aelitis.com/natcheck.php"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int test(AzureusCore azureus_core, int port) {
        UPnPPlugin upnp;
        UPnPMapping mapping;
        String check = "azureus_rand_" + String.valueOf((int)(Math.random() * 100000.0));
        NatCheckerServer server = new NatCheckerServer(port, check);
        if (!server.isValid()) {
            return 3;
        }
        if (port < 0 || port > 65535 || port == 6880) {
            return 3;
        }
        PluginInterface pi_upnp = azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        UPnPMapping new_mapping = null;
        if (pi_upnp != null && (mapping = (upnp = (UPnPPlugin)pi_upnp.getPlugin()).getMapping(true, port)) == null) {
            new_mapping = upnp.addMapping("NAT Tester", true, port, true);
            try {
                Thread.sleep(500L);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        try {
            server.start();
            String urlStr = urls[0] + "?port=" + String.valueOf(port) + "&check=" + check;
            URL url = new URL(urlStr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            ByteArrayOutputStream message = new ByteArrayOutputStream();
            InputStream is = con.getInputStream();
            byte[] data = new byte[1024];
            int nbRead = 0;
            while (nbRead >= 0) {
                nbRead = is.read(data);
                if (nbRead >= 0) {
                    message.write(data, 0, nbRead);
                }
                Thread.sleep(20L);
            }
            Map map = BDecoder.decode(message.toByteArray());
            int result = ((Long)map.get("result")).intValue();
            switch (result) {
                case 0: {
                    byte[] reason = (byte[])map.get("reason");
                    if (reason != null) {
                        Logger.log(new LogEvent(LOGID, 3, "NAT CHECK FAILED: " + new String(reason)));
                    }
                    int n = 2;
                    return n;
                }
                case 1: {
                    int n = 1;
                    return n;
                }
            }
            int n = 3;
            return n;
        }
        catch (Exception e) {
            int n = 3;
            return n;
        }
        finally {
            if (new_mapping != null) {
                new_mapping.destroy();
            }
            server.stopIt();
        }
    }
}

