/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.mc.impl;

import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;
import org.gudy.azureus2.pluginsimpl.local.utils.UTTimerImpl;

public class MCGroupImpl
implements MCGroup {
    private static final int TTL = 4;
    private static final int PACKET_SIZE = 8192;
    private static Map singletons = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("MCGroup:class");
    private MCGroupAdapter adapter;
    private String group_address_str;
    private int group_port;
    private int control_port;
    protected InetSocketAddress group_address;
    private String[] selected_interfaces;
    private boolean ttl_problem_reported = true;
    private boolean sso_problem_reported = true;
    protected AEMonitor this_mon = new AEMonitor("MCGroup");
    private Map current_registrations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MCGroupImpl getSingleton(MCGroupAdapter adapter, String group_address, int group_port, int control_port, String[] interfaces) throws MCGroupException {
        try {
            class_mon.enter();
            String key = group_address + ":" + group_port + ":" + control_port;
            MCGroupImpl singleton = (MCGroupImpl)singletons.get(key);
            if (singleton == null) {
                singleton = new MCGroupImpl(adapter, group_address, group_port, control_port, interfaces);
                singletons.put(key, singleton);
            }
            MCGroupImpl mCGroupImpl = singleton;
            return mCGroupImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    public MCGroupImpl(MCGroupAdapter _adapter, String _group_address, int _group_port, int _control_port, String[] _interfaces) throws MCGroupException {
        this.adapter = _adapter;
        this.group_address_str = _group_address;
        this.group_port = _group_port;
        this.control_port = _control_port;
        this.selected_interfaces = _interfaces;
        try {
            this.group_address = new InetSocketAddress(InetAddress.getByName(this.group_address_str), 0);
            this.processNetworkInterfaces(true);
            UTTimerImpl timer = new UTTimerImpl("MCGroup:refresher", true);
            timer.addPeriodicEvent(60000L, new UTTimerEventPerformer(){

                public void perform(UTTimerEvent event2) {
                    try {
                        MCGroupImpl.this.processNetworkInterfaces(false);
                    }
                    catch (Throwable e) {
                        MCGroupImpl.this.adapter.log(e);
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new MCGroupException("Failed to initialise MCGroup", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNetworkInterfaces(boolean start_of_day) throws SocketException {
        HashMap new_registrations = new HashMap();
        ArrayList<NetworkInterface> changed_interfaces = new ArrayList<NetworkInterface>();
        try {
            this.this_mon.enter();
            Enumeration<NetworkInterface> network_interfaces = NetworkInterface.getNetworkInterfaces();
            while (network_interfaces.hasMoreElements()) {
                final NetworkInterface network_interface = network_interfaces.nextElement();
                if (!this.interfaceSelected(network_interface)) {
                    if (!start_of_day) continue;
                    this.adapter.trace("ignoring interface " + network_interface.getName() + ":" + network_interface.getDisplayName() + ", not selected");
                    continue;
                }
                HashSet old_address_set = (HashSet)this.current_registrations.get(network_interface);
                if (old_address_set == null) {
                    old_address_set = new HashSet();
                }
                HashSet<InetAddress> new_address_set = new HashSet<InetAddress>();
                new_registrations.put(network_interface, new_address_set);
                Enumeration<InetAddress> ni_addresses = network_interface.getInetAddresses();
                while (ni_addresses.hasMoreElements()) {
                    final InetAddress ni_address = ni_addresses.nextElement();
                    new_address_set.add(ni_address);
                    if (old_address_set.contains(ni_address)) continue;
                    if (ni_address.isLoopbackAddress()) {
                        if (!start_of_day) continue;
                        this.adapter.trace("ignoring loopback address " + ni_address + ", interface " + network_interface.getName());
                        continue;
                    }
                    if (ni_address instanceof Inet6Address) {
                        if (!start_of_day) continue;
                        this.adapter.trace("ignoring IPv6 address " + ni_address + ", interface " + network_interface.getName());
                        continue;
                    }
                    if (!start_of_day && !changed_interfaces.contains(network_interface)) {
                        changed_interfaces.add(network_interface);
                    }
                    try {
                        MulticastSocket mc_sock;
                        block19: {
                            mc_sock = new MulticastSocket(this.group_port);
                            mc_sock.setReuseAddress(true);
                            try {
                                mc_sock.setTimeToLive(4);
                            }
                            catch (Throwable e) {
                                if (this.ttl_problem_reported) break block19;
                                this.ttl_problem_reported = true;
                                this.adapter.log(e);
                            }
                        }
                        String addresses_string = "";
                        Enumeration<InetAddress> it = network_interface.getInetAddresses();
                        while (it.hasMoreElements()) {
                            InetAddress addr = it.nextElement();
                            addresses_string = addresses_string + (addresses_string.length() == 0 ? "" : ",") + addr;
                        }
                        this.adapter.trace("group = " + this.group_address + "/" + network_interface.getName() + ":" + network_interface.getDisplayName() + "-" + addresses_string + ": started");
                        mc_sock.joinGroup(this.group_address, network_interface);
                        mc_sock.setNetworkInterface(network_interface);
                        mc_sock.setLoopbackMode(false);
                        Runtime.getRuntime().addShutdownHook(new AEThread("MCGroup:VMShutdown"){

                            public void runSupport() {
                                try {
                                    mc_sock.leaveGroup(MCGroupImpl.this.group_address, network_interface);
                                }
                                catch (Throwable e) {
                                    MCGroupImpl.this.adapter.log(e);
                                }
                            }
                        });
                        new AEThread("MCGroup:MCListener", true){

                            public void runSupport() {
                                MCGroupImpl.this.handleSocket(network_interface, ni_address, mc_sock, true);
                            }
                        }.start();
                    }
                    catch (Throwable e) {
                        this.adapter.log(e);
                    }
                    try {
                        final DatagramSocket control_socket = new DatagramSocket(null);
                        control_socket.setReuseAddress(true);
                        control_socket.bind(new InetSocketAddress(ni_address, this.control_port));
                        if (this.control_port == 0) {
                            this.control_port = control_socket.getLocalPort();
                        }
                        new AEThread("MCGroup:CtrlListener", true){

                            public void runSupport() {
                                MCGroupImpl.this.handleSocket(network_interface, ni_address, control_socket, false);
                            }
                        }.start();
                    }
                    catch (Throwable e) {
                        this.adapter.log(e);
                    }
                }
            }
        }
        finally {
            this.current_registrations = new_registrations;
            this.this_mon.exit();
        }
        for (int i = 0; i < changed_interfaces.size(); ++i) {
            this.adapter.interfaceChanged((NetworkInterface)changed_interfaces.get(i));
        }
    }

    public int getControlPort() {
        return this.control_port;
    }

    protected boolean interfaceSelected(NetworkInterface ni) {
        if (this.selected_interfaces != null && this.selected_interfaces.length > 0) {
            boolean ok = false;
            for (int i = 0; i < this.selected_interfaces.length; ++i) {
                if (!ni.getName().equalsIgnoreCase(this.selected_interfaces[i])) continue;
                ok = true;
                break;
            }
            return ok;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validNetworkAddress(NetworkInterface network_interface, InetAddress ni_address) {
        try {
            this.this_mon.enter();
            Set set = (Set)this.current_registrations.get(network_interface);
            if (set == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = set.contains(ni_address);
            return bl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void sendToGroup(byte[] data) throws MCGroupException {
        try {
            Enumeration<NetworkInterface> x = NetworkInterface.getNetworkInterfaces();
            while (x != null && x.hasMoreElements()) {
                NetworkInterface network_interface = x.nextElement();
                if (!this.interfaceSelected(network_interface)) continue;
                Enumeration<InetAddress> ni_addresses = network_interface.getInetAddresses();
                boolean ok = false;
                while (ni_addresses.hasMoreElements()) {
                    InetAddress ni_address = ni_addresses.nextElement();
                    if (ni_address instanceof Inet6Address || ni_address.isLoopbackAddress()) continue;
                    ok = true;
                    break;
                }
                if (!ok) continue;
                try {
                    MulticastSocket mc_sock;
                    block8: {
                        mc_sock = new MulticastSocket(null);
                        mc_sock.setReuseAddress(true);
                        try {
                            mc_sock.setTimeToLive(4);
                        }
                        catch (Throwable e) {
                            if (this.ttl_problem_reported) break block8;
                            this.ttl_problem_reported = true;
                            this.adapter.log(e);
                        }
                    }
                    mc_sock.bind(new InetSocketAddress(this.control_port));
                    mc_sock.setNetworkInterface(network_interface);
                    DatagramPacket packet = new DatagramPacket(data, data.length, this.group_address.getAddress(), this.group_port);
                    mc_sock.send(packet);
                    mc_sock.close();
                }
                catch (Throwable e) {
                    if (this.sso_problem_reported) continue;
                    this.sso_problem_reported = true;
                    this.adapter.log(e);
                }
            }
        }
        catch (Throwable e) {
            throw new MCGroupException("sendToGroup failed", e);
        }
    }

    public void sendToGroup(String param_data) throws MCGroupException {
        try {
            Enumeration<NetworkInterface> x = NetworkInterface.getNetworkInterfaces();
            while (x != null && x.hasMoreElements()) {
                NetworkInterface network_interface = x.nextElement();
                if (!this.interfaceSelected(network_interface)) continue;
                Enumeration<InetAddress> ni_addresses = network_interface.getInetAddresses();
                InetAddress an_address = null;
                while (ni_addresses.hasMoreElements()) {
                    InetAddress ni_address = ni_addresses.nextElement();
                    if (ni_address instanceof Inet6Address || ni_address.isLoopbackAddress()) continue;
                    an_address = ni_address;
                    break;
                }
                if (an_address == null) continue;
                try {
                    MulticastSocket mc_sock;
                    block8: {
                        mc_sock = new MulticastSocket(null);
                        mc_sock.setReuseAddress(true);
                        try {
                            mc_sock.setTimeToLive(4);
                        }
                        catch (Throwable e) {
                            if (this.ttl_problem_reported) break block8;
                            this.ttl_problem_reported = true;
                            this.adapter.log(e);
                        }
                    }
                    mc_sock.bind(new InetSocketAddress(this.control_port));
                    mc_sock.setNetworkInterface(network_interface);
                    byte[] data = param_data.replaceAll("%AZINTERFACE%", an_address.getHostAddress()).getBytes();
                    DatagramPacket packet = new DatagramPacket(data, data.length, this.group_address.getAddress(), this.group_port);
                    mc_sock.send(packet);
                    mc_sock.close();
                }
                catch (Throwable e) {
                    if (this.sso_problem_reported) continue;
                    this.sso_problem_reported = true;
                    this.adapter.log(e);
                }
            }
        }
        catch (Throwable e) {
            throw new MCGroupException("sendToGroup failed", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleSocket(NetworkInterface network_interface, InetAddress local_address, DatagramSocket socket, boolean log_on_stop) {
        successful_accepts = 0L;
        failed_accepts = 0L;
        port = socket.getLocalPort();
        try {
            socket.setSoTimeout(30000);
        }
        catch (Throwable e) {
            // empty catch block
        }
        while (true) {
            if (!this.validNetworkAddress(network_interface, local_address)) {
                if (log_on_stop) {
                    this.adapter.trace("group = " + this.group_address + "/" + network_interface.getName() + ":" + network_interface.getDisplayName() + " - " + local_address + ": stopped");
                }
                return;
            }
            try {
                buf = new byte[8192];
                packet = new DatagramPacket(buf, buf.length);
                socket.receive(packet);
                ++successful_accepts;
                failed_accepts = 0L;
                this.receivePacket(network_interface, local_address, packet);
                continue;
            }
            catch (SocketTimeoutException e) {
                continue;
            }
            catch (Throwable e) {
                this.adapter.trace("MCGroup: receive failed on port " + port + ":" + e.getMessage());
                if (++failed_accepts > 100L && successful_accepts == 0L || failed_accepts > 1000L) ** break;
                continue;
                this.adapter.trace("    too many failures, abandoning");
                return;
            }
            break;
        }
    }

    protected void receivePacket(NetworkInterface network_interface, InetAddress local_address, DatagramPacket packet) {
        byte[] data = packet.getData();
        int len = packet.getLength();
        this.adapter.received(network_interface, local_address, (InetSocketAddress)packet.getSocketAddress(), data, len);
    }

    public void sendToMember(InetSocketAddress address, byte[] data) throws MCGroupException {
        DatagramSocket reply_socket = null;
        try {
            reply_socket = new DatagramSocket(null);
            reply_socket.setReuseAddress(true);
            reply_socket.bind(new InetSocketAddress(this.group_port));
            DatagramPacket reply_packet = new DatagramPacket(data, data.length, address);
            reply_socket.send(reply_packet);
        }
        catch (Throwable e) {
            throw new MCGroupException("sendToMember failed", e);
        }
        finally {
            if (reply_socket != null) {
                try {
                    reply_socket.close();
                }
                catch (Throwable e) {}
            }
        }
    }
}

